/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.gettersandsetters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ContainerNode;
import org.eclipse.cdt.internal.ui.refactoring.AddDeclarationNodeToClassChange;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring2;
import org.eclipse.cdt.internal.ui.refactoring.Container;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringASTCache;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.GetterSetterContext;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.GetterSetterInsertEditProvider;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.Messages;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.InsertLocation;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.MethodDefinitionInsertLocationFinder;
import org.eclipse.cdt.internal.ui.refactoring.utils.Checks;
import org.eclipse.cdt.internal.ui.refactoring.utils.NodeHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.VisibilityEnum;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateGettersAndSettersRefactoring
extends CRefactoring2 {
    private static final String MEMBER_DECLARATION = "MEMBER_DECLARATION";
    private final GetterSetterContext context = new GetterSetterContext();
    private InsertLocation definitionInsertLocation;

    public GenerateGettersAndSettersRefactoring(ICElement element, ISelection selection, ICProject project, RefactoringASTCache astCache) {
        super(element, selection, project, astCache);
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        RefactoringStatus status = super.checkInitialConditions((IProgressMonitor)sm.newChild(6));
        if (status.hasError()) {
            return status;
        }
        if (!this.initStatus.hasFatalError()) {
            this.initRefactoring(pm);
            if (this.context.existingFields.isEmpty()) {
                this.initStatus.addFatalError(Messages.GenerateGettersAndSettersRefactoring_NoFields);
            }
        }
        return this.initStatus;
    }

    @Override
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext checkContext) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        if (!this.context.isImplementationInHeader()) {
            this.findDefinitionInsertLocation(pm);
            if (this.definitionInsertLocation == null || this.tu.equals(this.definitionInsertLocation.getTranslationUnit())) {
                result.addInfo(Messages.GenerateGettersAndSettersRefactoring_NoImplFile);
            }
        }
        Checks.addModifiedFilesToChecker(this.getAllFilesToModify(), checkContext);
        return result;
    }

    private IFile[] getAllFilesToModify() {
        ArrayList<IFile> files = new ArrayList<IFile>(2);
        IFile file = (IFile)this.tu.getResource();
        if (file != null) {
            files.add(file);
        }
        if (this.definitionInsertLocation != null && (file = this.definitionInsertLocation.getFile()) != null) {
            files.add(file);
        }
        return files.toArray(new IFile[files.size()]);
    }

    private void initRefactoring(IProgressMonitor pm) throws OperationCanceledException, CoreException {
        IASTTranslationUnit ast = this.astCache.getAST(this.tu, null);
        this.context.selectedName = this.getSelectedName(ast);
        IASTCompositeTypeSpecifier compositeTypeSpecifier = null;
        compositeTypeSpecifier = this.context.selectedName != null ? this.getCompositeTypeSpecifier(this.context.selectedName) : this.findCurrentCompositeTypeSpecifier(ast);
        if (compositeTypeSpecifier != null) {
            this.findDeclarations(compositeTypeSpecifier);
        } else {
            this.initStatus.addFatalError(Messages.GenerateGettersAndSettersRefactoring_NoCassDefFound);
        }
    }

    private IASTCompositeTypeSpecifier findCurrentCompositeTypeSpecifier(IASTTranslationUnit ast) throws OperationCanceledException, CoreException {
        int start = this.selectedRegion.getOffset();
        Container container = new Container();
        ast.accept((ASTVisitor)new CompositeTypeSpecFinder(start, container));
        return (IASTCompositeTypeSpecifier)container.getObject();
    }

    private IASTCompositeTypeSpecifier getCompositeTypeSpecifier(IASTName selectedName) {
        IASTName node = selectedName;
        while (node != null && !(node instanceof IASTCompositeTypeSpecifier)) {
            node = node.getParent();
        }
        return (IASTCompositeTypeSpecifier)node;
    }

    private IASTName getSelectedName(IASTTranslationUnit ast) {
        List<IASTName> names = this.findAllMarkedNames(ast);
        if (names.size() < 1) {
            return null;
        }
        return names.get(names.size() - 1);
    }

    protected void findDeclarations(IASTCompositeTypeSpecifier compositeTypeSpecifier) {
        compositeTypeSpecifier.accept(new ASTVisitor(){
            {
                this.shouldVisitDeclarations = true;
            }

            public int visit(IASTDeclaration declaration) {
                IASTFunctionDefinition functionDefinition;
                IASTDeclarator[] declarators;
                IASTSimpleDeclaration fieldDeclaration;
                ASTNodeProperty props;
                if (declaration instanceof IASTSimpleDeclaration && (props = (fieldDeclaration = (IASTSimpleDeclaration)declaration).getPropertyInParent()).getName().contains(GenerateGettersAndSettersRefactoring.MEMBER_DECLARATION) && (declarators = fieldDeclaration.getDeclarators()).length > 0) {
                    IASTDeclarator innermostDeclarator = declarators[0];
                    while (innermostDeclarator.getNestedDeclarator() != null) {
                        innermostDeclarator = innermostDeclarator.getNestedDeclarator();
                    }
                    if (innermostDeclarator instanceof IASTFunctionDeclarator) {
                        ((GenerateGettersAndSettersRefactoring)GenerateGettersAndSettersRefactoring.this).context.existingFunctionDeclarations.add(fieldDeclaration);
                    } else if (fieldDeclaration.isPartOfTranslationUnitFile()) {
                        ((GenerateGettersAndSettersRefactoring)GenerateGettersAndSettersRefactoring.this).context.existingFields.add(fieldDeclaration);
                    }
                }
                if (declaration instanceof IASTFunctionDefinition && (props = (functionDefinition = (IASTFunctionDefinition)declaration).getPropertyInParent()).getName().contains(GenerateGettersAndSettersRefactoring.MEMBER_DECLARATION)) {
                    ((GenerateGettersAndSettersRefactoring)GenerateGettersAndSettersRefactoring.this).context.existingFunctionDefinitions.add(functionDefinition);
                }
                return super.visit(declaration);
            }
        });
    }

    @Override
    protected void collectModifications(IProgressMonitor pm, ModificationCollector collector) throws CoreException, OperationCanceledException {
        ArrayList<IASTNode> getterAndSetters = new ArrayList<IASTNode>();
        ArrayList<IASTFunctionDefinition> definitions = new ArrayList<IASTFunctionDefinition>();
        for (GetterSetterInsertEditProvider currentProvider : this.context.selectedFunctions) {
            if (this.context.isImplementationInHeader()) {
                getterAndSetters.add((IASTNode)currentProvider.getFunctionDefinition(false));
                continue;
            }
            getterAndSetters.add((IASTNode)currentProvider.getFunctionDeclaration());
            definitions.add(currentProvider.getFunctionDefinition(true));
        }
        if (!this.context.isImplementationInHeader()) {
            this.addDefinition(collector, definitions, pm);
        }
        ICPPASTCompositeTypeSpecifier classDefinition = (ICPPASTCompositeTypeSpecifier)this.context.existingFields.get(this.context.existingFields.size() - 1).getParent();
        AddDeclarationNodeToClassChange.createChange(classDefinition, VisibilityEnum.v_public, getterAndSetters, false, collector);
    }

    private void addDefinition(ModificationCollector collector, List<IASTFunctionDefinition> definitions, IProgressMonitor pm) throws CoreException {
        this.findDefinitionInsertLocation(pm);
        IASTNode parent = this.definitionInsertLocation.getParentOfNodeToInsertBefore();
        IASTTranslationUnit ast = parent.getTranslationUnit();
        ASTRewrite rewrite = collector.rewriterForTranslationUnit(ast);
        IASTNode nodeToInsertBefore = this.definitionInsertLocation.getNodeToInsertBefore();
        ContainerNode cont = new ContainerNode(new IASTNode[0]);
        for (IASTFunctionDefinition functionDefinition : definitions) {
            cont.addNode((IASTNode)functionDefinition);
        }
        rewrite = rewrite.insertBefore(parent, nodeToInsertBefore, (IASTNode)cont, null);
    }

    public GetterSetterContext getContext() {
        return this.context;
    }

    private void findDefinitionInsertLocation(IProgressMonitor pm) throws CoreException {
        if (this.definitionInsertLocation != null) {
            return;
        }
        MethodDefinitionInsertLocationFinder methodDefinitionInsertLocationFinder = new MethodDefinitionInsertLocationFinder();
        IASTSimpleDeclaration decl = this.context.existingFields.get(0);
        InsertLocation location = methodDefinitionInsertLocationFinder.find(this.tu, decl.getFileLocation(), decl.getParent(), this.astCache, pm);
        if (location.getFile() == null || NodeHelper.isContainedInTemplateDeclaration((IASTNode)decl)) {
            location.setNodeToInsertAfter(NodeHelper.findTopLevelParent((IASTNode)decl), this.tu);
        }
        this.definitionInsertLocation = location;
    }

    @Override
    protected RefactoringDescriptor getRefactoringDescriptor() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CompositeTypeSpecFinder
    extends ASTVisitor {
        private final int start;
        private final Container<IASTCompositeTypeSpecifier> container;

        private CompositeTypeSpecFinder(int start, Container<IASTCompositeTypeSpecifier> container) {
            this.shouldVisitDeclSpecifiers = true;
            this.start = start;
            this.container = container;
        }

        public int visit(IASTDeclSpecifier declSpec) {
            IASTFileLocation loc;
            if (declSpec instanceof IASTCompositeTypeSpecifier && this.start > (loc = declSpec.getFileLocation()).getNodeOffset() && this.start < loc.getNodeOffset() + loc.getNodeLength()) {
                this.container.setObject((IASTCompositeTypeSpecifier)declSpec);
                return 2;
            }
            return super.visit(declSpec);
        }
    }
}

