/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.hidemethod;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.ui.refactoring.AddDeclarationNodeToClassChange;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.hidemethod.HideMethodRefactoringDescription;
import org.eclipse.cdt.internal.ui.refactoring.hidemethod.Messages;
import org.eclipse.cdt.internal.ui.refactoring.utils.DeclarationFinder;
import org.eclipse.cdt.internal.ui.refactoring.utils.DeclarationFinderDO;
import org.eclipse.cdt.internal.ui.refactoring.utils.ExpressionFinder;
import org.eclipse.cdt.internal.ui.refactoring.utils.NodeHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.TranslationUnitHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.VisibilityEnum;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HideMethodRefactoring
extends CRefactoring {
    public static final String ID = "org.eclipse.cdt.internal.ui.refactoring.hidemethod.HideMethodRefactoring";
    private IASTName methodToHide;
    private IASTDeclaration methodToHideDecl;
    private DeclarationFinderDO declData;

    public HideMethodRefactoring(IFile file, ISelection selection, ICElement element, ICProject project) {
        super(file, selection, element, project);
        this.name = Messages.HideMethodRefactoring_HIDE_METHOD;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        try {
            this.lockIndex();
            try {
                IASTFunctionDeclarator declarator;
                super.checkInitialConditions((IProgressMonitor)sm.newChild(6));
                if (this.initStatus.hasFatalError()) {
                    RefactoringStatus refactoringStatus = this.initStatus;
                    return refactoringStatus;
                }
                if (HideMethodRefactoring.isProgressMonitorCanceld((IProgressMonitor)sm, this.initStatus)) {
                    RefactoringStatus refactoringStatus = this.initStatus;
                    return refactoringStatus;
                }
                ArrayList<IASTName> names = this.findAllMarkedNames();
                if (names.size() < 1) {
                    this.initStatus.addFatalError(Messages.HideMethodRefactoring_NoNameSelected);
                    RefactoringStatus refactoringStatus = this.initStatus;
                    return refactoringStatus;
                }
                IASTName name = names.get(names.size() - 1);
                sm.worked(1);
                if (HideMethodRefactoring.isProgressMonitorCanceld((IProgressMonitor)sm, this.initStatus)) {
                    RefactoringStatus refactoringStatus = this.initStatus;
                    return refactoringStatus;
                }
                this.declData = DeclarationFinder.getDeclaration(name, this.getIndex());
                if (this.declData == null || this.declData.name == null) {
                    this.initStatus.addFatalError(Messages.HideMethodRefactoring_NoMethodNameSelected);
                    RefactoringStatus refactoringStatus = this.initStatus;
                    return refactoringStatus;
                }
                this.methodToHide = this.declData.name;
                sm.worked(1);
                this.methodToHideDecl = NodeHelper.findSimpleDeclarationInParents((IASTNode)this.methodToHide);
                if (this.methodToHideDecl == null) {
                    this.initStatus.addFatalError(Messages.HideMethodRefactoring_CanOnlyHideMethods);
                    RefactoringStatus refactoringStatus = this.initStatus;
                    return refactoringStatus;
                }
                if (!(this.methodToHideDecl.getParent() instanceof ICPPASTCompositeTypeSpecifier)) {
                    this.methodToHideDecl = NodeHelper.findFunctionDefinitionInAncestors((IASTNode)this.methodToHide);
                }
                if (HideMethodRefactoring.isProgressMonitorCanceld((IProgressMonitor)sm, this.initStatus)) {
                    RefactoringStatus refactoringStatus = this.initStatus;
                    return refactoringStatus;
                }
                sm.worked(1);
                if (this.methodToHideDecl instanceof IASTFunctionDefinition) {
                    declarator = ((IASTFunctionDefinition)this.methodToHideDecl).getDeclarator();
                    if (CPPVisitor.findInnermostDeclarator((IASTDeclarator)declarator).getName().getRawSignature().equals(name.getRawSignature()) && !(declarator instanceof IASTFunctionDeclarator)) {
                        this.initStatus.addFatalError(Messages.HideMethodRefactoring_CanOnlyHideMethods);
                        RefactoringStatus refactoringStatus = this.initStatus;
                        return refactoringStatus;
                    }
                } else {
                    if (!(this.methodToHideDecl instanceof IASTSimpleDeclaration)) {
                        this.initStatus.addFatalError(Messages.HideMethodRefactoring_CanOnlyHideMethods);
                        RefactoringStatus refactoringStatus = this.initStatus;
                        return refactoringStatus;
                    }
                    IASTDeclarator[] iASTDeclaratorArray = ((IASTSimpleDeclaration)this.methodToHideDecl).getDeclarators();
                    int n = iASTDeclaratorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        declarator = iASTDeclaratorArray[n2];
                        if (declarator.getName().getRawSignature().equals(name.getRawSignature()) && !(declarator instanceof IASTFunctionDeclarator)) {
                            this.initStatus.addFatalError(Messages.HideMethodRefactoring_CanOnlyHideMethods);
                            RefactoringStatus refactoringStatus = this.initStatus;
                            return refactoringStatus;
                        }
                        ++n2;
                    }
                }
                sm.worked(1);
                IASTCompositeTypeSpecifier classNode = NodeHelper.findClassInAncestors((IASTNode)this.methodToHide);
                if (classNode == null) {
                    this.initStatus.addError(Messages.HideMethodRefactoring_EnclosingClassNotFound);
                }
                if (this.checkIfPrivate(classNode, this.methodToHideDecl)) {
                    this.initStatus.addError(Messages.HideMethodRefactoring_IsAlreadyPrivate);
                }
                sm.done();
                return this.initStatus;
            }
            finally {
                this.unlockIndex();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return this.initStatus;
    }

    private boolean checkIfPrivate(IASTCompositeTypeSpecifier classNode, IASTDeclaration decl) {
        IASTDeclaration[] members = classNode.getMembers();
        int currentVisibility = 3;
        if (1 == classNode.getKey()) {
            currentVisibility = 1;
        }
        IASTDeclaration[] iASTDeclarationArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration declaration = iASTDeclarationArray[n2];
            if (declaration instanceof ICPPASTVisibilityLabel) {
                currentVisibility = ((ICPPASTVisibilityLabel)declaration).getVisibility();
            }
            if (declaration != null && decl == declaration) break;
            ++n2;
        }
        return 3 == currentVisibility;
    }

    @Override
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus refactoringStatus;
        RefactoringStatus finalConditions = null;
        this.lockIndex();
        try {
            finalConditions = super.checkFinalConditions(pm);
            IIndexName[] iIndexNameArray = this.declData.allNamesPDom;
            int n = this.declData.allNamesPDom.length;
            int n2 = 0;
            while (n2 < n) {
                PDOMName pdomName;
                IIndexName pdomref = iIndexNameArray[n2];
                this.declData.filename = pdomref.getFileLocation().getFileName();
                if (!(pdomref instanceof PDOMName) || !(pdomName = (PDOMName)pdomref).isDeclaration() && !pdomName.isDefinition()) {
                    IASTTranslationUnit transUtmp = TranslationUnitHelper.loadTranslationUnit(this.declData.filename, false);
                    IASTName expName = ExpressionFinder.findExpressionInTranslationUnit(transUtmp, pdomref);
                    IASTFunctionDeclarator funcDec = this.findEnclosingFunction((IASTNode)expName);
                    IASTCompositeTypeSpecifier encClass2 = funcDec == null ? NodeHelper.findClassInAncestors((IASTNode)expName) : NodeHelper.findClassInAncestors((IASTNode)funcDec);
                    IASTCompositeTypeSpecifier encClass = NodeHelper.findClassInAncestors((IASTNode)this.methodToHide);
                    if (!NodeHelper.isSameNode((IASTNode)encClass, (IASTNode)encClass2)) {
                        finalConditions.addWarning(Messages.HideMethodRefactoring_HasExternalReferences);
                        break;
                    }
                }
                ++n2;
            }
            refactoringStatus = finalConditions;
        }
        catch (Throwable throwable) {
            try {
                this.unlockIndex();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return finalConditions;
            }
        }
        this.unlockIndex();
        return refactoringStatus;
    }

    private IASTFunctionDeclarator findEnclosingFunction(IASTNode node) throws CoreException {
        IASTCompoundStatement compStat = NodeHelper.findCompoundStatementInAncestors(node);
        if (compStat == null) {
            return null;
        }
        IASTNode parent = compStat.getParent();
        if (parent instanceof IASTFunctionDefinition) {
            IASTFunctionDeclarator declarator = ((IASTFunctionDefinition)parent).getDeclarator();
            IASTName declaratorName = this.getLastName(CPPVisitor.findInnermostDeclarator((IASTDeclarator)declarator));
            DeclarationFinderDO data = DeclarationFinder.getDeclaration(declaratorName, this.getIndex());
            if (data == null || data.name == null) {
                return null;
            }
            if (data.name.getParent() instanceof IASTFunctionDeclarator) {
                return (IASTFunctionDeclarator)data.name.getParent();
            }
            return null;
        }
        if (parent instanceof IASTTranslationUnit) {
            return null;
        }
        return this.findEnclosingFunction(parent);
    }

    private IASTName getLastName(IASTDeclarator declarator) {
        IASTName declaratorName = declarator.getName();
        if (declaratorName instanceof ICPPASTQualifiedName) {
            IASTName[] declaratorNames = ((ICPPASTQualifiedName)declaratorName).getNames();
            declaratorName = declaratorNames[declaratorNames.length - 1];
        }
        return declaratorName;
    }

    @Override
    protected void collectModifications(IProgressMonitor pm, ModificationCollector collector) throws CoreException, OperationCanceledException {
        try {
            this.lockIndex();
            try {
                ASTRewrite rewriter = collector.rewriterForTranslationUnit(this.declData.transUnit);
                TextEditGroup editGroup = new TextEditGroup(String.valueOf(Messages.HideMethodRefactoring_FILE_CHANGE_TEXT) + this.methodToHide.getRawSignature());
                ICPPASTCompositeTypeSpecifier classDefinition = (ICPPASTCompositeTypeSpecifier)this.methodToHideDecl.getParent();
                AddDeclarationNodeToClassChange.createChange(classDefinition, VisibilityEnum.v_private, (IASTNode)this.methodToHideDecl, false, collector);
                rewriter.remove((IASTNode)this.methodToHideDecl, editGroup);
            }
            finally {
                this.unlockIndex();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    protected RefactoringDescriptor getRefactoringDescriptor() {
        Map<String, String> arguments = this.getArgumentMap();
        HideMethodRefactoringDescription desc = new HideMethodRefactoringDescription(this.project.getProject().getName(), "Hide Method Refactoring", "Hide Method " + this.methodToHide.getRawSignature(), arguments);
        return desc;
    }

    private Map<String, String> getArgumentMap() {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("fileName", this.file.getLocationURI().toString());
        arguments.put("selection", String.valueOf(this.region.getOffset()) + "," + this.region.getLength());
        return arguments;
    }
}

