/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameProcessor;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameRefactoringPreferences;
import org.eclipse.cdt.internal.ui.refactoring.rename.RenameMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class CRenameRefactoringInputPage
extends UserInputWizardPage {
    public static final String PAGE_NAME = "RenameRefactoringPage";
    final CRenameRefactoringPreferences fPreferences = new CRenameRefactoringPreferences();
    private String fSearchString;
    private int fOptions;
    private int fForcePreviewOptions = 0;
    private int fEnableScopeOptions;
    private Text fNewName;
    private Button fDoVirtual;
    private Button fWorkspace;
    private Button fDependent;
    private Button fInComment;
    private Button fInString;
    private Button fInInclude;
    private Button fInInactiveCode;
    private Button fReferences;
    private Button fSingle;
    private Button fWorkingSet;
    private Text fWorkingSetSpec;
    private Button fWorkingSetButton;
    private Button fInMacro;
    private Button fInPreprocessor;
    private Button fExhausiveFileSearch;

    public CRenameRefactoringInputPage() {
        super(PAGE_NAME);
    }

    private boolean hasOption(int options) {
        return (this.fOptions & options) == options;
    }

    public void createControl(Composite parent) {
        GridData gd;
        CRenameProcessor processor = this.getRenameProcessor();
        this.fSearchString = processor.getArgument().getName();
        this.fOptions = processor.getAvailableOptions();
        this.fForcePreviewOptions = processor.getOptionsForcingPreview();
        this.fEnableScopeOptions = processor.getOptionsEnablingScope();
        Composite top = new Composite(parent, 0);
        this.initializeDialogUnits((Control)top);
        this.setControl((Control)top);
        top.setLayout((Layout)new GridLayout(2, false));
        Composite group = top;
        Label label = new Label(top, 0);
        label.setText(RenameMessages.CRenameRefactoringInputPage_label_newName);
        this.fNewName = new Text(top, 2048);
        this.fNewName.setText(this.fSearchString);
        this.fNewName.setLayoutData((Object)new GridData(768));
        this.fNewName.selectAll();
        if (this.hasOption(256)) {
            this.fDoVirtual = new Button(top, 32);
            this.fDoVirtual.setText(RenameMessages.CRenameRefactoringInputPage_renameBaseAndDerivedMethods);
            gd = new GridData();
            this.fDoVirtual.setLayoutData((Object)gd);
            gd.horizontalSpan = 2;
        }
        if (this.hasOption(1)) {
            this.skipLine(top);
            label = new Label(top, 0);
            label.setText(RenameMessages.CRenameRefactoringInputPage_label_scope);
            gd = new GridData(768);
            label.setLayoutData((Object)gd);
            gd.horizontalSpan = 2;
            group = new Composite(top, 0);
            gd = new GridData(768);
            group.setLayoutData((Object)gd);
            gd.horizontalSpan = 2;
            GridLayout gl = new GridLayout(4, false);
            group.setLayout((Layout)gl);
            gl.marginHeight = 0;
            gl.marginLeft = gl.marginWidth;
            gl.marginWidth = 0;
            this.fWorkspace = new Button(group, 16);
            this.fWorkspace.setText(RenameMessages.CRenameRefactoringInputPage_button_workspace);
            gd = new GridData();
            this.fWorkspace.setLayoutData((Object)gd);
            this.fDependent = new Button(group, 16);
            this.fDependent.setText(RenameMessages.CRenameRefactoringInputPage_button_relatedProjects);
            gd = new GridData(32);
            this.fDependent.setLayoutData((Object)gd);
            gd.horizontalIndent = 8;
            this.fSingle = new Button(group, 16);
            this.fSingle.setText(RenameMessages.CRenameRefactoringInputPage_button_singleProject);
            gd = new GridData(32);
            this.fSingle.setLayoutData((Object)gd);
            gd.horizontalIndent = 8;
            gd.horizontalSpan = 2;
            this.fWorkingSet = new Button(group, 16);
            this.fWorkingSet.setText(RenameMessages.CRenameRefactoringInputPage_button_workingSet);
            this.fWorkingSetSpec = new Text(group, 2060);
            gd = new GridData(768);
            this.fWorkingSetSpec.setLayoutData((Object)gd);
            gd.horizontalIndent = 8;
            gd.horizontalSpan = 2;
            this.fWorkingSetButton = new Button(group, 8);
            this.fWorkingSetButton.setText(RenameMessages.CRenameRefactoringInputPage_button_chooseWorkingSet);
            this.setButtonLayoutData(this.fWorkingSetButton);
        }
        boolean skippedLine = false;
        group = null;
        if (this.hasOption(128)) {
            group = this.createLabelAndGroup(group, skippedLine, top);
            this.fReferences = new Button(group, 32);
            this.fReferences.setText(RenameMessages.CRenameRefactoringInputPage_button_sourceCode);
        }
        if (this.hasOption(64)) {
            group = this.createLabelAndGroup(group, skippedLine, top);
            this.fInInactiveCode = new Button(group, 32);
            this.fInInactiveCode.setText(RenameMessages.CRenameRefactoringInputPage_button_inactiveCode);
        }
        if (this.hasOption(2)) {
            group = this.createLabelAndGroup(group, skippedLine, top);
            this.fInComment = new Button(group, 32);
            this.fInComment.setText(RenameMessages.CRenameRefactoringInputPage_button_comments);
        }
        if (this.hasOption(4)) {
            group = this.createLabelAndGroup(group, skippedLine, top);
            this.fInString = new Button(group, 32);
            this.fInString.setText(RenameMessages.CRenameRefactoringInputPage_button_strings);
        }
        if (this.hasOption(16)) {
            group = this.createLabelAndGroup(group, skippedLine, top);
            this.fInMacro = new Button(group, 32);
            this.fInMacro.setText(RenameMessages.CRenameRefactoringInputPage_button_macroDefinitions);
        }
        if (this.hasOption(8)) {
            group = this.createLabelAndGroup(group, skippedLine, top);
            this.fInInclude = new Button(group, 32);
            this.fInInclude.setText(RenameMessages.CRenameRefactoringInputPage_button_includes);
        }
        if (this.hasOption(32)) {
            group = this.createLabelAndGroup(group, skippedLine, top);
            this.fInPreprocessor = new Button(group, 32);
            this.fInPreprocessor.setText(RenameMessages.CRenameRefactoringInputPage_button_preprocessor);
        }
        if (this.hasOption(512)) {
            this.skipLine(top);
            this.fExhausiveFileSearch = new Button(top, 32);
            this.fExhausiveFileSearch.setText(RenameMessages.CRenameRefactoringInputPage_button_exhaustiveFileSearch);
            gd = new GridData();
            this.fExhausiveFileSearch.setLayoutData((Object)gd);
            gd.horizontalIndent = 5;
            gd.horizontalSpan = 2;
        }
        Dialog.applyDialogFont((Control)top);
        this.hookSelectionListeners();
        this.readPreferences();
        this.onSelectOption();
        this.updatePageComplete();
    }

    private Composite createLabelAndGroup(Composite group, boolean skippedLine, Composite top) {
        if (group != null) {
            return group;
        }
        if (!skippedLine) {
            this.skipLine(top);
        }
        Label label = new Label(top, 0);
        label.setText(RenameMessages.CRenameRefactoringInputPage_label_updateWithin);
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        gd.horizontalSpan = 2;
        group = new Composite(top, 0);
        gd = new GridData();
        group.setLayoutData((Object)gd);
        gd.horizontalSpan = 2;
        group.setLayout((Layout)new GridLayout(1, true));
        return group;
    }

    private void skipLine(Composite top) {
        new Label(top, 0);
        new Label(top, 0);
    }

    private void hookSelectionListeners() {
        this.fNewName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CRenameRefactoringInputPage.this.onKeyReleaseInNameField();
            }
        });
        this.registerScopeListener(this.fWorkspace, 2);
        this.registerScopeListener(this.fDependent, 3);
        this.registerScopeListener(this.fSingle, 4);
        this.registerScopeListener(this.fWorkingSet, 5);
        if (this.fWorkingSetButton != null) {
            this.fWorkingSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CRenameRefactoringInputPage.this.onSelectWorkingSet();
                }
            });
        }
        SelectionAdapter listenOption = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CRenameRefactoringInputPage.this.onSelectOption();
            }
        };
        this.registerOptionListener(this.fDoVirtual, (SelectionListener)listenOption);
        this.registerOptionListener(this.fReferences, (SelectionListener)listenOption);
        this.registerOptionListener(this.fInComment, (SelectionListener)listenOption);
        this.registerOptionListener(this.fInInactiveCode, (SelectionListener)listenOption);
        this.registerOptionListener(this.fInInclude, (SelectionListener)listenOption);
        this.registerOptionListener(this.fInMacro, (SelectionListener)listenOption);
        this.registerOptionListener(this.fInString, (SelectionListener)listenOption);
        this.registerOptionListener(this.fInPreprocessor, (SelectionListener)listenOption);
        this.registerOptionListener(this.fExhausiveFileSearch, (SelectionListener)listenOption);
    }

    private void registerScopeListener(Button button, final int scope) {
        if (button != null) {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CRenameRefactoringInputPage.this.onSelectedScope(scope);
                }
            });
        }
    }

    private void registerOptionListener(Button button, SelectionListener listenOption) {
        if (button != null) {
            button.addSelectionListener(listenOption);
        }
    }

    protected void onSelectedScope(int scope) {
        this.getRenameProcessor().setScope(scope);
        this.updateEnablement();
    }

    private void onSelectOption() {
        int selectedOptions = this.computeSelectedOptions();
        boolean forcePreview = this.fForcePreviewOptions == -1 || (selectedOptions & this.fForcePreviewOptions) != 0;
        this.getRenameProcessor().setSelectedOptions(selectedOptions);
        this.getRefactoringWizard().setForcePreviewReview(forcePreview);
        this.updateEnablement();
    }

    protected void onKeyReleaseInNameField() {
        this.getRenameProcessor().setReplacementText(this.fNewName.getText());
        this.updatePageComplete();
    }

    public void dispose() {
        this.storePreferences();
        super.dispose();
    }

    private void readPreferences() {
        boolean val;
        CRenameProcessor processor = this.getRenameProcessor();
        if (this.fWorkspace != null) {
            int scope = this.fPreferences.getScope();
            switch (scope) {
                case 2: {
                    this.fWorkspace.setSelection(true);
                    break;
                }
                case 4: {
                    this.fSingle.setSelection(true);
                    break;
                }
                case 5: {
                    this.fWorkingSet.setSelection(true);
                    break;
                }
                default: {
                    scope = 3;
                    this.fDependent.setSelection(true);
                }
            }
            processor.setScope(scope);
            String workingSet = this.fPreferences.getWorkingSet();
            processor.setWorkingSet(workingSet);
            this.fWorkingSetSpec.setText(processor.getWorkingSet());
        }
        if (this.fDoVirtual != null) {
            val = !this.fPreferences.getBoolean("ignoreVirtual");
            this.fDoVirtual.setSelection(val);
        }
        if (this.fReferences != null) {
            val = !this.fPreferences.getBoolean("references_inv");
            this.fReferences.setSelection(val);
        }
        this.initOption(this.fInComment, "comment");
        this.initOption(this.fInString, "string");
        this.initOption(this.fInInclude, "include");
        this.initOption(this.fInMacro, "macroDefinition");
        this.initOption(this.fInPreprocessor, "preprocessor");
        this.initOption(this.fInInactiveCode, "inactive");
        this.initOption(this.fExhausiveFileSearch, "exhausiveFileSearch");
    }

    private int computeSelectedOptions() {
        int options = 0;
        options |= this.computeOption(this.fDoVirtual, 256);
        options |= this.computeOption(this.fReferences, 128);
        options |= this.computeOption(this.fInComment, 2);
        options |= this.computeOption(this.fInString, 4);
        options |= this.computeOption(this.fInInclude, 8);
        options |= this.computeOption(this.fInMacro, 16);
        options |= this.computeOption(this.fInPreprocessor, 32);
        options |= this.computeOption(this.fInInactiveCode, 64);
        return options |= this.computeOption(this.fExhausiveFileSearch, 512);
    }

    private int computeOption(Button button, int option) {
        if (button != null && button.getSelection()) {
            return option;
        }
        return 0;
    }

    private void initOption(Button button, String key) {
        boolean val = false;
        if (button != null) {
            val = this.fPreferences.getBoolean(key);
            button.setSelection(val);
        }
    }

    private void storePreferences() {
        if (this.fWorkspace != null) {
            int choice = 3;
            if (this.fWorkspace.getSelection()) {
                choice = 2;
            } else if (this.fSingle.getSelection()) {
                choice = 4;
            } else if (this.fWorkingSet.getSelection()) {
                choice = 5;
            }
            this.fPreferences.put("scope", choice);
            this.fPreferences.put("workingset", this.fWorkingSetSpec.getText());
        }
        if (this.fDoVirtual != null) {
            this.fPreferences.put("ignoreVirtual", !this.fDoVirtual.getSelection());
        }
        if (this.fReferences != null) {
            this.fPreferences.put("references_inv", !this.fReferences.getSelection());
        }
        if (this.fInComment != null) {
            this.fPreferences.put("comment", this.fInComment.getSelection());
        }
        if (this.fInString != null) {
            this.fPreferences.put("string", this.fInString.getSelection());
        }
        if (this.fInInclude != null) {
            this.fPreferences.put("include", this.fInInclude.getSelection());
        }
        if (this.fInPreprocessor != null) {
            this.fPreferences.put("preprocessor", this.fInPreprocessor.getSelection());
        }
        if (this.fInMacro != null) {
            this.fPreferences.put("macroDefinition", this.fInMacro.getSelection());
        }
        if (this.fInInactiveCode != null) {
            this.fPreferences.put("inactive", this.fInInactiveCode.getSelection());
        }
        if (this.fExhausiveFileSearch != null) {
            this.fPreferences.put("exhausiveFileSearch", this.fExhausiveFileSearch.getSelection());
        }
    }

    protected void onSelectWorkingSet() {
        CRenameProcessor processor = this.getRenameProcessor();
        String wsName = this.fWorkingSetSpec.getText();
        IWorkingSetManager wsManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dlg = wsManager.createWorkingSetSelectionDialog(this.getShell(), false);
        IWorkingSet currentWorkingSet = wsManager.getWorkingSet(wsName);
        if (currentWorkingSet != null) {
            dlg.setSelection(new IWorkingSet[]{currentWorkingSet});
        }
        IWorkingSet ws = null;
        if (dlg.open() == 0) {
            IWorkingSet[] wsa = dlg.getSelection();
            if (wsa != null && wsa.length > 0) {
                ws = wsa[0];
            }
            if (ws != null) {
                this.fWorkspace.setSelection(false);
                this.fDependent.setSelection(false);
                this.fSingle.setSelection(false);
                this.fWorkingSet.setSelection(true);
                processor.setScope(5);
                wsName = ws.getName();
            }
        }
        processor.setWorkingSet(wsName);
        this.fWorkingSetSpec.setText(processor.getWorkingSet());
        this.updateEnablement();
    }

    protected void updatePageComplete() {
        String txt = this.fNewName.getText();
        if (txt.length() == 0 || txt.equals(this.fSearchString)) {
            this.setErrorMessage(null);
            this.setPageComplete(false);
        } else if (!CConventions.isValidIdentifier((String)txt)) {
            this.setErrorMessage(NLS.bind((String)RenameMessages.CRenameRefactoringInputPage_errorInvalidIdentifier, (Object)txt));
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    protected void updateEnablement() {
        boolean enable;
        boolean bl = enable = this.fEnableScopeOptions == -1 || (this.computeSelectedOptions() & this.fEnableScopeOptions) != 0;
        if (this.fWorkspace != null) {
            this.fWorkspace.setEnabled(enable);
            this.fDependent.setEnabled(enable);
            this.fSingle.setEnabled(enable);
            boolean enableSpec = false;
            this.fWorkingSet.setEnabled(enable);
            if (enable && this.fWorkingSet.getSelection()) {
                enableSpec = true;
            }
            this.fWorkingSetSpec.setEnabled(enableSpec);
            this.fWorkingSetButton.setEnabled(enable);
        }
    }

    private CRenameProcessor getRenameProcessor() {
        return (CRenameProcessor)((CRenameRefactoring)this.getRefactoring()).getProcessor();
    }
}

