/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class EclipseObjects {
    public static IWorkbenchPage getActivePage() {
        return EclipseObjects.getActiveWindow().getActivePage();
    }

    public static IEditorPart getActiveEditor() {
        IEditorPart editor = null;
        IWorkbenchPage page = EclipseObjects.getActivePage();
        if (page.isEditorAreaVisible() && page.getActiveEditor() != null && page.getActiveEditor() instanceof TextEditor) {
            editor = page.getActiveEditor();
        }
        return editor;
    }

    public static IEditorPart getEditorForFile(IFile file) {
        IEditorReference[] editors;
        IWorkbenchPage page = EclipseObjects.getActivePage();
        IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            CEditor edi;
            IResource resource;
            IEditorReference editor2 = iEditorReferenceArray[n2];
            IEditorPart editor = editor2.getEditor(false);
            if (editor instanceof CEditor && (resource = (edi = (CEditor)editor).getInputCElement().getResource()) instanceof IFile && ((IFile)resource).equals((Object)file)) {
                return editor;
            }
            ++n2;
        }
        return null;
    }

    public static IFile getActiveFile() {
        IEditorInput editorInput = EclipseObjects.getActiveEditor().getEditorInput();
        IFile aFile = null;
        if (editorInput instanceof IFileEditorInput) {
            aFile = ((IFileEditorInput)editorInput).getFile();
        }
        return aFile;
    }

    public static IDocument getActiveDocument() {
        return EclipseObjects.getDocument(EclipseObjects.getActiveEditor());
    }

    public static IDocument getDocument(IEditorPart editor) {
        ITextEditor txtEditor = (ITextEditor)editor;
        IDocumentProvider prov = txtEditor.getDocumentProvider();
        return prov.getDocument((Object)txtEditor.getEditorInput());
    }

    public static IWorkbenchWindow getActiveWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static IDocument getDocument(IFile file) {
        IEditorPart editor = EclipseObjects.getEditorForFile(file);
        return EclipseObjects.getDocument(editor);
    }

    public static IFile getFile(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IFile file = EclipseObjects.getFile((IStructuredSelection)selection);
            return file;
        }
        return EclipseObjects.getActiveFile();
    }

    private static IFile getFile(IStructuredSelection selection) {
        ICElement e;
        IResource r;
        IFile file = null;
        Object o = selection.getFirstElement();
        if (o instanceof ICElement && (r = (e = (ICElement)o).getUnderlyingResource()) instanceof IFile) {
            file = (IFile)r;
        }
        return file;
    }

    public static IFile getFileForPathString(String path) {
        Path ipath = new Path(path);
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)ipath);
    }

    public static IFile getFile(IASTNode node) {
        if (node == null) {
            return null;
        }
        return EclipseObjects.getFileForPathString(node.getFileLocation().getFileName());
    }
}

