/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.ASTNameCollector;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTFunctionStyleMacroParameter;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorFunctionStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.core.model.ext.CElementHandleFactory;
import org.eclipse.cdt.internal.core.model.ext.ICElementHandle;
import org.eclipse.cdt.internal.ui.actions.OpenActionUtil;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.search.actions.OpenDeclarationsAction;
import org.eclipse.cdt.internal.ui.search.actions.SelectionParseAction;
import org.eclipse.cdt.internal.ui.viewsupport.IndexUI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OpenDeclarationsJob
extends Job
implements ASTCache.ASTRunnable {
    private final SelectionParseAction fAction;
    private IProgressMonitor fMonitor;
    private final ITranslationUnit fTranslationUnit;
    private IIndex fIndex;
    private final ITextSelection fTextSelection;
    private final String fSelectedText;

    OpenDeclarationsJob(SelectionParseAction action, ITranslationUnit editorInput, ITextSelection textSelection, String text) {
        super(CEditorMessages.OpenDeclarations_dialog_title);
        this.fAction = action;
        this.fTranslationUnit = editorInput;
        this.fTextSelection = textSelection;
        this.fSelectedText = text;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            return this.performNavigation(monitor);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    IStatus performNavigation(IProgressMonitor monitor) throws CoreException {
        this.fAction.clearStatusLine();
        assert (this.fIndex == null);
        if (this.fIndex != null) {
            return Status.CANCEL_STATUS;
        }
        this.fMonitor = monitor;
        this.fIndex = CCorePlugin.getIndexManager().getIndex(this.fTranslationUnit.getCProject(), 3);
        try {
            this.fIndex.acquireReadLock();
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        try {
            IStatus iStatus = ASTProvider.getASTProvider().runOnAST((ICElement)this.fTranslationUnit, ASTProvider.WAIT_ACTIVE_ONLY, monitor, this);
            return iStatus;
        }
        finally {
            this.fIndex.releaseReadLock();
        }
    }

    public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) throws CoreException {
        if (ast == null) {
            return Status.OK_STATUS;
        }
        int selectionStart = this.fTextSelection.getOffset();
        int selectionLength = this.fTextSelection.getLength();
        IASTNodeSelector nodeSelector = ast.getNodeSelector(null);
        IASTName sourceName = nodeSelector.findEnclosingName(selectionStart, selectionLength);
        Object[] implicitTargets = this.findImplicitTargets(ast, nodeSelector, selectionStart, selectionLength);
        if (sourceName == null) {
            if (implicitTargets.length > 0 && this.navigateViaCElements(this.fTranslationUnit.getCProject(), this.fIndex, (IName[])implicitTargets)) {
                return Status.OK_STATUS;
            }
        } else {
            boolean found = false;
            IASTNode parent = sourceName.getParent();
            if (parent instanceof IASTPreprocessorIncludeStatement) {
                this.openInclude((IASTPreprocessorIncludeStatement)parent);
                return Status.OK_STATUS;
            }
            NameKind kind = OpenDeclarationsJob.getNameKind((IName)sourceName);
            IBinding b = sourceName.resolveBinding();
            IBinding[] bindings = new IBinding[]{b};
            if (b instanceof IProblemBinding) {
                IBinding[] candidateBindings = ((IProblemBinding)b).getCandidateBindings();
                if (candidateBindings.length != 0) {
                    bindings = candidateBindings;
                }
            } else if (kind == NameKind.DEFINITION && b instanceof IType) {
                this.navigateToName((IName)sourceName);
                return Status.OK_STATUS;
            }
            Object[] targets = IName.EMPTY_ARRAY;
            String filename = ast.getFilePath();
            IBinding[] iBindingArray = bindings;
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                IBinding binding = iBindingArray[n2];
                if (binding != null && !(binding instanceof IProblemBinding)) {
                    IName[] names;
                    IName[] iNameArray = names = this.findDeclNames(ast, kind, binding);
                    int n3 = names.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IName name = iNameArray[n4];
                        if (!(name == null || name instanceof IIndexName && filename.equals(((IIndexName)name).getFileLocation().getFileName()) || this.areOverlappingNames(name, (IName)sourceName))) {
                            if (binding instanceof IParameter) {
                                if (OpenDeclarationsJob.isInSameFunction(sourceName, name)) {
                                    targets = (IName[])ArrayUtil.append((Object[])targets, (Object)name);
                                }
                            } else if (binding instanceof ICPPTemplateParameter) {
                                if (OpenDeclarationsJob.isInSameTemplate(sourceName, name)) {
                                    targets = (IName[])ArrayUtil.append((Object[])targets, (Object)name);
                                }
                            } else {
                                targets = (IName[])ArrayUtil.append((Object[])targets, (Object)name);
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            targets = (IName[])ArrayUtil.trim((Object[])((IName[])ArrayUtil.addAll((Object[])targets, (Object[])implicitTargets)));
            found = this.navigateViaCElements(this.fTranslationUnit.getCProject(), this.fIndex, (IName[])targets) ? true : this.navigateOneLocation((IName[])targets);
            if (!found && !this.navigationFallBack(ast, sourceName, kind)) {
                this.fAction.reportSymbolLookupFailure(new String(sourceName.toCharArray()));
            }
            return Status.OK_STATUS;
        }
        IASTNode node = nodeSelector.findEnclosingNode(selectionStart, selectionLength);
        if (node instanceof IASTPreprocessorIncludeStatement) {
            this.openInclude((IASTPreprocessorIncludeStatement)node);
            return Status.OK_STATUS;
        }
        if (node instanceof IASTPreprocessorFunctionStyleMacroDefinition) {
            IASTPreprocessorFunctionStyleMacroDefinition mdef = (IASTPreprocessorFunctionStyleMacroDefinition)node;
            IASTFunctionStyleMacroParameter[] iASTFunctionStyleMacroParameterArray = mdef.getParameters();
            int n = iASTFunctionStyleMacroParameterArray.length;
            int n5 = 0;
            while (n5 < n) {
                IASTFunctionStyleMacroParameter par = iASTFunctionStyleMacroParameterArray[n5];
                String parName = par.getParameter();
                if (parName.equals(this.fSelectedText) && this.navigateToLocation(par.getFileLocation())) {
                    return Status.OK_STATUS;
                }
                ++n5;
            }
        }
        if (!this.navigationFallBack(ast, null, NameKind.REFERENCE)) {
            this.fAction.reportSelectionMatchFailure();
        }
        return Status.OK_STATUS;
    }

    private IName[] findDeclNames(IASTTranslationUnit ast, NameKind kind, IBinding binding) throws CoreException {
        ICPPClassType clsBinding;
        ICPPMethod method;
        IName[] declNames = this.findNames(this.fIndex, ast, kind, binding);
        while (declNames.length == 0 && binding instanceof ICPPSpecialization) {
            if ((binding = ((ICPPSpecialization)binding).getSpecializedBinding()) == null || binding instanceof IProblemBinding) continue;
            declNames = this.findNames(this.fIndex, ast, NameKind.DEFINITION, binding);
        }
        if (declNames.length == 0 && binding instanceof ICPPMethod && (method = (ICPPMethod)binding).isImplicit() && (clsBinding = method.getClassOwner()) != null && !(clsBinding instanceof IProblemBinding)) {
            declNames = this.findNames(this.fIndex, ast, NameKind.REFERENCE, (IBinding)clsBinding);
        }
        return declNames;
    }

    private IName[] findNames(IIndex index, IASTTranslationUnit ast, NameKind kind, IBinding binding) throws CoreException {
        IName[] declNames = kind == NameKind.DEFINITION ? this.findDeclarations(index, ast, binding) : this.findDefinitions(index, ast, kind, binding);
        if (declNames.length == 0) {
            declNames = kind == NameKind.DEFINITION ? this.findDefinitions(index, ast, kind, binding) : this.findDeclarations(index, ast, binding);
        }
        return declNames;
    }

    private IName[] findDefinitions(IIndex index, IASTTranslationUnit ast, NameKind kind, IBinding binding) throws CoreException {
        ArrayList<IASTName> declNames = new ArrayList<IASTName>();
        declNames.addAll(Arrays.asList(ast.getDefinitionsInAST(binding)));
        Iterator i = declNames.iterator();
        while (i.hasNext()) {
            IASTName name = (IASTName)i.next();
            IBinding b2 = name.resolveBinding();
            if (b2 instanceof ICPPUsingDeclaration) {
                i.remove();
            }
            if (binding == b2 || !(binding instanceof ICPPSpecialization)) continue;
            IBinding spec = binding;
            while (spec instanceof ICPPSpecialization) {
                if ((spec = ((ICPPSpecialization)spec).getSpecializedBinding()) == b2) break;
            }
            if (spec instanceof ICPPSpecialization) continue;
            i.remove();
        }
        if (!declNames.isEmpty()) {
            return (IName[])declNames.toArray(new IASTName[declNames.size()]);
        }
        return index.findNames(binding, 10);
    }

    private IName[] findDeclarations(IIndex index, IASTTranslationUnit ast, IBinding binding) throws CoreException {
        Object[] declNames = ast.getDeclarationsInAST(binding);
        int i = 0;
        while (i < declNames.length) {
            Object name = declNames[i];
            if (name.isDefinition()) {
                declNames[i] = null;
            }
            ++i;
        }
        if ((declNames = (IName[])ArrayUtil.removeNulls(IName.class, (Object[])declNames)).length == 0) {
            declNames = index.findNames(binding, 9);
        }
        return declNames;
    }

    private IName[] findImplicitTargets(IASTTranslationUnit ast, IASTNodeSelector nodeSelector, int offset, int length) throws CoreException {
        Object[] definitions = IName.EMPTY_ARRAY;
        IASTImplicitName firstName = nodeSelector.findEnclosingImplicitName(offset, length);
        if (firstName != null) {
            IASTImplicitNameOwner owner = (IASTImplicitNameOwner)firstName.getParent();
            IASTImplicitName[] iASTImplicitNameArray = owner.getImplicitNames();
            int n = iASTImplicitNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTImplicitName name = iASTImplicitNameArray[n2];
                if (((ASTNode)name).getOffset() == ((ASTNode)firstName).getOffset()) {
                    IBinding binding = name.resolveBinding();
                    Object[] declNames = this.findDeclNames(ast, NameKind.REFERENCE, binding);
                    definitions = (IName[])ArrayUtil.addAll((Object[])definitions, (Object[])declNames);
                }
                ++n2;
            }
        }
        return (IName[])ArrayUtil.trim((Object[])definitions);
    }

    private static NameKind getNameKind(IName name) {
        if (name.isDefinition()) {
            if (OpenDeclarationsJob.getBinding(name) instanceof ICPPUsingDeclaration) {
                return NameKind.USING_DECL;
            }
            return NameKind.DEFINITION;
        }
        if (name.isDeclaration()) {
            return NameKind.DECLARATION;
        }
        return NameKind.REFERENCE;
    }

    private static IBinding getBinding(IName name) {
        if (name instanceof IASTName) {
            return ((IASTName)name).resolveBinding();
        }
        if (name instanceof IIndexFragmentName) {
            try {
                return ((IIndexFragmentName)name).getBinding();
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    private boolean areOverlappingNames(IName n1, IName n2) {
        if (n1 == n2) {
            return true;
        }
        IASTFileLocation loc1 = n1.getFileLocation();
        IASTFileLocation loc2 = n2.getFileLocation();
        if (loc1 == null || loc2 == null) {
            return false;
        }
        return loc1.getFileName().equals(loc2.getFileName()) && Math.max(loc1.getNodeOffset(), loc2.getNodeOffset()) < Math.min(loc1.getNodeOffset() + loc1.getNodeLength(), loc2.getNodeOffset() + loc2.getNodeLength());
    }

    private static boolean isInSameFunction(IASTName refName, IName funcDeclName) {
        if (funcDeclName instanceof IASTName) {
            IASTDeclaration fdef = OpenDeclarationsJob.getEnclosingFunctionDefinition((IASTNode)funcDeclName);
            return fdef != null && fdef.contains((IASTNode)refName);
        }
        return false;
    }

    private static IASTDeclaration getEnclosingFunctionDefinition(IASTNode node) {
        while (node != null && !(node instanceof IASTFunctionDefinition)) {
            node = node.getParent();
        }
        return (IASTDeclaration)node;
    }

    private static boolean isInSameTemplate(IASTName refName, IName templateDeclName) {
        if (templateDeclName instanceof IASTName) {
            IASTDeclaration template = OpenDeclarationsJob.getEnclosingTemplateDeclaration((IASTNode)refName);
            return template != null && template.contains((IASTNode)refName);
        }
        return false;
    }

    private static IASTDeclaration getEnclosingTemplateDeclaration(IASTNode node) {
        while (node != null && !(node instanceof ICPPASTTemplateDeclaration)) {
            node = node.getParent();
        }
        return (IASTDeclaration)node;
    }

    private void convertToCElements(ICProject project, IIndex index, IName[] declNames, List<ICElement> elements) {
        IName[] iNameArray = declNames;
        int n = declNames.length;
        int n2 = 0;
        while (n2 < n) {
            IName declName = iNameArray[n2];
            try {
                ICElementHandle elem = this.getCElementForName(project, index, declName);
                if (elem instanceof ISourceReference) {
                    elements.add((ICElement)elem);
                }
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
            }
            ++n2;
        }
    }

    private ICElementHandle getCElementForName(ICProject project, IIndex index, IName declName) throws CoreException {
        if (declName instanceof IIndexName) {
            return IndexUI.getCElementForName(project, index, (IIndexName)declName);
        }
        if (declName instanceof IASTName) {
            ITranslationUnit tu;
            IASTName astName = (IASTName)declName;
            IBinding binding = astName.resolveBinding();
            if (binding != null && (tu = IndexUI.getTranslationUnit(project, astName)) != null) {
                IASTFileLocation loc = astName.getFileLocation();
                Region region = new Region(loc.getNodeOffset(), loc.getNodeLength());
                return CElementHandleFactory.create((ITranslationUnit)tu, (IBinding)binding, (boolean)astName.isDefinition(), (IRegion)region, (long)0L);
            }
            return null;
        }
        return null;
    }

    private boolean navigateViaCElements(ICProject project, IIndex index, IName[] declNames) {
        ArrayList<ICElement> elements = new ArrayList<ICElement>();
        this.convertToCElements(project, index, declNames, elements);
        return this.navigateCElements(elements);
    }

    private boolean navigateCElements(List<ICElement> elements) {
        List<ICElement> uniqueElements;
        if (elements.isEmpty()) {
            return false;
        }
        if (elements.size() < 2) {
            uniqueElements = elements;
        } else {
            HashSet<String> sigs = new HashSet<String>();
            sigs.add(null);
            uniqueElements = new ArrayList<ICElement>();
            for (ICElement elem : elements) {
                if (!sigs.add(this.getLocationSignature((ISourceReference)elem))) continue;
                uniqueElements.add(elem);
            }
        }
        this.runInUIThread(new Runnable(){

            public void run() {
                ISourceReference target = null;
                if (uniqueElements.size() == 1) {
                    target = (ISourceReference)uniqueElements.get(0);
                } else {
                    if (OpenDeclarationsAction.sIsJUnitTest) {
                        throw new RuntimeException("ambiguous input: " + uniqueElements.size());
                    }
                    ICElement[] elemArray = uniqueElements.toArray(new ICElement[uniqueElements.size()]);
                    target = (ISourceReference)OpenActionUtil.selectCElement(elemArray, OpenDeclarationsJob.this.fAction.getSite().getShell(), CEditorMessages.OpenDeclarationsAction_dialog_title, CEditorMessages.OpenDeclarationsAction_selectMessage, 2182096929L, 0);
                }
                if (target != null) {
                    ITranslationUnit tu = target.getTranslationUnit();
                    try {
                        ISourceRange sourceRange = target.getSourceRange();
                        if (tu != null && sourceRange != null) {
                            OpenDeclarationsJob.this.fAction.open(tu, sourceRange.getIdStartPos(), sourceRange.getIdLength());
                        }
                    }
                    catch (CoreException e) {
                        CUIPlugin.log(e);
                    }
                }
            }
        });
        return true;
    }

    private String getLocationSignature(ISourceReference elem) {
        ITranslationUnit tu = elem.getTranslationUnit();
        try {
            ISourceRange sourceRange = elem.getSourceRange();
            if (tu != null && sourceRange != null) {
                return String.valueOf(tu.getPath().toString()) + '/' + sourceRange.getIdStartPos() + '/' + sourceRange.getIdLength();
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        return null;
    }

    private boolean navigateOneLocation(IName[] names) {
        IName[] iNameArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            IName name = iNameArray[n2];
            if (this.navigateToName(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean navigateToName(IName name) {
        return this.navigateToLocation(name.getFileLocation());
    }

    private boolean navigateToLocation(IASTFileLocation fileloc) {
        if (fileloc == null) {
            return false;
        }
        Path path = new Path(fileloc.getFileName());
        int offset = fileloc.getNodeOffset();
        int length = fileloc.getNodeLength();
        this.runInUIThread(new Runnable((IPath)path, offset, length){
            private final /* synthetic */ IPath val$path;
            private final /* synthetic */ int val$offset;
            private final /* synthetic */ int val$length;
            {
                this.val$path = iPath;
                this.val$offset = n;
                this.val$length = n2;
            }

            public void run() {
                try {
                    OpenDeclarationsJob.this.fAction.open(this.val$path, this.val$offset, this.val$length);
                }
                catch (CoreException e) {
                    CUIPlugin.log(e);
                }
            }
        });
        return true;
    }

    private void runInUIThread(Runnable runnable) {
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }

    private void openInclude(IASTPreprocessorIncludeStatement incStmt) {
        String name = null;
        if (incStmt.isResolved()) {
            name = incStmt.getPath();
        }
        if (name != null) {
            Path path = new Path(name);
            this.runInUIThread(new Runnable((IPath)path){
                private final /* synthetic */ IPath val$path;
                {
                    this.val$path = iPath;
                }

                public void run() {
                    try {
                        OpenDeclarationsJob.this.fAction.open(this.val$path, 0, 0);
                    }
                    catch (CoreException e) {
                        CUIPlugin.log(e);
                    }
                }
            });
        } else {
            this.fAction.reportIncludeLookupFailure(new String(incStmt.getName().toCharArray()));
        }
    }

    private boolean navigationFallBack(IASTTranslationUnit ast, IASTName sourceName, NameKind kind) {
        if (this.fSelectedText != null && this.fSelectedText.length() > 0) {
            block16: {
                IIndexMacro[] macros;
                IIndexBinding[] idxBindings;
                IASTName[] candidates;
                ICProject project = this.fTranslationUnit.getCProject();
                char[] name = this.fSelectedText.toCharArray();
                ArrayList<ICElement> elems = new ArrayList<ICElement>();
                HashSet<IBinding> primaryBindings = new HashSet<IBinding>();
                ASTNameCollector nc = new ASTNameCollector(this.fSelectedText);
                ast.accept((ASTVisitor)nc);
                IASTName[] iASTNameArray = candidates = nc.getNames();
                int n = candidates.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTName astName = iASTNameArray[n2];
                    try {
                        IBinding b = astName.resolveBinding();
                        if (b != null && !(b instanceof IProblemBinding)) {
                            primaryBindings.add(b);
                        }
                    }
                    catch (RuntimeException e) {
                        CUIPlugin.log(e);
                    }
                    ++n2;
                }
                IndexFilter filter = IndexFilter.getDeclaredBindingFilter((int)ast.getLinkage().getLinkageID(), (boolean)false);
                IIndexBinding[] iIndexBindingArray = idxBindings = this.fIndex.findBindings(name, false, filter, this.fMonitor);
                int e = idxBindings.length;
                int n3 = 0;
                while (n3 < e) {
                    IIndexBinding idxBinding = iIndexBindingArray[n3];
                    primaryBindings.add((IBinding)idxBinding);
                    ++n3;
                }
                IIndexMacro[] iIndexMacroArray = macros = this.fIndex.findMacros(name, filter, this.fMonitor);
                int n4 = macros.length;
                e = 0;
                while (e < n4) {
                    IIndexMacro macro = iIndexMacroArray[e];
                    ICElementHandle elem = IndexUI.getCElementForMacro(project, this.fIndex, macro);
                    if (elem != null) {
                        elems.add((ICElement)elem);
                    }
                    ++e;
                }
                Collection<IBinding> secondaryBindings = ast instanceof ICPPASTTranslationUnit ? this.cppRemoveSecondaryBindings(primaryBindings, sourceName) : this.defaultRemoveSecondaryBindings(primaryBindings, sourceName);
                Collection<IBinding> bs = primaryBindings;
                int k = 0;
                while (k < 2) {
                    for (IBinding binding : bs) {
                        Object[] names = this.findNames(this.fIndex, ast, kind, binding);
                        int i = 0;
                        while (i < names.length) {
                            if (OpenDeclarationsJob.getNameKind((IName)names[i]) == kind) {
                                names[i] = null;
                            }
                            ++i;
                        }
                        names = (IName[])ArrayUtil.removeNulls(IName.class, (Object[])names);
                        this.convertToCElements(project, this.fIndex, (IName[])names, elems);
                    }
                    if (!elems.isEmpty()) break;
                    bs = secondaryBindings;
                    ++k;
                }
                if (!this.navigateCElements(elems)) break block16;
                return true;
            }
            try {
                if (sourceName != null && sourceName.isDeclaration()) {
                    return this.navigateToName((IName)sourceName);
                }
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
            }
        }
        return false;
    }

    private Collection<IBinding> defaultRemoveSecondaryBindings(Set<IBinding> primaryBindings, IASTName sourceName) {
        IBinding b;
        if (sourceName != null && (b = sourceName.resolveBinding()) != null && !(b instanceof IProblemBinding)) {
            try {
                Iterator<IBinding> iterator = primaryBindings.iterator();
                while (iterator.hasNext()) {
                    if (this.checkOwnerNames(b, iterator.next())) continue;
                    iterator.remove();
                }
            }
            catch (DOMException dOMException) {}
        }
        return Collections.emptyList();
    }

    private boolean checkOwnerNames(IBinding b1, IBinding b2) throws DOMException {
        IBinding o2;
        IBinding o1 = b1.getOwner();
        if (o1 == (o2 = b2.getOwner())) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (!CharArrayUtils.equals((char[])o1.getNameCharArray(), (char[])o2.getNameCharArray())) {
            return false;
        }
        return this.checkOwnerNames(o1, o2);
    }

    private Collection<IBinding> cppRemoveSecondaryBindings(Set<IBinding> primaryBindings, IASTName sourceName) {
        IBinding binding;
        ArrayList<IBinding> result = new ArrayList<IBinding>();
        Object[] sourceQualifiedName = null;
        int funcArgCount = -1;
        if (sourceName != null && (binding = sourceName.resolveBinding()) != null) {
            LookupData data;
            sourceQualifiedName = CPPVisitor.getQualifiedName((IBinding)binding);
            if (binding instanceof ICPPUnknownBinding && (data = CPPSemantics.createLookupData((IASTName)sourceName)).isFunctionCall()) {
                funcArgCount = data.getFunctionArgumentCount();
            }
        }
        Iterator<IBinding> iterator = primaryBindings.iterator();
        while (iterator.hasNext()) {
            Object[] qualifiedName;
            IBinding binding2 = iterator.next();
            if (sourceQualifiedName != null && !Arrays.equals(qualifiedName = CPPVisitor.getQualifiedName((IBinding)binding2), sourceQualifiedName)) {
                iterator.remove();
                continue;
            }
            if (funcArgCount == -1 || !(binding2 instanceof ICPPFunction)) continue;
            ICPPFunction f = (ICPPFunction)binding2;
            if (f.getRequiredArgumentCount() > funcArgCount) {
                iterator.remove();
                result.add(binding2);
                continue;
            }
            if (f.takesVarArgs() || f.hasParameterPack()) continue;
            IType[] parameterTypes = f.getType().getParameterTypes();
            int maxArgs = parameterTypes.length;
            if (maxArgs == 1 && SemanticUtil.isVoidType((IType)parameterTypes[0])) {
                maxArgs = 0;
            }
            if (maxArgs >= funcArgCount) continue;
            iterator.remove();
            result.add(binding2);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NameKind {
        REFERENCE,
        DECLARATION,
        USING_DECL,
        DEFINITION;

    }
}

