/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.cdt.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.tm.internal.tcf.cdt.launch.ContextSelection;
import org.eclipse.tm.internal.tcf.debug.launch.TCFLaunchDelegate;
import org.eclipse.tm.internal.tcf.debug.model.TCFLaunch;
import org.eclipse.tm.tcf.protocol.Protocol;

public class TCFCDTLaunchDelegate
extends TCFLaunchDelegate {
    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        ILaunchConfiguration tcfLaunchConfig = this.convertToTcfConfig(configuration);
        return super.getLaunch(tcfLaunchConfig, mode);
    }

    public void launch(ILaunchConfiguration configuration, final String mode, final ILaunch launch, final IProgressMonitor monitor) throws CoreException {
        String peerId;
        ILaunchConfiguration tcfLaunchConfig = this.convertToTcfConfig(configuration);
        if (this.isAttachLaunch(tcfLaunchConfig)) {
            ContextSelection selection = this.promptForContext(tcfLaunchConfig);
            if (selection == null) {
                throw new CoreException(Status.OK_STATUS);
            }
            launch.setAttribute("attach_to_context", selection.fContextId);
            if (!selection.fIsAttached) {
                launch.setAttribute("attach_to_process", selection.fContextId);
            }
            peerId = selection.fPeerId;
        } else {
            peerId = this.isRemoteLaunch(tcfLaunchConfig) ? tcfLaunchConfig.getAttribute("org.eclipse.tm.tcf.debug.PeerID", null) : null;
        }
        if (peerId == null) {
            super.launch(tcfLaunchConfig, mode, launch, monitor);
        } else {
            if (monitor != null) {
                monitor.beginTask("Launching TCF debugger session", 1);
            }
            Protocol.invokeLater((Runnable)new Runnable(){

                public void run() {
                    ((TCFLaunch)launch).launchTCF(mode, peerId);
                    if (monitor != null) {
                        monitor.done();
                    }
                }
            });
        }
    }

    private boolean isAttachLaunch(ILaunchConfiguration config) throws CoreException {
        String configTypeName = config.getType().getIdentifier();
        return "org.eclipse.cdt.launch.attachLaunchType".equals(configTypeName);
    }

    private boolean isRemoteLaunch(ILaunchConfiguration config) throws CoreException {
        String configTypeName = config.getType().getIdentifier();
        return "org.eclipse.tcf.cdt.launch.remoteApplicationLaunchType".equals(configTypeName);
    }

    private ContextSelection promptForContext(ILaunchConfiguration config) throws CoreException {
        Object result;
        Status promptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
        Status contextPrompt = new Status(1, "org.eclipse.tm.tcf.cdt.core", 100, "", null);
        IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler((IStatus)promptStatus);
        if (prompter != null && (result = prompter.handleStatus((IStatus)contextPrompt, (Object)config)) instanceof ContextSelection) {
            return (ContextSelection)result;
        }
        return null;
    }

    protected ILaunchConfiguration convertToTcfConfig(ILaunchConfiguration orig) throws CoreException {
        ILaunchConfigurationWorkingCopy copy = orig.copy(orig.getName());
        boolean changed = this.copyStringAttribute(orig, copy, "org.eclipse.cdt.launch.PROJECT_ATTR", "org.eclipse.tm.tcf.debug.ProjectName");
        if (this.isAttachLaunch(orig)) {
            changed = this.setStringAttribute(copy, "org.eclipse.tm.tcf.debug.LocalProgramFile", null) || changed;
            changed = this.setStringAttribute(copy, "org.eclipse.tm.tcf.debug.ProgramFile", null) || changed;
        } else {
            changed = this.copyStringAttribute(orig, copy, "org.eclipse.cdt.launch.PROGRAM_NAME", "org.eclipse.tm.tcf.debug.LocalProgramFile") || changed;
            changed = this.copyStringAttribute(orig, copy, "org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", "org.eclipse.tm.tcf.debug.ProgramArguments") || changed;
            changed = this.copyStringAttribute(orig, copy, "org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", "org.eclipse.tm.tcf.debug.WorkingDirectory") || changed;
            changed = this.copyBooleanAttribute(orig, copy, "org.eclipse.cdt.launch.use_terminal", "org.eclipse.tm.tcf.debug.UseTerminal") || changed;
        }
        return changed ? copy.doSave() : orig;
    }

    private boolean copyStringAttribute(ILaunchConfiguration orig, ILaunchConfigurationWorkingCopy copy, String origAttr, String newAttr) throws CoreException {
        String newValue = orig.getAttribute(newAttr, null);
        return this.setStringAttribute(copy, newAttr, newValue);
    }

    private boolean setStringAttribute(ILaunchConfigurationWorkingCopy copy, String attr, String newValue) throws CoreException {
        String origValue = copy.getAttribute(attr, null);
        if (origValue == newValue || origValue != null && origValue.equals(newValue)) {
            return false;
        }
        copy.setAttribute(attr, newValue);
        return true;
    }

    private boolean copyBooleanAttribute(ILaunchConfiguration orig, ILaunchConfigurationWorkingCopy copy, String origAttr, String newAttr) throws CoreException {
        boolean newValue;
        boolean origValue = orig.getAttribute(origAttr, false);
        if (origValue == (newValue = orig.getAttribute(newAttr, false))) {
            return false;
        }
        copy.setAttribute(newAttr, origValue);
        return true;
    }
}

