/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.cdt.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.internal.tcf.cdt.ui.EvaluationContextManager;
import org.eclipse.tm.internal.tcf.cdt.ui.TCFBreakpointStatusListener;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.tm.tcf.cdt.ui";
    private static Activator plugin;
    private static TCFBreakpointStatusListener bp_status_listener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        EvaluationContextManager.startup();
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                if (bp_status_listener == null) {
                    bp_status_listener = new TCFBreakpointStatusListener();
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                if (bp_status_listener != null) {
                    bp_status_listener.dispose();
                    bp_status_listener = null;
                }
            }
        });
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        Activator.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        Activator.log((IStatus)new Status(4, PLUGIN_ID, 4, e.getMessage(), e));
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = Activator.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = Activator.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static void errorDialog(String message, IStatus status) {
        Activator.log(status);
        Shell shell = Activator.getActiveWorkbenchShell();
        if (shell == null) {
            return;
        }
        ErrorDialog.openError((Shell)shell, (String)"Error", (String)message, (IStatus)status);
    }

    public static void errorDialog(String message, Throwable t) {
        Activator.log(t);
        Shell shell = Activator.getActiveWorkbenchShell();
        if (shell == null) {
            return;
        }
        Status status = new Status(4, PLUGIN_ID, 1, t.getMessage(), null);
        ErrorDialog.openError((Shell)shell, (String)"Error", (String)message, (IStatus)status);
    }
}

