/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.cdt.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CAddressBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CFunctionBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CLineBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CWatchpoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.tm.internal.tcf.debug.model.ITCFBreakpointListener;
import org.eclipse.tm.internal.tcf.debug.model.TCFBreakpointsModel;
import org.eclipse.tm.internal.tcf.debug.model.TCFBreakpointsStatus;
import org.eclipse.tm.internal.tcf.debug.model.TCFLaunch;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModelManager;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IBreakpoints;

class TCFBreakpointStatusListener {
    private static final String ATTR_REFCOUNT = "org.eclipse.tm.tcf.cdt.refcount";
    private static final String ATTR_TCF_ID = "org.eclipse.tm.tcf.debug.ID";
    private final TCFModelManager.ModelManagerListener launch_listener = new TCFModelManager.ModelManagerListener(){

        public void onConnected(TCFLaunch launch, TCFModel model) {
            if (!$assertionsDisabled && TCFBreakpointStatusListener.this.bp_listeners.get(launch) != null) {
                throw new AssertionError();
            }
            if (launch.getBreakpointsStatus() != null) {
                new BreakpointListener(launch);
            }
        }

        public void onDisconnected(TCFLaunch launch, TCFModel model) {
            BreakpointListener l = (BreakpointListener)TCFBreakpointStatusListener.this.bp_listeners.remove(launch);
            if (l != null) {
                l.dispose();
            }
        }
    };
    private final TCFModelManager model_manager;
    private final TCFBreakpointsModel bp_model = TCFBreakpointsModel.getBreakpointsModel();
    private final Map<TCFLaunch, BreakpointListener> bp_listeners;

    TCFBreakpointStatusListener() {
        this.model_manager = TCFModelManager.getModelManager();
        this.model_manager.addListener(this.launch_listener);
        this.bp_listeners = new HashMap<TCFLaunch, BreakpointListener>();
        ILaunch[] iLaunchArray = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            TCFLaunch tcfLaunch;
            ILaunch launch = iLaunchArray[n2];
            if (launch instanceof TCFLaunch && !(tcfLaunch = (TCFLaunch)launch).isDisconnected() && !tcfLaunch.isConnecting() && tcfLaunch.getBreakpointsStatus() != null) {
                this.launch_listener.onConnected(tcfLaunch, this.model_manager.getModel(tcfLaunch));
            }
            ++n2;
        }
    }

    void dispose() {
        this.model_manager.removeListener(this.launch_listener);
        for (BreakpointListener l : this.bp_listeners.values()) {
            l.dispose();
        }
        this.bp_listeners.clear();
    }

    private class BreakpointListener
    implements ITCFBreakpointListener {
        private final TCFLaunch launch;
        private final TCFBreakpointsStatus status;
        private final Map<String, ICBreakpoint> installed = new HashMap<String, ICBreakpoint>();
        private final Set<String> foreign = new HashSet<String>();
        private final Set<String> deleted = new HashSet<String>();

        BreakpointListener(TCFLaunch launch) {
            this.launch = launch;
            this.status = launch.getBreakpointsStatus();
            this.status.addListener((ITCFBreakpointListener)this);
            TCFBreakpointStatusListener.this.bp_listeners.put(launch, this);
            for (String id : this.status.getStatusIDs()) {
                this.breakpointStatusChanged(id);
            }
        }

        public void breakpointStatusChanged(String id) {
            IBreakpoint bp = TCFBreakpointStatusListener.this.bp_model.getBreakpoint(id);
            if (bp instanceof ICBreakpoint) {
                Collection list;
                boolean ok = false;
                ICBreakpoint cbp = (ICBreakpoint)bp;
                Map map = this.status.getStatus(id);
                if (map != null && (list = (Collection)map.get("Instances")) != null) {
                    for (Map m : list) {
                        if (m.get("Error") != null) continue;
                        ok = true;
                    }
                }
                if (ok && this.installed.get(id) == null) {
                    this.installed.put(id, cbp);
                    this.incrementInstallCount(cbp);
                }
                if (!ok && this.installed.get(id) == cbp) {
                    this.installed.remove(id);
                    this.decrementInstallCount(cbp);
                }
            } else if (bp == null && this.foreign.add(id)) {
                this.createOrUpdateBreakpoint(id, true);
            }
        }

        public void breakpointRemoved(String id) {
            ICBreakpoint cbp = this.installed.remove(id);
            if (cbp != null) {
                this.decrementInstallCount(cbp);
            }
            if (this.foreign.remove(id)) {
                this.deleteTransientBreakpoint(id);
            }
        }

        public void breakpointChanged(String id) {
            this.createOrUpdateBreakpoint(id, false);
        }

        void dispose() {
            for (ICBreakpoint cbp : this.installed.values()) {
                this.decrementInstallCount(cbp);
            }
            this.installed.clear();
            for (String id : this.foreign) {
                this.deleteTransientBreakpoint(id);
            }
            this.foreign.clear();
        }

        private void incrementInstallCount(final ICBreakpoint cbp) {
            WorkspaceJob job = new WorkspaceJob("Increment Install Count"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        cbp.incrementInstallCount();
                    }
                    catch (CoreException coreException) {}
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)cbp.getMarker().getResource());
            job.setPriority(20);
            job.setSystem(true);
            job.schedule();
        }

        private void decrementInstallCount(final ICBreakpoint cbp) {
            WorkspaceJob job = new WorkspaceJob("Decrement Install Count"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        cbp.decrementInstallCount();
                    }
                    catch (CoreException coreException) {}
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)cbp.getMarker().getResource());
            job.setPriority(20);
            job.setSystem(true);
            job.schedule();
        }

        private void createOrUpdateBreakpoint(final String id, final boolean create) {
            IBreakpoints bkpts = (IBreakpoints)this.launch.getService(IBreakpoints.class);
            if (bkpts == null) {
                return;
            }
            bkpts.getProperties(id, new IBreakpoints.DoneGetProperties(){

                public void doneGetProperties(IToken token, Exception error, Map<String, Object> properties) {
                    if (properties == null || error != null) {
                        return;
                    }
                    final Map<String, Object> markerAttrs = this.toMarkerAttributes(properties);
                    WorkspaceJob job = new WorkspaceJob("Create Breakpoint Marker"){

                        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                            IBreakpoint[] bps;
                            if (BreakpointListener.this.deleted.remove(id)) {
                                return Status.OK_STATUS;
                            }
                            IBreakpoint[] iBreakpointArray = bps = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
                            int n = bps.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IBreakpoint bp = iBreakpointArray[n2];
                                IMarker marker = bp.getMarker();
                                if (marker != null && id.equals(TCFBreakpointStatusListener.this.bp_model.getBreakpointID(bp))) {
                                    if (create) {
                                        int cnt = marker.getAttribute(TCFBreakpointStatusListener.ATTR_REFCOUNT, 0) + 1;
                                        markerAttrs.put(TCFBreakpointStatusListener.ATTR_REFCOUNT, cnt);
                                    } else {
                                        markerAttrs.remove("org.eclipse.cdt.debug.core.sourceHandle");
                                        this.updateMarkerAttributes(markerAttrs, marker);
                                    }
                                    return Status.OK_STATUS;
                                }
                                ++n2;
                            }
                            if (!create) {
                                return Status.OK_STATUS;
                            }
                            markerAttrs.put("org.eclipse.debug.core.persisted", Boolean.FALSE);
                            markerAttrs.put("transient", Boolean.TRUE);
                            markerAttrs.put(TCFBreakpointStatusListener.ATTR_REFCOUNT, 1);
                            IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
                            if (markerAttrs.get("org.eclipse.cdt.debug.core.expression") != null) {
                                new CWatchpoint((IResource)resource, markerAttrs, true);
                            } else if (markerAttrs.get("org.eclipse.cdt.debug.core.address") != null) {
                                new CAddressBreakpoint((IResource)resource, markerAttrs, true);
                            } else if (markerAttrs.get("org.eclipse.cdt.debug.core.function") != null) {
                                new CFunctionBreakpoint((IResource)resource, markerAttrs, true);
                            } else if (markerAttrs.get("org.eclipse.cdt.debug.core.sourceHandle") != null && markerAttrs.get("lineNumber") != null) {
                                new CLineBreakpoint((IResource)resource, markerAttrs, true);
                            }
                            return Status.OK_STATUS;
                        }

                        private void updateMarkerAttributes(Map<String, Object> markerAttrs2, IMarker marker) throws CoreException {
                            ArrayList<String> keys = new ArrayList<String>(markerAttrs2.size());
                            ArrayList<Object> values = new ArrayList<Object>(markerAttrs2.size());
                            Map oldAttrs = marker.getAttributes();
                            for (Map.Entry<String, Object> entry : markerAttrs2.entrySet()) {
                                String key = entry.getKey();
                                Object newVal = entry.getValue();
                                Object oldVal = oldAttrs.remove(key);
                                if (oldVal != null && oldVal.equals(newVal)) continue;
                                keys.add(key);
                                values.add(newVal);
                            }
                            if (keys.size() != 0) {
                                String[] keyArr = keys.toArray(new String[keys.size()]);
                                Object[] valueArr = values.toArray(new Object[values.size()]);
                                marker.setAttributes(keyArr, valueArr);
                            }
                        }
                    };
                    job.setRule(BreakpointListener.this.getBreakpointAccessRule());
                    job.setPriority(20);
                    job.setSystem(true);
                    job.schedule();
                }

                private Map<String, Object> toMarkerAttributes(Map<String, Object> properties) {
                    Object enabled;
                    Object line;
                    Object file;
                    HashMap<String, Object> markerAttrs = new HashMap<String, Object>();
                    String location = (String)properties.get("Location");
                    int accessMode = 4;
                    Number accessModeVal = (Number)properties.get("AccessMode");
                    if (accessModeVal != null) {
                        accessMode = accessModeVal.intValue();
                    }
                    if (location != null && location.length() > 0) {
                        if ((accessMode & 4) != 0) {
                            if (Character.isDigit(location.charAt(0))) {
                                markerAttrs.put("org.eclipse.cdt.debug.core.address", location);
                            } else {
                                markerAttrs.put("org.eclipse.cdt.debug.core.function", location);
                            }
                        } else {
                            markerAttrs.put("org.eclipse.cdt.debug.core.expression", location.replaceFirst("^&\\((.+)\\)$", "$1"));
                            markerAttrs.put("org.eclipse.cdt.debug.core.read", (accessMode & 1) != 0);
                            markerAttrs.put("org.eclipse.cdt.debug.core.write", (accessMode & 2) != 0);
                        }
                    }
                    if ((file = properties.get("File")) != null) {
                        markerAttrs.put("org.eclipse.cdt.debug.core.sourceHandle", file);
                    }
                    if ((line = properties.get("Line")) != null) {
                        markerAttrs.put("lineNumber", line);
                    }
                    if ((enabled = properties.get("Enabled")) != null) {
                        markerAttrs.put("org.eclipse.debug.core.enabled", enabled);
                    } else {
                        markerAttrs.put("org.eclipse.debug.core.enabled", Boolean.FALSE);
                    }
                    markerAttrs.put("org.eclipse.debug.core.id", "org.eclipse.tm.tcf.debug");
                    markerAttrs.put("org.eclipse.debug.core.registered", Boolean.TRUE);
                    String id2 = (String)properties.get("ID");
                    markerAttrs.put(TCFBreakpointStatusListener.ATTR_TCF_ID, id2);
                    return markerAttrs;
                }
            });
        }

        private void deleteTransientBreakpoint(final String id) {
            WorkspaceJob job = new WorkspaceJob("Destroy Breakpoint Marker"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    IBreakpoint[] bps;
                    IBreakpoint[] iBreakpointArray = bps = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
                    int n = bps.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker marker;
                        IBreakpoint bp = iBreakpointArray[n2];
                        if (!bp.isPersisted() && (marker = bp.getMarker()) != null && id.equals(marker.getAttribute(TCFBreakpointStatusListener.ATTR_TCF_ID, null))) {
                            int cnt = marker.getAttribute(TCFBreakpointStatusListener.ATTR_REFCOUNT, 0) - 1;
                            if (cnt > 0) {
                                marker.setAttribute(TCFBreakpointStatusListener.ATTR_REFCOUNT, cnt);
                            } else {
                                bp.delete();
                            }
                            return Status.OK_STATUS;
                        }
                        ++n2;
                    }
                    BreakpointListener.this.deleted.add(id);
                    return Status.OK_STATUS;
                }
            };
            job.setRule(this.getBreakpointAccessRule());
            job.setPriority(20);
            job.setSystem(true);
            job.schedule();
        }

        private ISchedulingRule getBreakpointAccessRule() {
            IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
            ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().markerRule((IResource)resource);
            if (rule == null) {
                rule = ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)resource);
            }
            return rule;
        }
    }
}

