/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.cdt.ui.breakpoints;

import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpointExtension;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.tm.internal.tcf.cdt.ui.Activator;

public class TCFBreakpointScopeExtension
implements ICBreakpointExtension {
    static final String ATTR_CONTEXT_IDS = "org.eclipse.tm.tcf.debug.ContextIds";
    private String[] fContextIds;
    private ICBreakpoint fBreakpoint;

    public void initialize(ICBreakpoint breakpoint) throws CoreException {
        String contextIdAttr;
        this.fBreakpoint = breakpoint;
        IMarker m = breakpoint.getMarker();
        if (m != null && m.exists() && (contextIdAttr = m.getAttribute(ATTR_CONTEXT_IDS, null)) != null) {
            this.fContextIds = contextIdAttr.split(",\\s*");
        }
    }

    public void setThreadFilter(String[] threadIds) {
        this.fContextIds = threadIds;
        if (this.fBreakpoint == null) {
            return;
        }
        IMarker m = this.fBreakpoint.getMarker();
        if (m == null || !m.exists()) {
            return;
        }
        String contextIdAttr = null;
        if (threadIds != null) {
            if (threadIds.length == 0) {
                contextIdAttr = " ";
            } else {
                StringBuilder buf = new StringBuilder();
                int i = 0;
                while (i < threadIds.length - 1) {
                    buf.append(threadIds[i]).append(',');
                    ++i;
                }
                buf.append(threadIds[threadIds.length - 1]);
                contextIdAttr = buf.toString();
            }
        }
        try {
            m.setAttribute(ATTR_CONTEXT_IDS, (Object)contextIdAttr);
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    public String[] getThreadFilters() {
        return this.fContextIds;
    }
}

