/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.cdt.ui.launch;

import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tm.internal.tcf.cdt.ui.launch.FileSystemBrowserControl;
import org.eclipse.tm.tcf.protocol.IPeer;

public class RemoteFileSelectionDialog
extends Dialog {
    private String fSelection;
    private FileSystemBrowserControl fFileList;
    private IPeer fPeer;
    private boolean fForSave;
    private Text fFileNameText;

    protected RemoteFileSelectionDialog(IShellProvider parentShell, int style) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fForSave = (style & 0x2000) != 0;
    }

    public void setPeer(IPeer peer) {
        this.fPeer = peer;
        if (this.fFileList != null) {
            this.fFileList.setInput(peer);
        }
    }

    public void setSelection(String fileSelection) {
        this.fSelection = fileSelection;
    }

    public String getSelection() {
        return this.fSelection;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("Select File");
        super.configureShell(newShell);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.updateButtonState();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.fFileList = new FileSystemBrowserControl(composite, false);
        this.fFileList.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSystemBrowserControl.FileInfo contextInfo = RemoteFileSelectionDialog.this.fFileList.findFileInfo((TreeItem)e.item);
                if (contextInfo != null) {
                    RemoteFileSelectionDialog.this.handleFileSelected(contextInfo);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
                if (RemoteFileSelectionDialog.this.getButton(0).isEnabled()) {
                    RemoteFileSelectionDialog.this.buttonPressed(0);
                }
            }
        });
        if (this.fForSave) {
            Composite fileNameComp = new Composite(composite, 0);
            fileNameComp.setLayoutData((Object)new GridData(4, 4, true, false));
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            fileNameComp.setLayout((Layout)layout);
            new Label(fileNameComp, 0).setText("File Name:");
            this.fFileNameText = new Text(fileNameComp, 2048);
            this.fFileNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.fFileNameText.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    RemoteFileSelectionDialog.this.handleFileNameChanged();
                }
            });
        }
        if (this.fSelection != null) {
            String basename;
            this.fFileList.setInitialSelection(this.fSelection);
            if (this.fFileNameText != null && (basename = new Path(this.fSelection).lastSegment()) != null) {
                this.fFileNameText.setText(basename);
            }
        }
        if (this.fPeer != null) {
            this.fFileList.setInput(this.fPeer);
        }
        return composite;
    }

    private void updateButtonState() {
        boolean enabled;
        boolean bl = enabled = this.fSelection != null;
        if (enabled && this.fForSave) {
            enabled = this.fFileNameText.getText().trim().length() > 0;
        }
        this.getButton(0).setEnabled(enabled);
    }

    protected void handleFileNameChanged() {
        if (this.fSelection != null) {
            this.fSelection = new Path(this.fSelection).removeLastSegments(1).append(this.fFileNameText.getText().trim()).toString();
            this.updateButtonState();
        }
    }

    protected void handleFileSelected(FileSystemBrowserControl.FileInfo fileInfo) {
        if (fileInfo.isDir) {
            String basename;
            this.fSelection = this.fForSave ? ((basename = this.fFileNameText.getText().trim()).length() > 0 ? new Path(fileInfo.fullname).append(basename).toString() : fileInfo.fullname) : null;
        } else {
            String basename;
            this.fSelection = fileInfo.fullname;
            if (this.fFileNameText != null && (basename = new Path(this.fSelection).lastSegment()) != null) {
                this.fFileNameText.setText(basename);
            }
        }
        this.updateButtonState();
    }
}

