/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.commands;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.tm.internal.tcf.debug.model.TCFLaunch;
import org.eclipse.tm.internal.tcf.debug.ui.Activator;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.tcf.util.TCFTask;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class AbstractActionDelegate
implements IViewActionDelegate,
IActionDelegate2,
IWorkbenchWindowActionDelegate,
IObjectActionDelegate {
    private IAction action;
    private IViewPart view;
    private IWorkbenchWindow window;
    private ISelection selection;

    public void init(IAction action) {
        this.action = action;
    }

    public void init(IViewPart view) {
        this.view = view;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void dispose() {
        this.action = null;
        this.view = null;
        this.window = null;
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
        this.action = action;
        this.view = null;
        if (part instanceof IViewPart) {
            this.view = (IViewPart)part;
        }
        this.window = part.getSite().getWorkbenchWindow();
    }

    public void run(IAction action) {
        IAction action0 = this.action;
        try {
            this.action = action;
            this.run();
        }
        finally {
            this.action = action0;
        }
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        IAction action0 = this.action;
        try {
            this.action = action;
            this.selectionChanged();
        }
        finally {
            this.action = action0;
        }
    }

    public IAction getAction() {
        return this.action;
    }

    public IViewPart getView() {
        return this.view;
    }

    public IWorkbenchWindow getWindow() {
        if (this.view != null) {
            return this.view.getSite().getWorkbenchWindow();
        }
        if (this.window != null) {
            return this.window;
        }
        return null;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public TCFNode getSelectedNode() {
        if (this.selection instanceof IStructuredSelection) {
            final Object o = ((IStructuredSelection)this.selection).getFirstElement();
            if (o instanceof TCFNode) {
                return (TCFNode)o;
            }
            if (o instanceof TCFLaunch) {
                return (TCFNode)new TCFTask<TCFNode>(){

                    public void run() {
                        TCFLaunch launch = (TCFLaunch)o;
                        TCFModel model = Activator.getModelManager().getModel(launch);
                        if (model != null) {
                            this.done(model.getRootNode());
                        } else {
                            this.done(null);
                        }
                    }
                }.getE();
            }
        }
        return null;
    }

    protected abstract void selectionChanged();

    protected abstract void run();
}

