/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.model;

import java.math.BigInteger;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.tm.internal.tcf.debug.Activator;
import org.eclipse.tm.tcf.protocol.Protocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFBreakpoint
extends Breakpoint {
    public static final String MARKER_TYPE = "org.eclipse.tm.tcf.debug.breakpoint.marker";
    private static long last_id = 0L;
    private String text;

    private static String createNewID() {
        assert (Protocol.isDispatchThread());
        long id = System.currentTimeMillis();
        if (id <= last_id) {
            id = last_id + 1L;
        }
        last_id = id;
        return Long.toHexString(id);
    }

    public TCFBreakpoint() {
    }

    public TCFBreakpoint(final IResource resource, Map<String, Object> props) throws DebugException {
        props.put("ID", TCFBreakpoint.createNewID());
        final Map<String, Object> m = Activator.getBreakpointsModel().toMarkerAttributes(props);
        final IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker(TCFBreakpoint.MARKER_TYPE);
                TCFBreakpoint.this.setMarker(marker);
                marker.setAttributes(m);
                DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)TCFBreakpoint.this);
            }
        };
        ISchedulingRule rule = this.getMarkerRule(resource);
        Job job = new Job("Add Breakpoint"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    TCFBreakpoint.this.run(TCFBreakpoint.this.getMarkerRule(resource), runnable);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(rule);
        job.schedule();
    }

    public String getModelIdentifier() {
        return "org.eclipse.tm.tcf.debug";
    }

    public String getText() {
        if (this.text == null) {
            IMarker marker = this.getMarker();
            if (marker == null) {
                return null;
            }
            StringBuffer bf = new StringBuffer();
            String address = marker.getAttribute("org.eclipse.tm.tcf.debug.Location", null);
            if (address != null && address.length() > 0) {
                bf.append("PC = ");
                BigInteger n = new BigInteger(address, 10);
                String s = n.toString(16);
                int l = Math.min(s.length(), 8);
                bf.append("0x00000000".substring(0, 10 - l));
                bf.append(s);
            } else {
                String id = marker.getAttribute("org.eclipse.tm.tcf.debug.ID", null);
                bf.append("BP");
                bf.append(id);
            }
            this.text = bf.toString();
        }
        return this.text;
    }
}

