/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.codan.internal.ui.CodanUIActivator;
import org.eclipse.cdt.codan.internal.ui.CodanUIMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public abstract class FieldEditorOverlayPage
extends FieldEditorPreferencePage
implements IWorkbenchPropertyPage {
    private List editors = new ArrayList();
    private IAdaptable element;
    private Button useWorkspaceSettingsButton;
    private Button useProjectSettingsButton;
    private Button configureButton;
    private IPreferenceStore overlayStore;
    private ImageDescriptor image;
    private String pageId;

    public FieldEditorOverlayPage(int style) {
        super(style);
    }

    public FieldEditorOverlayPage(String title, int style) {
        super(title, style);
    }

    public FieldEditorOverlayPage(String title, ImageDescriptor image, int style) {
        super(title, image, style);
        this.image = image;
    }

    protected abstract String getPageId();

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    public IAdaptable getElement() {
        if (this.element == null) {
            return this.element;
        }
        if (!(this.element instanceof IProject)) {
            return (IAdaptable)this.element.getAdapter(IProject.class);
        }
        return this.element;
    }

    public boolean isPropertyPage() {
        return this.getElement() != null;
    }

    protected void addField(FieldEditor editor) {
        this.editors.add(editor);
        super.addField(editor);
    }

    public void createControl(Composite parent) {
        if (this.isPropertyPage()) {
            this.pageId = this.getPageId();
            IAdaptable e = this.getElement();
            if (e != null) {
                ProjectScope ps = new ProjectScope((IProject)e);
                ScopedPreferenceStore scoped = new ScopedPreferenceStore((IScopeContext)ps, "org.eclipse.cdt.codan.core");
                scoped.setSearchContexts(new IScopeContext[]{ps, new InstanceScope()});
                this.overlayStore = scoped;
            }
        }
        super.createControl(parent);
        if (this.isPropertyPage()) {
            this.updateFieldEditors();
        }
    }

    protected Control createContents(Composite parent) {
        if (this.isPropertyPage()) {
            this.createSelectionGroup(parent);
        }
        return super.createContents(parent);
    }

    private void createSelectionGroup(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        Composite radioGroup = new Composite(comp, 0);
        radioGroup.setLayout((Layout)new GridLayout());
        radioGroup.setLayoutData((Object)new GridData(768));
        this.useWorkspaceSettingsButton = this.createRadioButton(radioGroup, CodanUIMessages.OverlayPage_Use_Workspace_Settings);
        this.useProjectSettingsButton = this.createRadioButton(radioGroup, CodanUIMessages.OverlayPage_Use_Project_Settings);
        this.configureButton = new Button(comp, 8);
        this.configureButton.setText(CodanUIMessages.OverlayPage_Configure_Workspace_Settings);
        this.configureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FieldEditorOverlayPage.this.configureWorkspaceSettings();
            }
        });
        try {
            IPreferenceStore preferences = this.getPreferenceStore();
            if (!preferences.contains("useParentScope") || preferences.getBoolean("useParentScope")) {
                this.useWorkspaceSettingsButton.setSelection(true);
            } else {
                this.useProjectSettingsButton.setSelection(true);
                this.configureButton.setEnabled(false);
            }
        }
        catch (Exception exception) {
            this.useWorkspaceSettingsButton.setSelection(true);
        }
    }

    private Button createRadioButton(Composite parent, String label) {
        final Button button = new Button(parent, 16);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FieldEditorOverlayPage.this.configureButton.setEnabled(button == FieldEditorOverlayPage.this.useWorkspaceSettingsButton);
                FieldEditorOverlayPage.this.updateFieldEditors();
            }
        });
        return button;
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.isPropertyPage()) {
            return this.overlayStore;
        }
        return super.getPreferenceStore();
    }

    private void updateFieldEditors() {
        boolean enabled = this.useProjectSettingsButton.getSelection();
        this.updateFieldEditors(enabled);
    }

    protected void updateFieldEditors(boolean enabled) {
        Composite parent = this.getFieldEditorParent();
        for (FieldEditor editor : this.editors) {
            editor.setEnabled(enabled, parent);
        }
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (result && this.isPropertyPage()) {
            this.getPreferenceStore().setValue("useParentScope", this.useWorkspaceSettingsButton.getSelection());
        }
        return result;
    }

    protected void performDefaults() {
        if (this.isPropertyPage()) {
            this.useWorkspaceSettingsButton.setSelection(true);
            this.useProjectSettingsButton.setSelection(false);
            this.configureButton.setEnabled(true);
            this.updateFieldEditors();
        }
        super.performDefaults();
    }

    protected void configureWorkspaceSettings() {
        try {
            IPreferencePage page = (IPreferencePage)((Object)((Object)this)).getClass().newInstance();
            page.setTitle(this.getTitle());
            page.setImageDescriptor(this.image);
            this.showPreferencePage(this.pageId, page);
        }
        catch (InstantiationException e) {
            CodanUIActivator.log(e);
        }
        catch (IllegalAccessException e) {
            CodanUIActivator.log(e);
        }
    }

    protected void showPreferencePage(String id, IPreferencePage page) {
        PreferenceNode targetNode = new PreferenceNode(id, page);
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot((IPreferenceNode)targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(this.getControl().getShell(), manager);
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable((IPreferenceNode)targetNode){
            private final /* synthetic */ IPreferenceNode val$targetNode;
            {
                this.val$targetNode = iPreferenceNode;
            }

            public void run() {
                dialog.create();
                dialog.setMessage(this.val$targetNode.getLabelText());
                dialog.open();
            }
        });
    }
}

