/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.tcf.extension.agent;

import java.util.Map;
import org.eclipse.cdt.debug.edc.tcf.extension.agent.ContextInAgent;
import org.eclipse.cdt.debug.edc.tcf.extension.agent.ContextManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadInAgent
extends ContextInAgent
implements ContextInAgent.IRegisterOwnerContext,
ContextInAgent.IRunControlContext {
    private final long osID;

    public ThreadInAgent(long osID, String parentID, Map<String, Object> props, boolean cacheAsDebugged) {
        super(props);
        ContextInAgent parent;
        this.osID = osID;
        Map<String, Object> internalProps = this.getProperties();
        internalProps.put("ID", ThreadInAgent.createInternalID(osID, parentID));
        internalProps.put("ParentID", parentID);
        internalProps.put("OSID", Long.toString(osID));
        internalProps.put("IsContainer", Boolean.FALSE);
        internalProps.put("HasState", Boolean.TRUE);
        internalProps.put("CanSuspend", Boolean.TRUE);
        internalProps.put("CanResume", 4);
        internalProps.put("CanTerminate", Boolean.TRUE);
        if (cacheAsDebugged) {
            ContextManager.addDebuggedContext(this);
            parent = ContextManager.findDebuggedContext(parentID);
        } else {
            ContextManager.addRunningContext(this);
            parent = ContextManager.findRunningContext(parentID);
        }
        if (parent != null) {
            parent.addChild(this);
        } else assert (false);
    }

    public static String createInternalID(long osID, String processID) {
        return String.valueOf(processID) + ".t" + osID;
    }

    public long getThreadID() {
        return this.osID;
    }

    public static String contextID2ThreadID(String contextID) {
        String[] contextPieces;
        String threadID = null;
        if (contextID.contains("t") && (contextPieces = contextID.split("[.]")).length > 1) {
            threadID = contextPieces[1];
            threadID = threadID.substring(1, threadID.length());
        }
        return threadID;
    }
}

