/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.services.dsf;

import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.services.dsf.RunControl;
import org.eclipse.cdt.debug.edc.services.AbstractEDCService;
import org.eclipse.cdt.debug.edc.services.IDSFServiceUsingTCF;
import org.eclipse.cdt.debug.edc.services.IEDCExecutionDMC;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.BreakpointsMediator2;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IModules;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.IEventListener;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IProcesses;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Processes
extends AbstractEDCService
implements IProcesses,
IEventListener,
IDSFServiceUsingTCF {
    private org.eclipse.tm.tcf.services.IProcesses tcfProcessesService;

    public Processes(DsfSession session) {
        super(session, new String[]{IProcesses.class.getName(), Processes.class.getName()});
    }

    @Override
    protected void doInitialize(RequestMonitor requestMonitor) {
        super.doInitialize(requestMonitor);
        this.getSession().addServiceEventListener((Object)this, null);
    }

    public void attachDebuggerToProcess(IProcesses.IProcessDMContext procCtx, DataRequestMonitor<IDMContext> rm) {
        rm.done();
    }

    public void canDetachDebuggerFromProcess(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        RunControl.ExecutionDMC edcDMC = (RunControl.ExecutionDMC)dmc;
        rm.setData((Object)edcDMC.canDetach());
        rm.done();
    }

    public void canTerminate(IProcesses.IThreadDMContext thread, DataRequestMonitor<Boolean> rm) {
        RunControl.ExecutionDMC executionDmc = (RunControl.ExecutionDMC)thread;
        rm.setData((Object)executionDmc.canTerminate());
        rm.done();
    }

    public void debugNewProcess(IDMContext dmc, String file, Map<String, Object> attributes, DataRequestMonitor<IDMContext> rm) {
        rm.done();
    }

    public void detachDebuggerFromSession(RequestMonitor rm) {
        RunControl rcService = (RunControl)this.getServicesTracker().getService(RunControl.class);
        RunControl.ExecutionDMC[] processes = rcService.getRootDMC().getChildren();
        CountingRequestMonitor crm = new CountingRequestMonitor((Executor)this.getExecutor(), rm);
        crm.setDoneCount(processes.length);
        RunControl.ExecutionDMC[] executionDMCArray = processes;
        int n = processes.length;
        int n2 = 0;
        while (n2 < n) {
            RunControl.ExecutionDMC p = executionDMCArray[n2];
            this.detachDebuggerFromProcess((IDMContext)p, (RequestMonitor)crm);
            ++n2;
        }
    }

    public void detachDebuggerFromProcess(IDMContext exeDmc, final RequestMonitor rm) {
        final IProcesses.IProcessDMContext dmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)exeDmc, IProcesses.IProcessDMContext.class);
        final BreakpointsMediator2 bmService = (BreakpointsMediator2)this.getServicesTracker().getService(BreakpointsMediator2.class);
        if (bmService == null) {
            rm.setStatus((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), "Failed to get BreakpointsMediator2 service."));
            rm.done();
            return;
        }
        IModules modulesService = (IModules)this.getServicesTracker().getService(IModules.class);
        if (modulesService == null) {
            rm.setStatus((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), "Failed to get Modules service."));
            rm.done();
            return;
        }
        IModules.ISymbolDMContext symCtx = (IModules.ISymbolDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IModules.ISymbolDMContext.class);
        modulesService.getModules(symCtx, (DataRequestMonitor)new DataRequestMonitor<IModules.IModuleDMContext[]>((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                if (!this.isSuccess()) {
                    super.handleCompleted();
                } else {
                    IModules.IModuleDMContext[] processModules = (IModules.IModuleDMContext[])this.getData();
                    CountingRequestMonitor bpRemovedCRM = new CountingRequestMonitor((Executor)Processes.this.getExecutor(), rm){

                        protected void handleCompleted() {
                            if (!this.isSuccess()) {
                                super.handleCompleted();
                                return;
                            }
                            ((RunControl.ExecutionDMC)dmc).resume(new RequestMonitor((Executor)Processes.this.getExecutor(), rm){

                                protected void handleCompleted() {
                                    if (!this.isSuccess()) {
                                        super.handleCompleted();
                                    } else {
                                        Processes.this.doDetachDebugger((RunControl.ExecutionDMC)dmc, rm);
                                    }
                                }
                            });
                        }
                    };
                    int bpTargetsDMCCnt = 0;
                    IModules.IModuleDMContext[] iModuleDMContextArray = processModules;
                    int n = processModules.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModules.IModuleDMContext m = iModuleDMContextArray[n2];
                        if (m instanceof IBreakpoints.IBreakpointsTargetDMContext) {
                            ++bpTargetsDMCCnt;
                            bmService.stopTrackingBreakpoints((IBreakpoints.IBreakpointsTargetDMContext)m, (RequestMonitor)bpRemovedCRM);
                        }
                        ++n2;
                    }
                    if (!$assertionsDisabled && bpTargetsDMCCnt <= 0) {
                        throw new AssertionError();
                    }
                    bpRemovedCRM.setDoneCount(bpTargetsDMCCnt);
                }
            }
        });
    }

    protected void doDetachDebugger(final RunControl.ExecutionDMC dmc, final RequestMonitor rm) {
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                Processes.this.tcfProcessesService.getContext(dmc.getID(), new IProcesses.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IProcesses.ProcessContext context) {
                        if (error != null) {
                            rm.setStatus((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), "Fail to get TCF context for process: " + dmc.getID(), (Throwable)error));
                            rm.done();
                        } else {
                            context.detach(new IProcesses.DoneCommand(){

                                public void doneCommand(IToken token, Exception error) {
                                    if (error != null) {
                                        rm.setStatus((IStatus)new Status(4, EDCDebugger.getUniqueIdentifier(), "Fail to detach process \"" + dmc.getID() + "\" from TCF agent.", (Throwable)error));
                                    } else {
                                        dmc.detach();
                                    }
                                    rm.done();
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    public void getDebuggingContext(IProcesses.IThreadDMContext dmc, DataRequestMonitor<IDMContext> rm) {
        rm.done();
    }

    public void getExecutionData(IProcesses.IThreadDMContext dmc, DataRequestMonitor<IProcesses.IThreadDMData> rm) {
        if (dmc instanceof IEDCExecutionDMC) {
            rm.setData((Object)new ExecutionDMData((RunControl.ExecutionDMC)dmc));
        }
        rm.done();
    }

    public void getProcessesBeingDebugged(IDMContext dmc, DataRequestMonitor<IDMContext[]> rm) {
        RunControl runcontrol;
        rm.setData((Object)new IDMContext[0]);
        DsfServicesTracker tracker = this.getServicesTracker();
        if (tracker != null && (runcontrol = (RunControl)tracker.getService(RunControl.class)) != null) {
            RunControl.ExecutionDMC[] processes = runcontrol.getRootDMC().getChildren();
            rm.setData((Object)processes);
        }
        rm.done();
    }

    public void getRunningProcesses(IDMContext dmc, DataRequestMonitor<IProcesses.IProcessDMContext[]> rm) {
        rm.done();
    }

    public void isDebugNewProcessSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.done();
    }

    public void isDebuggerAttachSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.done();
    }

    public void isRunNewProcessSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.done();
    }

    public void runNewProcess(IDMContext dmc, String file, Map<String, Object> attributes, DataRequestMonitor<IProcesses.IProcessDMContext> rm) {
        rm.done();
    }

    public void terminate(IProcesses.IThreadDMContext thread, RequestMonitor requestMonitor) {
        RunControl.ExecutionDMC executionDmc = (RunControl.ExecutionDMC)thread;
        executionDmc.terminate(requestMonitor);
    }

    public void getModelData(IDMContext dmc, DataRequestMonitor<?> rm) {
        rm.done();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
    }

    public void eventReceived(Object output) {
    }

    @Override
    public void tcfServiceReady(IService service) {
        assert (service instanceof org.eclipse.tm.tcf.services.IProcesses);
        this.tcfProcessesService = (org.eclipse.tm.tcf.services.IProcesses)service;
    }

    @Immutable
    protected static class ExecutionDMData
    implements IProcesses.IThreadDMData {
        String name = "unknown";
        String id = "unknown";

        public ExecutionDMData(RunControl.ExecutionDMC dmc) {
            this.id = dmc.getProperty("OSID").toString();
            this.name = (String)dmc.getProperty("Name");
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDebuggerAttached() {
            return true;
        }
    }
}

