/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.remote.launching;

import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.GDBServerCDIDebugger2;
import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.cdt.internal.launch.remote.Messages;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.cdt.launch.remote.RSEHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;

public class RemoteRunLaunchDelegate
extends AbstractCLaunchDelegate {
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block27: {
            IBinaryParser.IBinaryObject exeFile = null;
            IPath exePath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
            ICProject project = CDebugUtils.verifyCProject((ILaunchConfiguration)config);
            if (exePath != null) {
                exeFile = this.verifyBinary(project, exePath);
                String arguments = this.getProgramArguments(config);
                String remoteExePath = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_PATH, "");
                String prelaunchCmd = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_PRERUN_COMMANDS, "");
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                if (!RSECorePlugin.isInitComplete((int)1)) {
                    monitor.subTask(Messages.RemoteRunLaunchDelegate_10);
                    try {
                        RSECorePlugin.waitForInitCompletion((int)1);
                    }
                    catch (InterruptedException e) {
                        throw new CoreException((IStatus)new Status(4, this.getPluginID(), 0, e.getLocalizedMessage(), (Throwable)e));
                    }
                }
                if (mode.equals("debug")) {
                    monitor.beginTask(Messages.RemoteRunLaunchDelegate_0, 100);
                    this.setDefaultSourceLocator(launch, config);
                    String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
                    if (debugMode.equals("run")) {
                        Process remoteShellProcess = null;
                        ICDISession dsession = null;
                        try {
                            try {
                                monitor.setTaskName(Messages.RemoteRunLaunchDelegate_2);
                                RSEHelper.remoteFileDownload(config, launch, exePath.toString(), remoteExePath, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
                                String gdbserver_port_number = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_PORT, "2345");
                                String gdbserver_command = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_COMMAND, "gdbserver");
                                String command_arguments = ":" + gdbserver_port_number + " " + RSEHelper.spaceEscapify(remoteExePath);
                                if (arguments != null && !arguments.equals("")) {
                                    command_arguments = String.valueOf(command_arguments) + " " + arguments;
                                }
                                monitor.setTaskName(Messages.RemoteRunLaunchDelegate_9);
                                remoteShellProcess = RSEHelper.remoteShellExec(config, prelaunchCmd, gdbserver_command, command_arguments, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                                DebugPlugin.newProcess((ILaunch)launch, (Process)remoteShellProcess, (String)Messages.RemoteRunLaunchDelegate_RemoteShell);
                                ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                                wc.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, true);
                                wc.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_HOST, RSEHelper.getRemoteHostname(config));
                                wc.setAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_PORT, gdbserver_port_number);
                                wc.doSave();
                                GDBServerCDIDebugger2 debugger = new GDBServerCDIDebugger2();
                                dsession = debugger.createSession(launch, exePath.toFile(), (IProgressMonitor)new SubProgressMonitor(monitor, 15));
                                boolean stopInMain = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
                                String stopSymbol = null;
                                if (stopInMain) {
                                    stopSymbol = launch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main");
                                }
                                ICDITarget[] targets = dsession.getTargets();
                                int i = 0;
                                while (i < targets.length) {
                                    Process process = targets[i].getProcess();
                                    IProcess iprocess = null;
                                    if (process != null) {
                                        iprocess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(exePath.toOSString()), (Map)this.getDefaultProcessMap());
                                    }
                                    CDIDebugModel.newDebugTarget((ILaunch)launch, (IProject)project.getProject(), (ICDITarget)targets[i], (String)this.renderProcessLabel("gdbserver debugger"), (IProcess)iprocess, (IBinaryParser.IBinaryObject)exeFile, (boolean)true, (boolean)false, (String)stopSymbol, (boolean)true);
                                    ++i;
                                }
                            }
                            catch (CoreException e) {
                                try {
                                    if (dsession != null) {
                                        dsession.terminate();
                                    }
                                    if (remoteShellProcess != null) {
                                        remoteShellProcess.destroy();
                                    }
                                }
                                catch (CDIException cDIException) {}
                                throw e;
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                } else {
                    if (mode.equals("run")) {
                        monitor.beginTask(Messages.RemoteRunLaunchDelegate_0, 100);
                        Process remoteProcess = null;
                        try {
                            monitor.setTaskName(Messages.RemoteRunLaunchDelegate_2);
                            RSEHelper.remoteFileDownload(config, launch, exePath.toString(), remoteExePath, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
                            monitor.setTaskName(Messages.RemoteRunLaunchDelegate_12);
                            remoteProcess = RSEHelper.remoteShellExec(config, prelaunchCmd, remoteExePath, arguments, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                            DebugPlugin.newProcess((ILaunch)launch, (Process)remoteProcess, (String)this.renderProcessLabel(exePath.toOSString()));
                            break block27;
                        }
                        finally {
                            monitor.done();
                        }
                    }
                    Status status = new Status(4, this.getPluginID(), 0, NLS.bind((String)Messages.RemoteRunLaunchDelegate_1, (Object)mode), null);
                    throw new CoreException((IStatus)status);
                }
            }
        }
    }

    protected String getPluginID() {
        return "org.eclipse.cdt.launch.remote";
    }
}

