/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.scripting;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.cdt.internal.scripting.RPCBridge;
import org.eclipse.cdt.scripting.Activities;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.http.jetty.JettyConfigurator;
import org.eclipse.ui.IStartup;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ScriptingPlugin
extends Plugin
implements IStartup {
    public static final String PLUGIN_ID = "org.eclipse.cdt.scripting";
    private static ScriptingPlugin plugin;
    private static BundleContext bundleContext;
    public static final String HELP_CONTEXT_ID = "scripting_help_context";
    public static final String SCRIPTING_ENABLED = "Scripting.Scripting_Enabled";
    public static final String PORT_NUMBER = "Scripting.Port_Number";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        bundleContext = context;
        this.startServelet();
        this.readExtensions();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ScriptingPlugin getDefault() {
        return plugin;
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public static void log(IStatus status) {
        ScriptingPlugin.getDefault().getLog().log(status);
    }

    public static void log(String message, Throwable t) {
        ScriptingPlugin.log((IStatus)new Status(4, PLUGIN_ID, message, t));
    }

    private void startServelet() {
        org.apache.log4j.Logger.getLogger((String)"org.jabsorb.JSONSerializer").setLevel(org.apache.log4j.Level.OFF);
        new Thread("Server Sr"){

            public void run() {
                try {
                    boolean enabled = new InstanceScope().getNode(ScriptingPlugin.PLUGIN_ID).getBoolean(ScriptingPlugin.SCRIPTING_ENABLED, false);
                    if (enabled) {
                        int portNumber = new InstanceScope().getNode(ScriptingPlugin.PLUGIN_ID).getInt(ScriptingPlugin.PORT_NUMBER, 5660);
                        Bundle bundle = Platform.getBundle((String)"org.eclipse.equinox.http.registry");
                        if (bundle.getState() == 4) {
                            bundle.start(1);
                        }
                        Hashtable<String, Integer> d = new Hashtable<String, Integer>();
                        ((Dictionary)d).put("http.port", portNumber);
                        Logger.getLogger("org.mortbay").setLevel(Level.WARNING);
                        JettyConfigurator.startServer((String)"jsonrpc", d);
                    }
                }
                catch (Throwable t) {
                    ScriptingPlugin.log(null, t);
                }
            }
        }.start();
    }

    private void readExtensions() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.cdt.scripting.scriptableFeature");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            RPCBridge.instance().addExtension(element);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int newPendingActivityId() {
        int id = Activities.nextActivityId++;
        Set<Integer> set = Activities.pendingActivityIds;
        synchronized (set) {
            Activities.pendingActivityIds.add(id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setActivityDone(int id) {
        Set<Integer> set = Activities.pendingActivityIds;
        synchronized (set) {
            Activities.pendingActivityIds.remove(id);
        }
    }

    public void earlyStartup() {
    }
}

