/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.internal.ui.refactoring.rename.ASTManager;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRefactoringArgument;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRefactoringMatch;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRefactory;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameProcessor;
import org.eclipse.cdt.internal.ui.refactoring.rename.RenameMessages;
import org.eclipse.cdt.internal.ui.refactoring.rename.TextSearchWrapper;
import org.eclipse.cdt.ui.refactoring.CTextFileChange;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CRenameProcessorDelegate {
    private CRenameProcessor fTopProcessor;
    private ArrayList<CRefactoringMatch> fMatches;
    protected String fProcessorBaseName;
    private int fAvailableOptions = 663;
    private int fOptionsForcingPreview;
    private int fOptionsEnablingScope = this.fOptionsForcingPreview = 118;

    protected CRenameProcessorDelegate(CRenameProcessor topProcessor, String name) {
        this.fTopProcessor = topProcessor;
        this.fProcessorBaseName = name;
    }

    public final CRefactoringArgument getArgument() {
        return this.fTopProcessor.getArgument();
    }

    public final String getReplacementText() {
        return this.fTopProcessor.getReplacementText();
    }

    public final int getSelectedScope() {
        return this.fTopProcessor.getScope();
    }

    public final int getSelectedOptions() {
        return this.fTopProcessor.getSelectedOptions();
    }

    public final String getSelectedWorkingSet() {
        return this.fTopProcessor.getWorkingSet();
    }

    public final CRefactory getManager() {
        return this.fTopProcessor.getManager();
    }

    public final ASTManager getAstManager() {
        return this.fTopProcessor.getAstManager();
    }

    public final IIndex getIndex() {
        return this.fTopProcessor.getIndex();
    }

    public final String getProcessorName() {
        String identifier = this.getArgument().getName();
        if (identifier != null) {
            return NLS.bind((String)RenameMessages.CRenameProcessorDelegate_wizard_title, (Object)this.fProcessorBaseName, (Object)identifier);
        }
        return null;
    }

    public void setAvailableOptions(int options) {
        this.fAvailableOptions = options;
    }

    final int getAvailableOptions() {
        return this.fAvailableOptions;
    }

    public void setOptionsForcingPreview(int options) {
        this.fOptionsForcingPreview = options;
    }

    final int getOptionsForcingPreview() {
        return this.fOptionsForcingPreview;
    }

    public void setOptionsEnablingScope(int options) {
        this.fOptionsEnablingScope = options;
    }

    final int getOptionsEnablingScope() {
        return this.fOptionsEnablingScope;
    }

    protected int getSearchScope() {
        return this.getSelectedScope();
    }

    /*
     * Exception decompiling
     */
    private Collection<IResource> getFileFilter(IBinding[] bindings) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index: 0, Size: 0
         *     at java.base/java.util.LinkedList.checkElementIndex(LinkedList.java:566)
         *     at java.base/java.util.LinkedList.get(LinkedList.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.combineInlineable(Block.java:226)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:560)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCatch.transformStructuredChildren(StructuredCatch.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:129)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:127)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.inlinePossibles(Op04StructuredStatement.java:709)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:855)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        String msg;
        RefactoringStatus result = new RefactoringStatus();
        monitor.beginTask(RenameMessages.CRenameProcessorDelegate_task_checkFinalCondition, 2);
        IFile file = this.getArgument().getSourceFile();
        IBinding[] renameBindings = this.getBindingsToBeRenamed(result);
        this.fMatches = new ArrayList();
        TextSearchWrapper txtSearch = this.getManager().getTextSearch();
        Collection<IResource> fileFilter = this.getFileFilter(renameBindings);
        if (fileFilter != null && !fileFilter.contains(file)) {
            fileFilter.add((IResource)file);
        }
        IStatus stat = txtSearch.searchWord(this.getSearchScope(), file, this.getSelectedWorkingSet(), fileFilter != null ? fileFilter.toArray(new IResource[fileFilter.size()]) : null, this.getManager().getCCppPatterns(), this.getArgument().getName(), (IProgressMonitor)new SubProgressMonitor(monitor, 1), this.fMatches);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        result.merge(RefactoringStatus.create((IStatus)stat));
        if (result.hasFatalError()) {
            return result;
        }
        this.selectMatchesByLocation(this.fMatches);
        this.analyzeTextMatches(renameBindings, this.fMatches, (IProgressMonitor)new SubProgressMonitor(monitor, 1), result);
        if (result.hasFatalError()) {
            return result;
        }
        HashSet<IFile> fileset = new HashSet<IFile>();
        int potentialMatchCount = 0;
        int commentCount = 0;
        Iterator<CRefactoringMatch> iter = this.fMatches.iterator();
        while (iter.hasNext()) {
            CRefactoringMatch tm = iter.next();
            if (tm.isInComment()) {
                ++commentCount;
                fileset.add(tm.getFile());
                continue;
            }
            switch (tm.getAstInformation()) {
                case 2: {
                    iter.remove();
                    break;
                }
                case 0: {
                    ++potentialMatchCount;
                    fileset.add(tm.getFile());
                    break;
                }
                default: {
                    fileset.add(tm.getFile());
                }
            }
        }
        if (potentialMatchCount != 0) {
            msg = null;
            msg = potentialMatchCount == 1 ? RenameMessages.CRenameProcessorDelegate_warning_potentialMatch_singular : NLS.bind((String)RenameMessages.CRenameProcessorDelegate_warning_potentialMatch_plural, (Object)potentialMatchCount);
            result.addWarning(msg);
        }
        if (commentCount != 0) {
            msg = null;
            msg = commentCount == 1 ? RenameMessages.CRenameProcessorDelegate_warning_commentMatch_singular : NLS.bind((String)RenameMessages.CRenameProcessorDelegate_warning_commentMatch_plural, (Object)commentCount);
            result.addWarning(msg);
        }
        IFile[] files = fileset.toArray(new IFile[fileset.size()]);
        if (context != null) {
            ValidateEditChecker editChecker = (ValidateEditChecker)context.getChecker(ValidateEditChecker.class);
            editChecker.addFiles(files);
        }
        monitor.done();
        return result;
    }

    protected void analyzeTextMatches(IBinding[] renameBindings, Collection<CRefactoringMatch> matches, IProgressMonitor monitor, RefactoringStatus status) {
        if (renameBindings.length > 0 && this.getArgument().getArgumentKind() != 0) {
            ASTManager mngr = this.getAstManager();
            mngr.setValidBindings(renameBindings);
            mngr.setRenameTo(this.getReplacementText());
            mngr.analyzeTextMatches(this.fTopProcessor.getIndex(), matches, monitor, status);
        }
    }

    private void selectMatchesByLocation(Collection<CRefactoringMatch> matches) {
        int acceptTextLocation = this.getAcceptedLocations(this.getSelectedOptions());
        Iterator<CRefactoringMatch> iter = matches.iterator();
        while (iter.hasNext()) {
            CRefactoringMatch match = iter.next();
            int location = match.getLocation();
            if (location == 0 || (location & acceptTextLocation) != 0) continue;
            iter.remove();
        }
    }

    protected int getAcceptedLocations(int selectedOptions) {
        return selectedOptions;
    }

    /*
     * Unable to fully structure code
     */
    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.fMatches.isEmpty()) {
            return null;
        }
        Collections.sort(this.fMatches, new Comparator<CRefactoringMatch>(){

            @Override
            public int compare(CRefactoringMatch m1, CRefactoringMatch m2) {
                IFile f1 = m1.getFile();
                IFile f2 = m2.getFile();
                int cmp = f1.getName().compareTo(f2.getName());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = f1.getFullPath().toString().compareTo(f2.getFullPath().toString());
                if (cmp != 0) {
                    return cmp;
                }
                return m1.getOffset() - m2.getOffset();
            }
        });
        pm.beginTask(RenameMessages.CRenameProcessorDelegate_task_createChange, this.fMatches.size());
        identifier = this.getArgument().getName();
        replacement = this.getReplacementText();
        overallChange = new CompositeChange(this.getProcessorName());
        file = null;
        fileChange = null;
        fileEdit = null;
        for (CRefactoringMatch match : this.fMatches) {
            switch (match.getAstInformation()) {
                case 2: {
                    break;
                }
                ** case 0:
                ** case 4:
lbl16:
                // 2 sources

                default: {
                    if (match.getAstInformation() != 2) {
                        mfile = match.getFile();
                        if (file == null || !file.equals((Object)mfile) || fileEdit == null || fileChange == null) {
                            file = mfile;
                            fileEdit = new MultiTextEdit();
                            fileChange = new CTextFileChange(file.getName(), file);
                            fileChange.setEdit((TextEdit)fileEdit);
                            overallChange.add((Change)fileChange);
                        }
                        replaceEdit = new ReplaceEdit(match.getOffset(), identifier.length(), replacement);
                        fileEdit.addChild((TextEdit)replaceEdit);
                        editGroup = new TextEditGroup(match.getLabel(), (TextEdit)replaceEdit);
                        changeGroup = new TextEditChangeGroup((TextChange)fileChange, editGroup);
                        fileChange.addTextEditChangeGroup(changeGroup);
                    }
                    pm.worked(1);
                }
            }
        }
        return overallChange;
    }

    protected IBinding[] getBindingsToBeRenamed(RefactoringStatus status) {
        return new IBinding[]{this.getArgument().getBinding()};
    }

    public abstract int getSaveMode();
}

