/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.LineSearchElement;
import org.eclipse.cdt.internal.ui.search.PDOMSearchLabelProvider;
import org.eclipse.cdt.internal.ui.search.PDOMSearchViewPage;
import org.eclipse.cdt.internal.ui.util.Messages;
import org.eclipse.jface.viewers.StyledString;

public class PDOMSearchTreeLabelProvider
extends PDOMSearchLabelProvider {
    public PDOMSearchTreeLabelProvider(PDOMSearchViewPage page) {
        super(page);
    }

    public String getText(Object element) {
        String text = super.getText(element);
        int count = this.getMatchCount(element);
        if (count <= 1) {
            return text;
        }
        return String.valueOf(text) + " " + Messages.format(CSearchMessages.CSearchResultCollector_matches, new Integer(count));
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof TranslationUnit) {
            StyledString styled = new StyledString(super.getText(element));
            int count = this.getMatchCount(element);
            if (count > 1) {
                String matchesCount = " " + Messages.format(CSearchMessages.CSearchResultCollector_matches, new Integer(count));
                styled.append(matchesCount, StyledString.COUNTER_STYLER);
                return styled;
            }
        }
        if (!(element instanceof LineSearchElement)) {
            return new StyledString(this.getText(element));
        }
        LineSearchElement lineElement = (LineSearchElement)element;
        String enclosingName = "";
        ICElement enclosingElement = lineElement.getMatches()[0].getEnclosingElement();
        if (this.fPage.isShowEnclosingDefinitions() && enclosingElement != null) {
            enclosingName = String.valueOf(enclosingElement.getElementName()) + ", ";
        }
        Integer lineNumber = lineElement.getLineNumber();
        String prefix = Messages.format(CSearchMessages.CSearchResultCollector_line, enclosingName, lineNumber);
        prefix = String.valueOf(prefix) + ":  ";
        StyledString location = new StyledString(prefix, StyledString.QUALIFIER_STYLER);
        return location.append(super.getStyledText(element));
    }
}

