/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.IExpressionsListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.commands.IDisconnectHandler;
import org.eclipse.debug.core.commands.IDropToFrameHandler;
import org.eclipse.debug.core.commands.IResumeHandler;
import org.eclipse.debug.core.commands.IStepIntoHandler;
import org.eclipse.debug.core.commands.IStepOverHandler;
import org.eclipse.debug.core.commands.IStepReturnHandler;
import org.eclipse.debug.core.commands.ISuspendHandler;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.debug.core.model.IDebugModelProvider;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.debug.ui.contexts.ISuspendTrigger;
import org.eclipse.debug.ui.contexts.ISuspendTriggerListener;
import org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditorInput;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.internal.tcf.debug.actions.TCFAction;
import org.eclipse.tm.internal.tcf.debug.launch.TCFSourceLookupDirector;
import org.eclipse.tm.internal.tcf.debug.launch.TCFSourceLookupParticipant;
import org.eclipse.tm.internal.tcf.debug.model.TCFContextState;
import org.eclipse.tm.internal.tcf.debug.model.TCFLaunch;
import org.eclipse.tm.internal.tcf.debug.model.TCFSourceRef;
import org.eclipse.tm.internal.tcf.debug.ui.Activator;
import org.eclipse.tm.internal.tcf.debug.ui.commands.BackIntoCommand;
import org.eclipse.tm.internal.tcf.debug.ui.commands.BackOverCommand;
import org.eclipse.tm.internal.tcf.debug.ui.commands.BackResumeCommand;
import org.eclipse.tm.internal.tcf.debug.ui.commands.BackReturnCommand;
import org.eclipse.tm.internal.tcf.debug.ui.commands.DisconnectCommand;
import org.eclipse.tm.internal.tcf.debug.ui.commands.DropToFrameCommand;
import org.eclipse.tm.internal.tcf.debug.ui.commands.ResumeCommand;
import org.eclipse.tm.internal.tcf.debug.ui.commands.StepIntoCommand;
import org.eclipse.tm.internal.tcf.debug.ui.commands.StepOverCommand;
import org.eclipse.tm.internal.tcf.debug.ui.commands.StepReturnCommand;
import org.eclipse.tm.internal.tcf.debug.ui.commands.SuspendCommand;
import org.eclipse.tm.internal.tcf.debug.ui.commands.TerminateCommand;
import org.eclipse.tm.internal.tcf.debug.ui.model.ICastToType;
import org.eclipse.tm.internal.tcf.debug.ui.model.ISourceNotFoundPresentation;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFAnnotationManager;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildren;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFColumnPresentationExpression;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFColumnPresentationModules;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFColumnPresentationRegister;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFConsole;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFMemoryBlockRetrieval;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModelPresentation;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModelProxy;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModelSelectionPolicy;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeLaunch;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeRegister;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeSymbol;
import org.eclipse.tm.tcf.core.Command;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IErrorReport;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IDisassembly;
import org.eclipse.tm.tcf.services.ILineNumbers;
import org.eclipse.tm.tcf.services.IMemory;
import org.eclipse.tm.tcf.services.IMemoryMap;
import org.eclipse.tm.tcf.services.IProcesses;
import org.eclipse.tm.tcf.services.IRegisters;
import org.eclipse.tm.tcf.services.IRunControl;
import org.eclipse.tm.tcf.services.ISymbols;
import org.eclipse.tm.tcf.util.TCFDataCache;
import org.eclipse.tm.tcf.util.TCFTask;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFModel
implements IElementContentProvider,
IElementLabelProvider,
IViewerInputProvider,
IModelProxyFactory,
IColumnPresentationFactory,
ISourceDisplay,
ISuspendTrigger {
    public static final String ID_EXPRESSION_HOVER = "org.eclipse.tm.tcf.debug.ui.expression_hover";
    private final TCFLaunch launch;
    private final Display display;
    private final IExpressionManager expr_manager;
    private final TCFAnnotationManager annotation_manager;
    private final List<ISuspendTriggerListener> suspend_trigger_listeners = new LinkedList<ISuspendTriggerListener>();
    private static int display_source_generation;
    private int suspend_trigger_generation;
    private int auto_disconnect_generation;
    private final Map<String, String> action_results = new HashMap<String, String>();
    private final HashMap<String, TCFAction> active_actions = new HashMap();
    private final Map<IPresentationContext, TCFModelProxy> model_proxies = new HashMap<IPresentationContext, TCFModelProxy>();
    private final Map<String, TCFNode> id2node = new HashMap<String, TCFNode>();
    private final Map<Class<?>, Object> adapters = new HashMap();
    private final Map<String, IMemoryBlockRetrievalExtension> mem_retrieval = new HashMap<String, IMemoryBlockRetrievalExtension>();
    private final Map<String, String> cast_to_type_map = new HashMap<String, String>();
    private final Map<String, Object> context_map = new HashMap<String, Object>();
    private TCFConsole console;
    private static final Map<ILaunchConfiguration, IEditorInput> editor_not_found;
    private final IModelSelectionPolicyFactory model_selection_factory = new IModelSelectionPolicyFactory(){

        public IModelSelectionPolicy createModelSelectionPolicyAdapter(Object element, IPresentationContext context) {
            return TCFModel.this.selection_policy;
        }
    };
    private final IModelSelectionPolicy selection_policy;
    private final HashSet<String> removed_annotations = new HashSet();
    private boolean removed_annotations_posted;
    private final Runnable removed_annotations_runnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            HashSet<String> set = null;
            HashSet hashSet = TCFModel.this.removed_annotations;
            synchronized (hashSet) {
                if (!$assertionsDisabled && !TCFModel.this.removed_annotations_posted) {
                    throw new AssertionError();
                }
                TCFModel.this.removed_annotations_posted = false;
                if (TCFModel.this.removed_annotations.size() == 0) {
                    return;
                }
                set = new HashSet<String>(TCFModel.this.removed_annotations);
                TCFModel.this.removed_annotations.clear();
            }
            TCFModel.this.annotation_manager.removeStackFrameAnnotation(TCFModel.this, set);
        }
    };
    private IChannel channel;
    private TCFNodeLaunch launch_node;
    private boolean disposed;
    private final IMemory.MemoryListener mem_listener = new IMemory.MemoryListener(){

        public void contextAdded(IMemory.MemoryContext[] contexts) {
            IMemory.MemoryContext[] memoryContextArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                IMemory.MemoryContext ctx = memoryContextArray[n2];
                String id = ctx.getParentID();
                if (id == null) {
                    TCFModel.this.launch_node.onContextAdded(ctx);
                } else {
                    TCFNode node = TCFModel.this.getNode(id);
                    if (node instanceof TCFNodeExecContext) {
                        ((TCFNodeExecContext)node).onContextAdded(ctx);
                    }
                }
                ++n2;
            }
            TCFModel.this.launch_node.onAnyContextAddedOrRemoved();
        }

        public void contextChanged(IMemory.MemoryContext[] contexts) {
            IMemory.MemoryContext[] memoryContextArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                IMemory.MemoryContext ctx = memoryContextArray[n2];
                TCFNode node = TCFModel.this.getNode(ctx.getID());
                if (node instanceof TCFNodeExecContext) {
                    ((TCFNodeExecContext)node).onContextChanged(ctx);
                }
                ++n2;
            }
        }

        public void contextRemoved(String[] context_ids) {
            TCFModel.this.onContextRemoved(context_ids);
        }

        public void memoryChanged(String context_id, Number[] addr, long[] size) {
            TCFNode node = TCFModel.this.getNode(context_id);
            if (node instanceof TCFNodeExecContext) {
                ((TCFNodeExecContext)node).onMemoryChanged(addr, size);
            }
        }
    };
    private final IRunControl.RunControlListener run_listener = new IRunControl.RunControlListener(){

        public void containerResumed(String[] context_ids) {
            String id;
            String[] stringArray = context_ids;
            int n = context_ids.length;
            int n2 = 0;
            while (n2 < n) {
                id = stringArray[n2];
                TCFNode node = TCFModel.this.getNode(id);
                if (node instanceof TCFNodeExecContext) {
                    ((TCFNodeExecContext)node).onContainerResumed();
                }
                ++n2;
            }
            stringArray = context_ids;
            n = context_ids.length;
            n2 = 0;
            while (n2 < n) {
                id = stringArray[n2];
                TCFModel.this.removeAnnotation(id);
                ++n2;
            }
        }

        public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
            int action_cnt = 0;
            String[] stringArray = suspended_ids;
            int n = suspended_ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                TCFNode node = TCFModel.this.getNode(id);
                TCFModel.this.action_results.remove(id);
                if (TCFModel.this.active_actions.get(id) != null) {
                    ++action_cnt;
                }
                if (node instanceof TCFNodeExecContext) {
                    ((TCFNodeExecContext)node).onContainerSuspended();
                }
                ++n2;
            }
            TCFNode node = TCFModel.this.getNode(context);
            if (node instanceof TCFNodeExecContext) {
                ((TCFNodeExecContext)node).onContextSuspended(pc, reason, params);
            }
            TCFModel.this.launch_node.onAnyContextSuspendedOrChanged();
            if (action_cnt == 0) {
                TCFModel.this.setDebugViewSelection(node, reason);
            }
            TCFModel.this.action_results.remove(context);
        }

        public void contextAdded(IRunControl.RunControlContext[] contexts) {
            IRunControl.RunControlContext[] runControlContextArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                IRunControl.RunControlContext ctx = runControlContextArray[n2];
                String id = ctx.getParentID();
                if (id == null) {
                    TCFModel.this.launch_node.onContextAdded(ctx);
                } else {
                    TCFNode node = TCFModel.this.getNode(id);
                    if (node instanceof TCFNodeExecContext) {
                        ((TCFNodeExecContext)node).onContextAdded(ctx);
                    }
                }
                TCFModel.this.context_map.put(ctx.getID(), ctx);
                ++n2;
            }
            TCFModel.this.launch_node.onAnyContextAddedOrRemoved();
        }

        public void contextChanged(IRunControl.RunControlContext[] contexts) {
            IRunControl.RunControlContext[] runControlContextArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                IRunControl.RunControlContext ctx = runControlContextArray[n2];
                String id = ctx.getID();
                TCFModel.this.context_map.put(id, ctx);
                TCFNode node = TCFModel.this.getNode(id);
                if (node instanceof TCFNodeExecContext) {
                    ((TCFNodeExecContext)node).onContextChanged(ctx);
                }
                ++n2;
            }
            TCFModel.this.launch_node.onAnyContextSuspendedOrChanged();
        }

        public void contextException(String context, String msg) {
            TCFNode node = TCFModel.this.getNode(context);
            if (node instanceof TCFNodeExecContext) {
                ((TCFNodeExecContext)node).onContextException(msg);
            }
        }

        public void contextRemoved(String[] context_ids) {
            TCFModel.this.onContextRemoved(context_ids);
        }

        public void contextResumed(String id) {
            TCFNode node = TCFModel.this.getNode(id);
            if (node instanceof TCFNodeExecContext) {
                ((TCFNodeExecContext)node).onContextResumed();
            }
            TCFModel.this.removeAnnotation(id);
        }

        public void contextSuspended(String id, String pc, String reason, Map<String, Object> params) {
            TCFNode node = TCFModel.this.getNode(id);
            TCFModel.this.action_results.remove(id);
            if (node instanceof TCFNodeExecContext) {
                TCFNodeExecContext exe = (TCFNodeExecContext)node;
                exe.onContextSuspended(pc, reason, params);
            }
            TCFModel.this.launch_node.onAnyContextSuspendedOrChanged();
            if (TCFModel.this.active_actions.get(id) == null) {
                TCFModel.this.setDebugViewSelection(node, reason);
            }
        }
    };
    private final IMemoryMap.MemoryMapListener mmap_listenr = new IMemoryMap.MemoryMapListener(){

        public void changed(String context) {
            TCFNode node = TCFModel.this.getNode(context);
            if (node instanceof TCFNodeExecContext) {
                TCFNodeExecContext exe = (TCFNodeExecContext)node;
                exe.onMemoryMapChanged();
            }
            TCFModel.this.display.asyncExec(new Runnable(){

                public void run() {
                    if (PlatformUI.isWorkbenchRunning()) {
                        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                        int n = iWorkbenchWindowArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                            IWorkbenchPage page = window.getActivePage();
                            if (page != null) {
                                TCFModel.this.displaySource(null, page, true);
                            }
                            ++n2;
                        }
                    }
                }
            });
        }
    };
    private final IRegisters.RegistersListener reg_listener = new IRegisters.RegistersListener(){

        public void contextChanged() {
            for (TCFNode node : TCFModel.this.id2node.values()) {
                if (!(node instanceof TCFNodeExecContext)) continue;
                ((TCFNodeExecContext)node).onRegistersChanged();
            }
        }

        public void registerChanged(String context) {
            TCFNode node = TCFModel.this.getNode(context);
            if (node instanceof TCFNodeRegister) {
                ((TCFNodeRegister)node).onValueChanged();
            }
        }
    };
    private final IProcesses.ProcessesListener prs_listener = new IProcesses.ProcessesListener(){

        public void exited(String process_id, int exit_code) {
            IProcesses.ProcessContext prs = TCFModel.this.launch.getProcessContext();
            if (prs != null && process_id.equals(prs.getID())) {
                TCFModel.this.onContextOrProcessRemoved();
            }
        }
    };
    private final IExpressionsListener expressions_listener = new IExpressionsListener(){
        int generation;

        public void expressionsAdded(IExpression[] expressions) {
            this.expressionsRemoved(expressions);
        }

        public void expressionsChanged(IExpression[] expressions) {
            this.expressionsRemoved(expressions);
        }

        public void expressionsRemoved(IExpression[] expressions) {
            final int g = ++this.generation;
            Protocol.invokeLater((Runnable)new Runnable(){

                public void run() {
                    if (g != generation) {
                        return;
                    }
                    for (TCFNode n : TCFModel.this.id2node.values()) {
                        if (!(n instanceof TCFNodeExecContext)) continue;
                        ((TCFNodeExecContext)n).onExpressionAddedOrRemoved();
                    }
                    for (TCFModelProxy p : TCFModel.this.model_proxies.values()) {
                        Object o;
                        String id = p.getPresentationContext().getId();
                        if (!"org.eclipse.debug.ui.ExpressionView".equals(id) || !((o = p.getInput()) instanceof TCFNode)) continue;
                        TCFNode n = (TCFNode)o;
                        if (n.model != TCFModel.this) continue;
                        p.addDelta(n, 1024);
                    }
                }
            });
        }
    };
    private final TCFLaunch.ActionsListener actions_listener = new TCFLaunch.ActionsListener(){

        public void onContextActionStart(TCFAction action) {
            String id = action.getContextID();
            TCFModel.this.active_actions.put(id, action);
            TCFModel.this.removeAnnotation(id);
        }

        public void onContextActionResult(String id, String reason) {
            if (reason == null) {
                TCFModel.this.action_results.remove(id);
            } else {
                TCFModel.this.action_results.put(id, reason);
            }
        }

        public void onContextActionDone(TCFAction action) {
            String id = action.getContextID();
            TCFModel.this.active_actions.remove(id);
            TCFNode node = TCFModel.this.getNode(id);
            if (node instanceof TCFNodeExecContext) {
                ((TCFNodeExecContext)node).onContextActionDone();
            }
            TCFModel.this.setDebugViewSelection((TCFNode)TCFModel.this.id2node.get(id), "Action");
            for (TCFModelProxy p : TCFModel.this.model_proxies.values()) {
                p.post();
            }
        }
    };
    private final IDebugModelProvider debug_model_provider = new IDebugModelProvider(){

        public String[] getModelIdentifiers() {
            return new String[]{"org.eclipse.tm.tcf.debug"};
        }
    };
    private volatile boolean instruction_stepping_enabled;

    static {
        editor_not_found = new HashMap<ILaunchConfiguration, IEditorInput>();
    }

    TCFModel(TCFLaunch launch) {
        this.launch = launch;
        this.display = PlatformUI.getWorkbench().getDisplay();
        this.selection_policy = new TCFModelSelectionPolicy(this);
        this.adapters.put(ILaunch.class, launch);
        this.adapters.put(IModelSelectionPolicy.class, this.selection_policy);
        this.adapters.put(IModelSelectionPolicyFactory.class, this.model_selection_factory);
        this.adapters.put(IDebugModelProvider.class, this.debug_model_provider);
        this.adapters.put(ISuspendHandler.class, new SuspendCommand(this));
        this.adapters.put(IResumeHandler.class, new ResumeCommand(this));
        this.adapters.put(BackResumeCommand.class, new BackResumeCommand(this));
        this.adapters.put(ITerminateHandler.class, new TerminateCommand(this));
        this.adapters.put(IDisconnectHandler.class, new DisconnectCommand(this));
        this.adapters.put(IStepIntoHandler.class, new StepIntoCommand(this));
        this.adapters.put(IStepOverHandler.class, new StepOverCommand(this));
        this.adapters.put(IStepReturnHandler.class, new StepReturnCommand(this));
        this.adapters.put(BackIntoCommand.class, new BackIntoCommand(this));
        this.adapters.put(BackOverCommand.class, new BackOverCommand(this));
        this.adapters.put(BackReturnCommand.class, new BackReturnCommand(this));
        this.adapters.put(IDropToFrameHandler.class, new DropToFrameCommand(this));
        this.expr_manager = DebugPlugin.getDefault().getExpressionManager();
        this.expr_manager.addExpressionListener(this.expressions_listener);
        this.annotation_manager = Activator.getAnnotationManager();
        launch.addActionsListener(this.actions_listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdapter(Class<?> adapterType, Object adapter) {
        Map<Class<?>, Object> map = this.adapters;
        synchronized (map) {
            assert (adapterType.isInstance(adapter));
            this.adapters.put(adapterType, adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAdapter(final Class adapter, final TCFNode node) {
        Map<Class<?>, Object> map = this.adapters;
        synchronized (map) {
            Object o = this.adapters.get(adapter);
            if (o != null) {
                return o;
            }
        }
        if (adapter == IMemoryBlockRetrieval.class || adapter == IMemoryBlockRetrievalExtension.class) {
            return new TCFTask<Object>(){

                public void run() {
                    TCFMemoryBlockRetrieval o = null;
                    TCFDataCache<TCFNodeExecContext> cache = TCFModel.this.searchMemoryContext(node);
                    if (cache != null) {
                        if (!cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        if (cache.getData() != null) {
                            TCFNodeExecContext ctx = (TCFNodeExecContext)cache.getData();
                            o = (TCFMemoryBlockRetrieval)TCFModel.this.mem_retrieval.get(ctx.id);
                            if (o == null) {
                                TCFMemoryBlockRetrieval m = new TCFMemoryBlockRetrieval(ctx);
                                TCFModel.this.mem_retrieval.put(ctx.id, m);
                                o = m;
                            }
                        }
                    }
                    if (!$assertionsDisabled && o != null && !adapter.isInstance(o)) {
                        throw new AssertionError();
                    }
                    this.done(o);
                }
            }.getE();
        }
        return null;
    }

    void onConnected() {
        IProcesses prs;
        IRegisters reg;
        IMemoryMap mmap;
        IRunControl run;
        assert (Protocol.isDispatchThread());
        assert (this.launch_node == null);
        this.channel = this.launch.getChannel();
        this.launch_node = new TCFNodeLaunch(this);
        IMemory mem = (IMemory)this.launch.getService(IMemory.class);
        if (mem != null) {
            mem.addListener(this.mem_listener);
        }
        if ((run = (IRunControl)this.launch.getService(IRunControl.class)) != null) {
            run.addListener(this.run_listener);
        }
        if ((mmap = (IMemoryMap)this.launch.getService(IMemoryMap.class)) != null) {
            mmap.addListener(this.mmap_listenr);
        }
        if ((reg = (IRegisters)this.launch.getService(IRegisters.class)) != null) {
            reg.addListener(this.reg_listener);
        }
        if ((prs = (IProcesses)this.launch.getService(IProcesses.class)) != null) {
            prs.addListener(this.prs_listener);
        }
        this.launchChanged();
    }

    void onDisconnected() {
        assert (Protocol.isDispatchThread());
        if (this.launch_node != null) {
            this.launch_node.dispose();
            this.launch_node = null;
        }
        this.refreshLaunchView();
        assert (this.id2node.size() == 0);
    }

    void onProcessOutput(String process_id, int stream_id, byte[] data) {
        IProcesses.ProcessContext prs = this.launch.getProcessContext();
        if (prs == null || !process_id.equals(prs.getID())) {
            return;
        }
        if (this.console == null) {
            this.console = new TCFConsole(this, process_id);
        }
        this.console.write(stream_id, data);
    }

    void onProcessStreamError(String process_id, int stream_id, Exception x, int lost_size) {
        if (this.channel != null && this.channel.getState() == 2) {
            return;
        }
        StringBuffer bf = new StringBuffer();
        bf.append("Debugger console IO error");
        if (process_id != null) {
            bf.append(". Process ID ");
            bf.append(process_id);
        }
        bf.append(". Stream ");
        bf.append(stream_id);
        if (lost_size > 0) {
            bf.append(". Lost data size ");
            bf.append(lost_size);
        }
        Activator.log(bf.toString(), x);
    }

    public TCFAction getActiveAction(String id) {
        return this.active_actions.get(id);
    }

    String getContextActionResult(String id) {
        return this.action_results.get(id);
    }

    void onProxyInstalled(TCFModelProxy mp) {
        this.model_proxies.put(mp.getPresentationContext(), mp);
    }

    void onProxyDisposed(TCFModelProxy mp) {
        IPresentationContext ctx = mp.getPresentationContext();
        assert (this.model_proxies.get(ctx) == mp);
        this.model_proxies.remove(ctx);
    }

    private void onContextRemoved(String[] context_ids) {
        String id;
        String[] stringArray = context_ids;
        int n = context_ids.length;
        int n2 = 0;
        while (n2 < n) {
            id = stringArray[n2];
            TCFNode node = this.getNode(id);
            if (node instanceof TCFNodeExecContext) {
                ((TCFNodeExecContext)node).onContextRemoved();
            }
            this.action_results.remove(id);
            this.context_map.remove(id);
            ++n2;
        }
        this.launch_node.onAnyContextAddedOrRemoved();
        this.onContextOrProcessRemoved();
        stringArray = context_ids;
        n = context_ids.length;
        n2 = 0;
        while (n2 < n) {
            id = stringArray[n2];
            this.removeAnnotation(id);
            ++n2;
        }
    }

    private void onContextOrProcessRemoved() {
        final int generation = ++this.auto_disconnect_generation;
        Protocol.invokeLater((long)1000L, (Runnable)new Runnable(){

            public void run() {
                if (generation != TCFModel.this.auto_disconnect_generation) {
                    return;
                }
                if (TCFModel.this.launch_node == null) {
                    return;
                }
                if (TCFModel.this.launch_node.isDisposed()) {
                    return;
                }
                TCFNode.TCFData<TCFNode[]> children = TCFModel.this.launch_node.getFilteredChildren();
                if (!children.validate(this)) {
                    return;
                }
                TCFNode[] arr = (TCFNode[])children.getData();
                if (arr != null && arr.length > 0) {
                    return;
                }
                TCFModel.this.launch.onLastContextRemoved();
            }
        });
    }

    void launchChanged() {
        if (this.launch_node != null) {
            for (TCFModelProxy p : this.model_proxies.values()) {
                String id = p.getPresentationContext().getId();
                if (!"org.eclipse.debug.ui.DebugView".equals(id)) continue;
                p.addDelta(this.launch_node, 3072);
            }
        } else {
            this.refreshLaunchView();
        }
    }

    Collection<TCFModelProxy> getModelProxies() {
        return this.model_proxies.values();
    }

    void dispose() {
        this.launch.removeActionsListener(this.actions_listener);
        this.expr_manager.removeExpressionListener(this.expressions_listener);
        if (this.console != null) {
            this.console.close();
        }
    }

    void addNode(String id, TCFNode node) {
        assert (id != null);
        assert (Protocol.isDispatchThread());
        assert (this.id2node.get(id) == null);
        assert (!node.isDisposed());
        this.id2node.put(id, node);
    }

    void removeNode(String id) {
        assert (id != null);
        assert (Protocol.isDispatchThread());
        this.id2node.remove(id);
        this.mem_retrieval.remove(id);
    }

    IExpressionManager getExpressionManager() {
        return this.expr_manager;
    }

    public Display getDisplay() {
        return this.display;
    }

    public TCFLaunch getLaunch() {
        return this.launch;
    }

    public IChannel getChannel() {
        return this.channel;
    }

    public TCFNodeLaunch getRootNode() {
        return this.launch_node;
    }

    public TCFChildren getHoverExpressionCache(TCFNode parent, String expression) {
        assert (Protocol.isDispatchThread());
        if (parent instanceof TCFNodeStackFrame) {
            return ((TCFNodeStackFrame)parent).getHoverExpressionCache(expression);
        }
        if (parent instanceof TCFNodeExecContext) {
            return ((TCFNodeExecContext)parent).getHoverExpressionCache(expression);
        }
        return null;
    }

    public TCFNode getNode(String id) {
        if (id == null) {
            return null;
        }
        if (id.equals("")) {
            return this.launch_node;
        }
        assert (Protocol.isDispatchThread());
        return this.id2node.get(id);
    }

    public String getCastToType(String id) {
        return this.cast_to_type_map.get(id);
    }

    public void setCastToType(String id, String type) {
        if (type != null && type.trim().length() == 0) {
            type = null;
        }
        if (type == null) {
            this.cast_to_type_map.remove(id);
        } else {
            this.cast_to_type_map.put(id, type);
        }
        TCFNode node = this.id2node.get(id);
        if (node instanceof ICastToType) {
            ((ICastToType)((Object)node)).onCastToTypeChanged();
        }
    }

    public TCFDataCache<ISymbols.Symbol> getSymbolInfoCache(String sym_id) {
        if (sym_id == null) {
            return null;
        }
        TCFNodeSymbol n = (TCFNodeSymbol)this.getNode(sym_id);
        if (n == null) {
            n = new TCFNodeSymbol(this.launch_node, sym_id);
        }
        return n.getContext();
    }

    public TCFDataCache<String[]> getSymbolChildrenCache(String sym_id) {
        if (sym_id == null) {
            return null;
        }
        TCFNodeSymbol n = (TCFNodeSymbol)this.getNode(sym_id);
        if (n == null) {
            n = new TCFNodeSymbol(this.launch_node, sym_id);
        }
        return n.getChildren();
    }

    public TCFDataCache<TCFNodeExecContext> searchMemoryContext(TCFNode node) {
        TCFNode n = node;
        while (n != null && !n.isDisposed()) {
            if (n instanceof TCFNodeExecContext) {
                return ((TCFNodeExecContext)n).getMemoryNode();
            }
            n = n.parent;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean createNode(String id, final TCFDataCache<?> cache) {
        parent = this.getNode(id);
        if (parent != null) {
            return true;
        }
        path = null;
        while (true) {
            if ((obj = this.context_map.get(id)) == null) {
                command_id = id;
                rc = (IRunControl)this.channel.getRemoteService(IRunControl.class);
                if (rc == null) {
                    cache.set(null, (Throwable)new Exception("Target does not provide Run Control service"), null);
                    return true;
                }
                cache.start(rc.getContext(command_id, new IRunControl.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IRunControl.RunControlContext context) {
                        if (error == null && context == null) {
                            error = new Exception("Invalid context ID");
                        }
                        TCFModel.this.context_map.put(command_id, error != null ? error : context);
                        cache.done(token);
                    }
                }));
                return false;
            }
            if (obj instanceof Throwable) {
                cache.set(null, (Throwable)obj, null);
                return true;
            }
            ctx = (IRunControl.RunControlContext)obj;
            if (path == null) {
                path = new LinkedList<IRunControl.RunControlContext>();
            }
            path.add(ctx);
            parent_id = ctx.getParentID();
            v0 /* !! */  = parent = parent_id == null ? this.launch_node : this.getNode(parent_id);
            if (parent != null) ** GOTO lbl35
            id = parent_id;
        }
lbl-1000:
        // 1 sources

        {
            ctx = (IRunControl.RunControlContext)path.removeLast();
            n = new TCFNodeExecContext(parent, ctx.getID());
            if (parent instanceof TCFNodeLaunch) {
                ((TCFNodeLaunch)parent).getChildren().add(n);
            } else {
                ((TCFNodeExecContext)parent).getChildren().add(n);
            }
            n.setRunContext(ctx);
            parent = n;
lbl35:
            // 2 sources

            ** while (path.size() > 0)
        }
lbl36:
        // 1 sources

        return true;
    }

    public void update(IChildrenCountUpdate[] updates) {
        int i = 0;
        while (i < updates.length) {
            Object o = updates[i].getElement();
            if (o instanceof TCFLaunch) {
                if (this.launch_node != null) {
                    this.launch_node.update(updates[i]);
                } else {
                    updates[i].setChildCount(0);
                    updates[i].done();
                }
            } else {
                ((TCFNode)o).update(updates[i]);
            }
            ++i;
        }
    }

    public void update(IChildrenUpdate[] updates) {
        int i = 0;
        while (i < updates.length) {
            Object o = updates[i].getElement();
            if (o instanceof TCFLaunch) {
                if (this.launch_node != null) {
                    this.launch_node.update(updates[i]);
                } else {
                    updates[i].done();
                }
            } else {
                ((TCFNode)o).update(updates[i]);
            }
            ++i;
        }
    }

    public void update(IHasChildrenUpdate[] updates) {
        int i = 0;
        while (i < updates.length) {
            Object o = updates[i].getElement();
            if (o instanceof TCFLaunch) {
                if (this.launch_node != null) {
                    this.launch_node.update(updates[i]);
                } else {
                    updates[i].setHasChilren(false);
                    updates[i].done();
                }
            } else {
                ((TCFNode)o).update(updates[i]);
            }
            ++i;
        }
    }

    public void update(ILabelUpdate[] updates) {
        int i = 0;
        while (i < updates.length) {
            Object o = updates[i].getElement();
            assert (!(o instanceof TCFLaunch));
            ((TCFNode)o).update(updates[i]);
            ++i;
        }
    }

    public void update(IViewerInputUpdate update) {
        IViewerInputProvider p;
        if ("org.eclipse.debug.ui.BreakpointView".equals(update.getPresentationContext().getId()) && (p = (IViewerInputProvider)this.launch.getAdapter(IViewerInputProvider.class)) != null) {
            p.update(update);
            return;
        }
        Object o = update.getElement();
        if (o instanceof TCFLaunch) {
            update.setInputElement(o);
            update.done();
        } else {
            ((TCFNode)o).update(update);
        }
    }

    public IModelProxy createModelProxy(Object element, IPresentationContext context) {
        return new TCFModelProxy(this);
    }

    public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
        String id = this.getColumnPresentationId(context, element);
        if (id == null) {
            return null;
        }
        if (id.equals("Registers")) {
            return new TCFColumnPresentationRegister();
        }
        if (id.equals("Expressions")) {
            return new TCFColumnPresentationExpression();
        }
        if (id.equals("Modules")) {
            return new TCFColumnPresentationModules();
        }
        return null;
    }

    public String getColumnPresentationId(IPresentationContext context, Object element) {
        if ("org.eclipse.debug.ui.RegisterView".equals(context.getId())) {
            return "Registers";
        }
        if ("org.eclipse.debug.ui.VariableView".equals(context.getId())) {
            return "Expressions";
        }
        if ("org.eclipse.debug.ui.ExpressionView".equals(context.getId())) {
            return "Expressions";
        }
        if (ID_EXPRESSION_HOVER.equals(context.getId())) {
            return "Expressions";
        }
        if ("org.eclipse.debug.ui.ModuleView".equals(context.getId())) {
            return "Modules";
        }
        return null;
    }

    public void setDebugViewSelection(TCFNode node, String reason) {
        assert (Protocol.isDispatchThread());
        if (node == null) {
            return;
        }
        if (node.isDisposed()) {
            return;
        }
        this.runSuspendTrigger(node);
        if (reason == null) {
            return;
        }
        if (reason.equals("Suspended")) {
            return;
        }
        for (TCFModelProxy proxy : this.model_proxies.values()) {
            if (!proxy.getPresentationContext().getId().equals("org.eclipse.debug.ui.DebugView")) continue;
            proxy.setSelection(node);
            if (reason.equals("Step") || reason.equals("Container")) continue;
            proxy.expand(node);
        }
    }

    public void displaySource(Object model_element, final IWorkbenchPage page, boolean forceSourceLookup) {
        ISelection context;
        final int cnt = ++display_source_generation;
        if (page != null && (context = DebugUITools.getDebugContextManager().getContextService(page.getWorkbenchWindow()).getActiveContext()) instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)context;
            model_element = selection.isEmpty() ? null : selection.getFirstElement();
        }
        final Object element = model_element;
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                if (cnt != display_source_generation) {
                    return;
                }
                TCFNodeStackFrame stack_frame = null;
                if (!TCFModel.this.disposed && TCFModel.this.channel.getState() == 1) {
                    if (element instanceof TCFNodeExecContext) {
                        TCFNodeExecContext exec_ctx = (TCFNodeExecContext)element;
                        if (!exec_ctx.isDisposed() && TCFModel.this.active_actions.get(exec_ctx.id) == null) {
                            TCFContextState state_data;
                            TCFDataCache<TCFContextState> state_cache = exec_ctx.getState();
                            if (!state_cache.validate((Runnable)this)) {
                                return;
                            }
                            if (!exec_ctx.isNotActive() && (state_data = (TCFContextState)state_cache.getData()) != null && state_data.is_suspended) {
                                TCFChildrenStackTrace stack_trace = exec_ctx.getStackTrace();
                                if (!stack_trace.validate(this)) {
                                    return;
                                }
                                stack_frame = stack_trace.getTopFrame();
                            }
                        }
                    } else if (element instanceof TCFNodeStackFrame) {
                        TCFNodeStackFrame f = (TCFNodeStackFrame)element;
                        TCFNodeExecContext exec_ctx = (TCFNodeExecContext)f.parent;
                        if (!f.isDisposed() && !exec_ctx.isDisposed() && TCFModel.this.active_actions.get(exec_ctx.id) == null) {
                            TCFContextState state_data;
                            TCFDataCache<TCFContextState> state_cache = exec_ctx.getState();
                            if (!state_cache.validate((Runnable)this)) {
                                return;
                            }
                            if (!exec_ctx.isNotActive() && (state_data = (TCFContextState)state_cache.getData()) != null && state_data.is_suspended) {
                                stack_frame = f;
                            }
                        }
                    }
                }
                String ctx_id = null;
                boolean top_frame = false;
                ILineNumbers.CodeArea area = null;
                if (stack_frame != null) {
                    TCFDataCache<TCFSourceRef> line_info = stack_frame.getLineInfo();
                    if (!line_info.validate((Runnable)this)) {
                        return;
                    }
                    Throwable error = line_info.getError();
                    TCFSourceRef src_ref = (TCFSourceRef)line_info.getData();
                    if (error == null && src_ref != null) {
                        error = src_ref.error;
                    }
                    if (error != null) {
                        Activator.log("Error retrieving source mapping for a stack frame", error);
                    }
                    if (src_ref != null) {
                        area = src_ref.area;
                    }
                    top_frame = stack_frame.getFrameNo() == 0;
                    ctx_id = stack_frame.parent.id;
                }
                TCFModel.this.displaySource(cnt, page, element, ctx_id, top_frame, area);
            }
        });
    }

    private void displaySource(final int cnt, final IWorkbenchPage page, final Object element, final String exe_id, final boolean top_frame, final ILineNumbers.CodeArea area) {
        final boolean disassembly_available = this.channel.getRemoteService(IDisassembly.class) != null;
        this.display.asyncExec(new Runnable(){

            public void run() {
                String filename;
                if (cnt != display_source_generation) {
                    return;
                }
                String editor_id = null;
                DisassemblyEditorInput editor_input = null;
                int line = 0;
                if (area != null) {
                    ISourceLocator locator = TCFModel.this.getLaunch().getSourceLocator();
                    Object source_element = null;
                    if (locator instanceof TCFSourceLookupDirector) {
                        source_element = ((TCFSourceLookupDirector)locator).getSourceElement((Object)area);
                    } else if (locator instanceof ISourceLookupDirector && (filename = TCFSourceLookupParticipant.toFileName((ILineNumbers.CodeArea)area)) != null && (source_element = ((ISourceLookupDirector)locator).getSourceElement((Object)filename)) == null && !filename.equals(area.file)) {
                        source_element = ((ISourceLookupDirector)locator).getSourceElement((Object)area.file);
                    }
                    if (source_element != null) {
                        TCFModelPresentation presentation = TCFModelPresentation.getDefault();
                        if (presentation != null) {
                            editor_input = presentation.getEditorInput(source_element);
                        }
                        if (editor_input != null) {
                            editor_id = presentation.getEditorId(editor_input, source_element);
                        }
                        line = area.start_line;
                    }
                }
                if (!(area == null || TCFModel.this.instruction_stepping_enabled || editor_input != null && editor_id != null)) {
                    ILaunchConfiguration cfg = TCFModel.this.launch.getLaunchConfiguration();
                    ISourceNotFoundPresentation presentation = (ISourceNotFoundPresentation)DebugPlugin.getAdapter((Object)element, ISourceNotFoundPresentation.class);
                    if (presentation != null) {
                        filename = TCFSourceLookupParticipant.toFileName((ILineNumbers.CodeArea)area);
                        editor_input = presentation.getEditorInput(element, cfg, filename);
                        editor_id = presentation.getEditorId(editor_input, element);
                    }
                    if (editor_id == null || editor_input == null) {
                        editor_id = "org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditor";
                        editor_input = (IEditorInput)editor_not_found.get(cfg);
                        if (editor_input == null) {
                            editor_input = new CommonSourceNotFoundEditorInput((Object)cfg);
                            editor_not_found.put(cfg, editor_input);
                        }
                    }
                }
                if (exe_id != null && disassembly_available && (editor_input == null || editor_id == null || TCFModel.this.instruction_stepping_enabled) && PlatformUI.getWorkbench().getEditorRegistry().findEditor("org.eclipse.cdt.dsf.ui.disassembly") != null) {
                    editor_id = "org.eclipse.cdt.dsf.ui.disassembly";
                    editor_input = DisassemblyEditorInput.INSTANCE;
                }
                if (cnt != display_source_generation) {
                    return;
                }
                ITextEditor text_editor = null;
                if (page != null && editor_input != null && editor_id != null) {
                    IEditorPart editor = TCFModel.this.openEditor(editor_input, editor_id, page);
                    text_editor = editor instanceof ITextEditor ? (ITextEditor)editor : (ITextEditor)editor.getAdapter(ITextEditor.class);
                }
                IRegion region = null;
                if (text_editor != null && (region = TCFModel.this.getLineInformation(text_editor, line)) != null) {
                    text_editor.selectAndReveal(region.getOffset(), 0);
                }
                TCFModel.this.annotation_manager.addStackFrameAnnotation(TCFModel.this, exe_id, top_frame, page, text_editor, region);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAnnotation(String id) {
        HashSet<String> hashSet = this.removed_annotations;
        synchronized (hashSet) {
            this.removed_annotations.add(id);
            if (!this.removed_annotations_posted) {
                this.display.asyncExec(this.removed_annotations_runnable);
                this.removed_annotations_posted = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshLaunchView() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.display.isDisposed()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.display.asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                    if (windows == null) {
                        return;
                    }
                    IWorkbenchWindow[] iWorkbenchWindowArray = windows;
                    int n = windows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                        IDebugView view = (IDebugView)window.getActivePage().findView("org.eclipse.debug.ui.DebugView");
                        if (view != null) {
                            ((StructuredViewer)view.getViewer()).refresh((Object)TCFModel.this.launch);
                        }
                        ++n2;
                    }
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void showMessageBox(final String title, final Throwable error) {
        this.display.asyncExec(new Runnable(){

            public void run() {
                Shell shell = TCFModel.this.display.getActiveShell();
                if (shell == null) {
                    Shell s;
                    Shell[] shells = TCFModel.this.display.getShells();
                    HashSet<Shell> set = new HashSet<Shell>();
                    Shell[] shellArray = shells;
                    int n = shells.length;
                    int n2 = 0;
                    while (n2 < n) {
                        s = shellArray[n2];
                        set.add(s);
                        ++n2;
                    }
                    shellArray = shells;
                    n = shells.length;
                    n2 = 0;
                    while (n2 < n) {
                        s = shellArray[n2];
                        if (s.getParent() != null) {
                            set.remove(s.getParent().getShell());
                        }
                        ++n2;
                    }
                    shellArray = shells;
                    n = shells.length;
                    n2 = 0;
                    while (n2 < n) {
                        shell = s = shellArray[n2];
                        ++n2;
                    }
                }
                MessageBox mb = new MessageBox(shell, 33);
                mb.setText(title);
                mb.setMessage(TCFModel.getErrorMessage(error, true));
                mb.open();
            }
        });
    }

    public static String getErrorMessage(Throwable error, boolean multiline) {
        StringBuffer buf = new StringBuffer();
        while (error != null) {
            String msg = null;
            msg = !multiline && error instanceof IErrorReport ? Command.toErrorString((Object)((IErrorReport)error).getAttributes()) : error.getLocalizedMessage();
            if (msg == null || msg.length() == 0) {
                msg = error.getClass().getName();
            }
            buf.append(msg);
            error = error.getCause();
            if (error == null) continue;
            char ch = buf.charAt(buf.length() - 1);
            if (multiline && ch != '\n') {
                buf.append('\n');
            } else if (ch != '.' && ch != ';') {
                buf.append(';');
            }
            buf.append("Caused by:");
            buf.append(multiline ? (char)'\n' : ' ');
        }
        if (buf.length() > 0) {
            char ch = buf.charAt(buf.length() - 1);
            if (multiline && ch != '\n') {
                buf.append('\n');
            }
        }
        return buf.toString();
    }

    private IEditorPart openEditor(final IEditorInput input, final String id, final IWorkbenchPage page) {
        final IEditorPart[] editor = new IEditorPart[1];
        Runnable r = new Runnable(){

            public void run() {
                if (!page.getWorkbenchWindow().getWorkbench().isClosing()) {
                    try {
                        editor[0] = page.openEditor(input, id, false, 3);
                    }
                    catch (PartInitException e) {
                        Activator.log("Cannot open editor", e);
                    }
                }
            }
        };
        BusyIndicator.showWhile((Display)this.display, (Runnable)r);
        return editor[0];
    }

    private IRegion getLineInformation(ITextEditor editor, int lineNumber) {
        IDocumentProvider provider = editor.getDocumentProvider();
        IEditorInput input = editor.getEditorInput();
        try {
            provider.connect((Object)input);
        }
        catch (CoreException coreException) {
            return null;
        }
        try {
            IDocument document = provider.getDocument((Object)input);
            if (document != null) {
                IRegion iRegion = document.getLineInformation(lineNumber - 1);
                return iRegion;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            provider.disconnect((Object)input);
        }
        return null;
    }

    public synchronized void addSuspendTriggerListener(ISuspendTriggerListener listener) {
        this.suspend_trigger_listeners.add(listener);
    }

    public synchronized void removeSuspendTriggerListener(ISuspendTriggerListener listener) {
        this.suspend_trigger_listeners.remove(listener);
    }

    private synchronized void runSuspendTrigger(final TCFNode node) {
        final int generation = ++this.suspend_trigger_generation;
        final ISuspendTriggerListener[] listeners = this.suspend_trigger_listeners.toArray(new ISuspendTriggerListener[this.suspend_trigger_listeners.size()]);
        if (listeners.length == 0) {
            return;
        }
        this.display.asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                TCFModel tCFModel = TCFModel.this;
                synchronized (tCFModel) {
                    if (generation != TCFModel.this.suspend_trigger_generation) {
                        return;
                    }
                }
                ISuspendTriggerListener[] iSuspendTriggerListenerArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    ISuspendTriggerListener listener = iSuspendTriggerListenerArray[n2];
                    try {
                        listener.suspended((ILaunch)TCFModel.this.launch, (Object)node);
                    }
                    catch (Throwable x) {
                        Activator.log(x);
                    }
                    ++n2;
                }
            }
        });
    }

    public void setInstructionSteppingEnabled(boolean enabled) {
        this.instruction_stepping_enabled = enabled;
    }

    public boolean isInstructionSteppingEnabled() {
        return this.instruction_stepping_enabled;
    }

    public static class DisassemblyEditorInput
    implements IEditorInput {
        static final String EDITOR_ID = "org.eclipse.cdt.dsf.ui.disassembly";
        static final DisassemblyEditorInput INSTANCE = new DisassemblyEditorInput();

        public Object getAdapter(Class adapter) {
            return null;
        }

        public boolean exists() {
            return false;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return "Disassembly";
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return "Disassembly";
        }
    }
}

