/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.lrparser.tests;

import junit.framework.TestSuite;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.lrparser.gnu.GCCLanguage;
import org.eclipse.cdt.core.dom.lrparser.gnu.GPPLanguage;
import org.eclipse.cdt.core.lrparser.tests.LRCompletionParseTest;
import org.eclipse.cdt.core.lrparser.tests.ParseHelper;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.tests.prefix.BasicCompletionTest;
import org.eclipse.cdt.internal.core.parser.ParserException;

public class LRCompletionBasicTest
extends BasicCompletionTest {
    public static TestSuite suite() {
        return new TestSuite(LRCompletionBasicTest.class);
    }

    public void testCompletionInSizeof340664() throws Exception {
    }

    public void testBug279931() throws Exception {
    }

    public void testBug279931a() throws Exception {
    }

    public void testQualifiedMemberAccess_Bug300139() throws Exception {
    }

    public void testCastExpression_Bug301933() throws Exception {
    }

    public void testConditionalOperator_Bug308611() throws Exception {
    }

    protected IASTCompletionNode getCompletionNode(String code, ParserLanguage lang, boolean useGNUExtensions) throws ParserException {
        ILanguage language = lang.isCPP() ? this.getCPPLanguage() : this.getCLanguage();
        return ParseHelper.getCompletionNode(code, language);
    }

    protected ILanguage getCLanguage() {
        return GCCLanguage.getDefault();
    }

    protected ILanguage getCPPLanguage() {
        return GPPLanguage.getDefault();
    }

    public void testFunction() throws Exception {
        String code = "void func(int x) { }void func2() { fu";
        IASTCompletionNode node = this.getGPPCompletionNode(code);
        IBinding[] bindings = LRCompletionParseTest.getBindings(node.getNames());
        LRCompletionBasicTest.assertEquals((int)2, (int)bindings.length);
        LRCompletionBasicTest.assertEquals((String)"func", (String)((IFunction)bindings[0]).getName());
        LRCompletionBasicTest.assertEquals((String)"func2", (String)((IFunction)bindings[1]).getName());
        node = this.getGCCCompletionNode(code);
        bindings = LRCompletionParseTest.getBindings(node.getNames());
        LRCompletionBasicTest.assertEquals((int)2, (int)bindings.length);
        LRCompletionBasicTest.assertEquals((String)"func", (String)((IFunction)bindings[0]).getName());
        LRCompletionBasicTest.assertEquals((String)"func2", (String)((IFunction)bindings[1]).getName());
    }

    public void testTypedef() throws Exception {
        String code = "typedef int blah;bl";
        IASTCompletionNode node = this.getGPPCompletionNode(code);
        IBinding[] bindings = LRCompletionParseTest.getBindings(node.getNames());
        LRCompletionBasicTest.assertEquals((int)1, (int)bindings.length);
        LRCompletionBasicTest.assertEquals((String)"blah", (String)((ITypedef)bindings[0]).getName());
        node = this.getGCCCompletionNode(code);
        bindings = LRCompletionParseTest.getBindings(node.getNames());
        LRCompletionBasicTest.assertEquals((int)1, (int)bindings.length);
        LRCompletionBasicTest.assertEquals((String)"blah", (String)((ITypedef)bindings[0]).getName());
    }
}

