/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.lrparser.tests;

import junit.framework.TestSuite;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.c.ICASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.lrparser.gnu.GCCLanguage;
import org.eclipse.cdt.core.dom.lrparser.gnu.GPPLanguage;
import org.eclipse.cdt.core.lrparser.tests.ParseHelper;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.tests.ast2.AST2Tests;
import org.eclipse.cdt.internal.core.parser.ParserException;

public class LRTests
extends AST2Tests {
    public static TestSuite suite() {
        return LRTests.suite(LRTests.class);
    }

    public LRTests(String name) {
        super(name);
    }

    public void testFnReturningPtrToFn() throws Exception {
    }

    public void testBug270275_int_is_equivalent_to_signed_int() throws Exception {
    }

    public void testFunctionDefTypes() throws Exception {
    }

    public void testBug80171() throws Exception {
    }

    public void testBug192165() throws Exception {
    }

    public void testTypenameInExpression() throws Exception {
    }

    public void testParamWithFunctionType_Bug84242() throws Exception {
    }

    public void testParamWithFunctionTypeCpp_Bug84242() throws Exception {
    }

    public void testFunctionReturningPtrToArray_Bug216609() throws Exception {
    }

    public void testNestedFunctionDeclarators() throws Exception {
    }

    public void testConstantExpressionBinding() throws Exception {
    }

    public void testAmbiguousDeclaration_Bug259373() throws Exception {
    }

    public void testSizeofFunctionType_252243() throws Exception {
    }

    public void testSkipAggregateInitializer_297550() throws Exception {
    }

    public void testDeepElseif_298455() throws Exception {
    }

    public void testAttributeSyntax_298841() throws Exception {
    }

    public void testEmptyTrailingMacro_303152() throws Exception {
    }

    public void testLargeTrivialAggregateInitializer_Bug253690() throws Exception {
    }

    protected IASTTranslationUnit parse(String code, ParserLanguage lang, boolean useGNUExtensions, boolean expectNoProblems) throws ParserException {
        return this.parse(code, lang, useGNUExtensions, expectNoProblems, false);
    }

    protected IASTTranslationUnit parse(String code, ParserLanguage lang, boolean useGNUExtensions, boolean expectNoProblems, boolean skipTrivialInitializers) throws ParserException {
        ILanguage language = lang.isCPP() ? this.getCPPLanguage() : this.getCLanguage();
        ParseHelper.Options options = new ParseHelper.Options();
        options.setCheckSyntaxProblems(expectNoProblems);
        options.setCheckPreprocessorProblems(expectNoProblems);
        options.setSkipTrivialInitializers(skipTrivialInitializers);
        return ParseHelper.parse(code, language, options);
    }

    protected ILanguage getCLanguage() {
        return GCCLanguage.getDefault();
    }

    protected ILanguage getCPPLanguage() {
        return GPPLanguage.getDefault();
    }

    public void testMultipleHashHash() throws Exception {
        String code = "#define TWICE(a)  int a##tera; int a##ther; \n TWICE(pan)";
        this.parseAndCheckBindings(code, ParserLanguage.C);
    }

    public void testBug191279() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(" /**/ \n");
        sb.append("# define YO 99 /**/ \n");
        sb.append("# undef YO /**/ ");
        sb.append(" /* $ */ ");
        String code = sb.toString();
        this.parseAndCheckBindings(code, ParserLanguage.C);
    }

    public void testBug191324() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("int x$y = 99; \n");
        sb.append("int $q = 100; \n");
        sb.append("#ifndef SS$_INVFILFOROP \n");
        sb.append("int z; \n");
        sb.append("#endif \n");
        String code = sb.toString();
        this.parseAndCheckBindings(code, ParserLanguage.C);
    }

    public void testBug192009_implicitInt() throws Exception {
        String code = "main() { int x; }";
        IASTTranslationUnit tu = this.parse(code, ParserLanguage.C, false, true);
        IASTDeclaration[] declarations = tu.getDeclarations();
        LRTests.assertEquals((int)1, (int)declarations.length);
        IASTFunctionDefinition main = (IASTFunctionDefinition)declarations[0];
        ICASTSimpleDeclSpecifier declSpec = (ICASTSimpleDeclSpecifier)main.getDeclSpecifier();
        LRTests.assertEquals((int)0, (int)declSpec.getType());
        LRTests.assertEquals((String)"main", (String)main.getDeclarator().getName().toString());
    }

    public void testBug196468_emptyArrayInitializer() {
    }

    public void _testBug196468_emptyArrayInitializer() throws Exception {
        super.testBug196468_emptyArrayInitializer();
    }

    public void testScalabilityOfLargeTrivialInitializer_Bug253690() {
    }

    public void _testScalabilityOfLargeTrivialInitializer_Bug253690() throws Exception {
        super.testScalabilityOfLargeTrivialInitializer_Bug253690();
    }

    public void testBinaryVsCastAmbiguities_Bug237057() {
    }

    public void _testBinaryVsCastAmbiguities_Bug237057() throws Exception {
        super.testBinaryVsCastAmbiguities_Bug237057();
    }

    public void testCastVsFunctionCallAmbiguities_Bug237057() {
    }

    public void _testCastVsFunctionCallAmbiguities_Bug237057() throws Exception {
        super.testCastVsFunctionCallAmbiguities_Bug237057();
    }

    public void testCaseRange_Bug211882() {
    }

    public void _testCaseRange_Bug211882() throws Exception {
        super.testCaseRange_Bug211882();
    }
}

