/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CVQualifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.FunctionSetType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.InitializerListType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateArgumentDeduction {
    private CPPTemplateParameterMap fExplicitArgs;
    private CPPTemplateParameterMap fDeducedArgs;
    private Set<Integer> fTemplateParameterPacks;
    private int fPackOffset;
    private final int fPackSize;

    static ICPPTemplateArgument[] deduceForFunctionCall(ICPPFunctionTemplate template, ICPPTemplateArgument[] tmplArgs, List<IType> fnArgs, List<IASTExpression.ValueCategory> argIsLValue, CPPTemplateParameterMap map) throws DOMException {
        ICPPTemplateParameter[] tmplParams = template.getTemplateParameters();
        int numTmplParams = tmplParams.length;
        int numTmplArgs = tmplArgs.length;
        tmplArgs = SemanticUtil.getSimplifiedArguments(tmplArgs);
        ICPPTemplateParameter tmplParam = null;
        int packOffset = -1;
        int i = 0;
        while (i < numTmplArgs) {
            if (packOffset < 0 || tmplParam == null) {
                if (i >= numTmplParams) {
                    return null;
                }
                tmplParam = tmplParams[i];
                if (tmplParam.isParameterPack()) {
                    packOffset = i;
                }
            }
            ICPPTemplateArgument tmplArg = tmplArgs[i];
            if ((tmplArg = CPPTemplates.matchTemplateParameterAndArgument(tmplParam, tmplArg, map)) == null) {
                return null;
            }
            if (packOffset < 0) {
                map.put(tmplParam, tmplArg);
            }
            ++i;
        }
        if (packOffset >= 0) {
            int packSize = tmplArgs.length - packOffset;
            ICPPTemplateArgument[] pack = new ICPPTemplateArgument[packSize];
            System.arraycopy(tmplArgs, packOffset, pack, 0, packSize);
            map.put(tmplParam, pack);
        }
        if (!TemplateArgumentDeduction.deduceFromFunctionArgs(template, fnArgs, argIsLValue, map)) {
            return null;
        }
        ArrayList<ICPPTemplateArgument> result = new ArrayList<ICPPTemplateArgument>(numTmplParams);
        ICPPTemplateParameter[] iCPPTemplateParameterArray = tmplParams;
        int n = tmplParams.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateParameter tpar = iCPPTemplateParameterArray[n2];
            if (tpar.isParameterPack()) {
                ICPPTemplateArgument[] deducedArgs = map.getPackExpansion(tpar);
                if (deducedArgs == null) {
                    return null;
                }
                result.addAll(Arrays.asList(deducedArgs));
            } else {
                ICPPTemplateArgument deducedArg = map.getArgument(tpar);
                if (deducedArg == null && (deducedArg = tpar.getDefaultValue()) == null) {
                    return null;
                }
                result.add(deducedArg);
            }
            ++n2;
        }
        return result.toArray(new ICPPTemplateArgument[result.size()]);
    }

    static ICPPTemplateArgument[] deduceForAddressOf(ICPPFunctionTemplate template, ICPPTemplateArgument[] tmplArgs, IFunctionType arg, CPPTemplateParameterMap map) throws DOMException {
        ICPPTemplateParameter[] tmplParams = template.getTemplateParameters();
        int numTmplParams = tmplParams.length;
        int numTmplArgs = tmplArgs.length;
        tmplArgs = SemanticUtil.getSimplifiedArguments(tmplArgs);
        ICPPTemplateParameter tmplParam = null;
        int packOffset = -1;
        int i = 0;
        while (i < numTmplArgs) {
            if (packOffset < 0 || tmplParam == null) {
                if (i >= numTmplParams) {
                    return null;
                }
                tmplParam = tmplParams[i];
                if (tmplParam.isParameterPack()) {
                    packOffset = i;
                }
            }
            ICPPTemplateArgument tmplArg = tmplArgs[i];
            if ((tmplArg = CPPTemplates.matchTemplateParameterAndArgument(tmplParam, tmplArg, map)) == null) {
                return null;
            }
            if (packOffset < 0) {
                map.put(tmplParam, tmplArg);
            }
            ++i;
        }
        if (packOffset >= 0) {
            int packSize = tmplArgs.length - packOffset;
            ICPPTemplateArgument[] pack = new ICPPTemplateArgument[packSize];
            System.arraycopy(tmplArgs, packOffset, pack, 0, packSize);
            map.put(tmplParam, pack);
        }
        IType par = template.getType();
        if (!CPPTemplates.isValidType(par = CPPTemplates.instantiateType(par, map, -1, null))) {
            return null;
        }
        boolean isDependentPar = CPPTemplates.isDependentType(par);
        if (isDependentPar) {
            TemplateArgumentDeduction deduct = new TemplateArgumentDeduction(tmplParams, map, new CPPTemplateParameterMap(tmplParams.length), 0);
            par = SemanticUtil.getNestedType(par, 1);
            if (arg != null && !deduct.fromType(par, arg, false)) {
                return null;
            }
            if (!map.mergeToExplicit(deduct.fDeducedArgs)) {
                return null;
            }
        }
        if (!TemplateArgumentDeduction.verifyDeduction(tmplParams, map, true)) {
            return null;
        }
        if (isDependentPar) {
            par = CPPTemplates.instantiateType(par, map, -1, null);
        }
        if (arg == null || arg.isSameType(par)) {
            ArrayList<ICPPTemplateArgument> result = new ArrayList<ICPPTemplateArgument>(numTmplParams);
            ICPPTemplateParameter[] iCPPTemplateParameterArray = tmplParams;
            int n = tmplParams.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPTemplateParameter tpar = iCPPTemplateParameterArray[n2];
                if (tpar.isParameterPack()) {
                    ICPPTemplateArgument[] deducedArgs = map.getPackExpansion(tpar);
                    if (deducedArgs == null) {
                        return null;
                    }
                    result.addAll(Arrays.asList(deducedArgs));
                } else {
                    ICPPTemplateArgument deducedArg = map.getArgument(tpar);
                    if (deducedArg == null && (deducedArg = tpar.getDefaultValue()) == null) {
                        return null;
                    }
                    result.add(deducedArg);
                }
                ++n2;
            }
            return result.toArray(new ICPPTemplateArgument[result.size()]);
        }
        return null;
    }

    static ICPPTemplateArgument[] deduceForConversion(ICPPFunctionTemplate template, IType conversionType, CPPTemplateParameterMap map) throws DOMException {
        ICPPTemplateParameter[] tmplParams = template.getTemplateParameters();
        int length = tmplParams.length;
        ICPPTemplateArgument[] result = new ICPPTemplateArgument[length];
        IType a = SemanticUtil.getSimplifiedType(conversionType);
        IType p = template.getType().getReturnType();
        TemplateArgumentDeduction deduct = new TemplateArgumentDeduction(tmplParams, null, map, 0);
        if (!deduct.fromType(p = TemplateArgumentDeduction.getArgumentTypeForDeduction(p, a instanceof ICPPReferenceType), a = SemanticUtil.getNestedType(a, 3), false)) {
            return null;
        }
        int i = 0;
        while (i < length) {
            if (result[i] == null) {
                ICPPTemplateParameter tpar = tmplParams[i];
                ICPPTemplateArgument deducedArg = map.getArgument(tpar);
                if (deducedArg == null && (deducedArg = tpar.getDefaultValue()) == null) {
                    return null;
                }
                result[i] = deducedArg;
            }
            ++i;
        }
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static boolean deduceFromFunctionArgs(ICPPFunctionTemplate template, List<IType> fnArgs, List<IASTExpression.ValueCategory> argCats, CPPTemplateParameterMap map) {
        try {
            IType[] fnPars = template.getType().getParameterTypes();
            int fnParCount = fnPars.length;
            if (fnParCount == 0) {
                return true;
            }
            ICPPTemplateParameter[] tmplPars = template.getTemplateParameters();
            TemplateArgumentDeduction deduct = new TemplateArgumentDeduction(tmplPars, map, new CPPTemplateParameterMap(fnParCount), 0);
            IType fnParPack = null;
            int j = 0;
            while (j < fnArgs.size()) {
                block25: {
                    IType par;
                    block27: {
                        block26: {
                            if (fnParPack == null) break block26;
                            par = fnParPack;
                            deduct.incPackOffset();
                            break block27;
                        }
                        if (j >= fnParCount) break;
                        par = fnPars[j];
                        if (!(par instanceof ICPPParameterPackType)) break block27;
                        if (j != fnParCount - 1) break block25;
                        par = fnParPack = ((ICPPParameterPackType)par).getType();
                        deduct = new TemplateArgumentDeduction(deduct, fnArgs.size() - j);
                    }
                    par = CPPTemplates.instantiateType(par, map, -1, null);
                    if (!CPPTemplates.isValidType(par)) {
                        return false;
                    }
                    if (CPPTemplates.isDependentType(par)) {
                        IType arg = fnArgs.get(j);
                        par = SemanticUtil.getNestedType(par, 1);
                        if (arg instanceof InitializerListType) {
                            IType inner = Conversions.getInitListType(par = SemanticUtil.getNestedType(par, 7));
                            if (inner != null) {
                                InitializerListType initListType = (InitializerListType)arg;
                                IType[] types = initListType.getExpressionTypes();
                                IASTExpression.ValueCategory[] valueCats = initListType.getValueCategories();
                                int i = 0;
                                while (i < types.length) {
                                    if (!TemplateArgumentDeduction.deduceFromFunctionArg(inner, types[i], valueCats[i], deduct)) {
                                        return false;
                                    }
                                    ++i;
                                }
                            }
                        } else if (arg instanceof FunctionSetType) {
                            ICPPFunction[] fs;
                            ICPPFunction[] iCPPFunctionArray = fs = ((FunctionSetType)arg).getFunctionSet();
                            int valueCats = fs.length;
                            int types = 0;
                            while (types < valueCats) {
                                ICPPFunction f = iCPPFunctionArray[types];
                                if (!(f instanceof ICPPFunctionTemplate)) {
                                    ++types;
                                    continue;
                                }
                                break block25;
                            }
                            CPPTemplateParameterMap success = null;
                            HashSet<String> handled = new HashSet<String>();
                            ICPPFunction[] iCPPFunctionArray2 = fs;
                            int n = fs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ICPPFunction f = iCPPFunctionArray2[n2];
                                arg = f.getType();
                                if (f instanceof ICPPMethod && !f.isStatic()) {
                                    arg = new CPPPointerToMemberType(arg, ((ICPPMethod)f).getClassOwner(), false, false, false);
                                }
                                if (handled.add(ASTTypeUtil.getType(arg, true))) {
                                    CPPTemplateParameterMap state = deduct.saveState();
                                    if (TemplateArgumentDeduction.deduceFromFunctionArg(par, arg, argCats.get(j), deduct)) {
                                        if (success != null) {
                                            deduct.restoreState(state);
                                            break block25;
                                        }
                                        success = deduct.saveState();
                                    }
                                    deduct.restoreState(state);
                                }
                                ++n2;
                            }
                            if (success == null) {
                                return false;
                            }
                            deduct.restoreState(success);
                        } else if (!TemplateArgumentDeduction.deduceFromFunctionArg(par, arg, argCats.get(j), deduct)) {
                            return false;
                        }
                    }
                }
                ++j;
            }
            if (!deduct.fExplicitArgs.mergeToExplicit(deduct.fDeducedArgs)) {
                return false;
            }
            return TemplateArgumentDeduction.verifyDeduction(tmplPars, map, true);
        }
        catch (DOMException dOMException) {
            return false;
        }
    }

    private static boolean deduceFromFunctionArg(IType par, IType arg, IASTExpression.ValueCategory valueCat, TemplateArgumentDeduction deduct) throws DOMException {
        IType pcheck;
        boolean isReferenceTypeParameter = false;
        if (par instanceof ICPPReferenceType) {
            isReferenceTypeParameter = true;
            ICPPReferenceType refPar = (ICPPReferenceType)par;
            arg = refPar.isRValueReference() && refPar.getType() instanceof ICPPTemplateParameter && valueCat == IASTExpression.ValueCategory.LVALUE ? new CPPReferenceType(SemanticUtil.getSimplifiedType(arg), false) : TemplateArgumentDeduction.getArgumentTypeForDeduction(arg, true);
            par = SemanticUtil.getNestedType(par, 3);
        } else {
            arg = TemplateArgumentDeduction.getArgumentTypeForDeduction(arg, false);
        }
        CVQualifier cvPar = SemanticUtil.getCVQualifier(par);
        CVQualifier cvArg = SemanticUtil.getCVQualifier(arg);
        if ((cvPar == cvArg || isReferenceTypeParameter && cvPar.isAtLeastAsQualifiedAs(cvArg)) && !((pcheck = SemanticUtil.getNestedType(par, 4)) instanceof ICPPTemplateParameter)) {
            ICPPClassType aInst;
            ICPPTemplateInstance pInst;
            ICPPClassTemplate pTemplate;
            par = pcheck;
            IType argcheck = arg = SemanticUtil.getNestedType(arg, 4);
            if (par instanceof IPointerType && arg instanceof IPointerType) {
                pcheck = ((IPointerType)par).getType();
                argcheck = ((IPointerType)arg).getType();
                if (pcheck instanceof ICPPTemplateParameter) {
                    pcheck = null;
                } else {
                    cvPar = SemanticUtil.getCVQualifier(pcheck);
                    if (cvPar.isAtLeastAsQualifiedAs(cvArg = SemanticUtil.getCVQualifier(argcheck))) {
                        pcheck = SemanticUtil.getNestedType(pcheck, 4);
                        argcheck = SemanticUtil.getNestedType(argcheck, 4);
                    } else {
                        pcheck = null;
                    }
                }
            }
            if (pcheck instanceof ICPPTemplateInstance && argcheck instanceof ICPPClassType && (pTemplate = TemplateArgumentDeduction.getPrimaryTemplate(pInst = (ICPPTemplateInstance)((Object)pcheck))) != null && (aInst = TemplateArgumentDeduction.findBaseInstance((ICPPClassType)argcheck, pTemplate, 16)) != null && aInst != argcheck) {
                par = pcheck;
                arg = aInst;
            }
        }
        return deduct.fromType(par, arg, true);
    }

    static int deduceForPartialOrdering(ICPPTemplateParameter[] tmplPars, IType[] fnPars, IType[] fnArgs) {
        try {
            int fnParCount = fnPars.length;
            int fnArgCount = fnArgs.length;
            int result = 0;
            TemplateArgumentDeduction deduct = new TemplateArgumentDeduction(tmplPars, new CPPTemplateParameterMap(0), new CPPTemplateParameterMap(fnParCount), 0);
            IType fnParPack = null;
            int j = 0;
            while (j < fnArgCount) {
                block11: {
                    IType par;
                    block10: {
                        block9: {
                            if (fnParPack == null) break block9;
                            par = fnParPack;
                            deduct.incPackOffset();
                            break block10;
                        }
                        if (j >= fnParCount) {
                            return result;
                        }
                        par = fnPars[j];
                        if (!(par instanceof ICPPParameterPackType)) break block10;
                        if (j != fnParCount - 1) break block11;
                        par = fnParPack = ((ICPPParameterPackType)par).getType();
                        deduct = new TemplateArgumentDeduction(deduct, fnArgs.length - j);
                    }
                    IType arg = fnArgs[j];
                    int cmpSpecialized = TemplateArgumentDeduction.deduceForPartialOrdering(par, arg, deduct);
                    if (cmpSpecialized < 0) {
                        return cmpSpecialized;
                    }
                    if (cmpSpecialized > 0) {
                        result = cmpSpecialized;
                    }
                }
                ++j;
            }
            return result;
        }
        catch (DOMException dOMException) {
            return -1;
        }
    }

    private static int deduceForPartialOrdering(IType par, IType arg, TemplateArgumentDeduction deduct) throws DOMException {
        par = SemanticUtil.getNestedType(par, 1);
        arg = SemanticUtil.getNestedType(arg, 1);
        boolean isMoreCVQualified = false;
        if (par instanceof ICPPReferenceType && arg instanceof ICPPReferenceType) {
            par = SemanticUtil.getNestedType(par, 3);
            arg = SemanticUtil.getNestedType(arg, 3);
            CVQualifier cvp = SemanticUtil.getCVQualifier(par);
            CVQualifier cva = SemanticUtil.getCVQualifier(arg);
            isMoreCVQualified = cva.isMoreQualifiedThan(cvp);
        }
        if (!deduct.fromType(par = SemanticUtil.getNestedType(par, 11), arg = SemanticUtil.getNestedType(arg, 11), false)) {
            return -1;
        }
        return isMoreCVQualified ? 1 : 0;
    }

    private static ICPPClassType findBaseInstance(ICPPClassType a, ICPPClassTemplate pTemplate, int maxdepth) throws DOMException {
        ICPPTemplateInstance inst;
        ICPPClassTemplate tmpl;
        if (a instanceof ICPPTemplateInstance && pTemplate.isSameType(tmpl = TemplateArgumentDeduction.getPrimaryTemplate(inst = (ICPPTemplateInstance)((Object)a)))) {
            return a;
        }
        if (maxdepth-- > 0) {
            ICPPBase[] iCPPBaseArray = a.getBases();
            int n = iCPPBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPClassType inst2;
                ICPPBase cppBase = iCPPBaseArray[n2];
                IBinding base = cppBase.getBaseClass();
                if (base instanceof ICPPClassType && (inst2 = TemplateArgumentDeduction.findBaseInstance((ICPPClassType)base, pTemplate, maxdepth)) != null) {
                    return inst2;
                }
                ++n2;
            }
        }
        return null;
    }

    private static ICPPClassTemplate getPrimaryTemplate(ICPPTemplateInstance inst) throws DOMException {
        ICPPTemplateDefinition template = inst.getTemplateDefinition();
        if (template instanceof ICPPClassTemplatePartialSpecialization) {
            return ((ICPPClassTemplatePartialSpecialization)template).getPrimaryClassTemplate();
        }
        if (template instanceof ICPPClassTemplate) {
            return (ICPPClassTemplate)template;
        }
        return null;
    }

    private static IType getArgumentTypeForDeduction(IType type, boolean parameterIsAReferenceType) {
        if ((type = SemanticUtil.getSimplifiedType(type)) instanceof ICPPReferenceType) {
            type = ((ICPPReferenceType)type).getType();
        }
        IType result = type;
        if (!parameterIsAReferenceType) {
            result = type instanceof IArrayType ? new CPPPointerType(((IArrayType)type).getType()) : (type instanceof IFunctionType ? new CPPPointerType(type) : SemanticUtil.getNestedType(type, 9));
        }
        return result;
    }

    public static boolean fromTemplateArguments(ICPPTemplateParameter[] pars, ICPPTemplateArgument[] p, ICPPTemplateArgument[] a, CPPTemplateParameterMap map) throws DOMException {
        TemplateArgumentDeduction deduct = new TemplateArgumentDeduction(pars, null, map, 0);
        int len = a.length;
        if (p == null || p.length != len) {
            return false;
        }
        int j = 0;
        while (j < len) {
            if (!deduct.fromTemplateArgument(p[j], a[j])) {
                return false;
            }
            ++j;
        }
        return TemplateArgumentDeduction.verifyDeduction(pars, map, false);
    }

    private static boolean verifyDeduction(ICPPTemplateParameter[] pars, CPPTemplateParameterMap tpMap, boolean useDefaults) {
        ICPPTemplateParameter[] iCPPTemplateParameterArray = pars;
        int n = pars.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateParameter tpar = iCPPTemplateParameterArray[n2];
            if (tpar.isParameterPack()) {
                ICPPTemplateArgument[] deducedArgs = tpMap.getPackExpansion(tpar);
                if (deducedArgs == null) {
                    tpMap.put(tpar, ICPPTemplateArgument.EMPTY_ARGUMENTS);
                } else {
                    ICPPTemplateArgument[] iCPPTemplateArgumentArray = deducedArgs;
                    int n3 = deducedArgs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n4];
                        if (arg == null) {
                            return false;
                        }
                        ++n4;
                    }
                }
            } else {
                ICPPTemplateArgument deducedArg = tpMap.getArgument(tpar);
                if (deducedArg == null && useDefaults && (deducedArg = tpar.getDefaultValue()) != null && (deducedArg = CPPTemplates.instantiateArgument(deducedArg, tpMap, -1, null)) != null) {
                    tpMap.put(tpar, deducedArg);
                }
                if (deducedArg == null) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private TemplateArgumentDeduction(ICPPTemplateParameter[] tpars, CPPTemplateParameterMap explicit, CPPTemplateParameterMap result, int packSize) {
        this.fExplicitArgs = explicit;
        this.fDeducedArgs = result;
        this.fPackSize = packSize;
        this.fPackOffset = packSize > 0 ? 0 : -1;
        ICPPTemplateParameter[] iCPPTemplateParameterArray = tpars;
        int n = tpars.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateParameter tpar = iCPPTemplateParameterArray[n2];
            if (tpar.isParameterPack()) {
                if (this.fTemplateParameterPacks == null) {
                    this.fTemplateParameterPacks = new HashSet<Integer>();
                }
                this.fTemplateParameterPacks.add(tpar.getParameterID());
            }
            ++n2;
        }
    }

    private TemplateArgumentDeduction(TemplateArgumentDeduction base, int packSize) {
        this.fExplicitArgs = base.fExplicitArgs;
        this.fDeducedArgs = base.fDeducedArgs;
        this.fTemplateParameterPacks = base.fTemplateParameterPacks;
        this.fPackSize = packSize;
        this.fPackOffset = packSize > 0 ? 0 : -1;
    }

    private CPPTemplateParameterMap saveState() {
        return new CPPTemplateParameterMap(this.fDeducedArgs);
    }

    private void restoreState(CPPTemplateParameterMap saved) {
        this.fDeducedArgs = saved;
    }

    private void incPackOffset() {
        ++this.fPackOffset;
        assert (this.fPackOffset < this.fPackSize);
    }

    private boolean fromTemplateArgument(ICPPTemplateArgument p, ICPPTemplateArgument a) throws DOMException {
        if (p.isNonTypeValue() != a.isNonTypeValue()) {
            return false;
        }
        if (p.isNonTypeValue()) {
            IValue tval = p.getNonTypeValue();
            if (Value.referencesTemplateParameter(tval)) {
                int parId = Value.isTemplateParameter(tval);
                if (parId >= 0) {
                    if (!p.getTypeOfNonTypeValue().isSameType(a.getTypeOfNonTypeValue())) {
                        return false;
                    }
                    ICPPTemplateArgument old = this.fDeducedArgs.getArgument(parId, this.fPackOffset);
                    if (old == null) {
                        return this.deduce(parId, a);
                    }
                    return old.isSameValue(a);
                }
                return true;
            }
            IValue sval = a.getNonTypeValue();
            return tval.equals(sval);
        }
        return this.fromType(p.getTypeValue(), a.getTypeValue(), false);
    }

    /*
     * Unable to fully structure code
     */
    private boolean fromType(IType p, IType a, boolean allowCVQConversion) throws DOMException {
        ** GOTO lbl77
        {
            a = ((ITypedef)a).getType();
            do {
                if (a instanceof ITypedef) continue block0;
                if (p instanceof IBasicType) {
                    return p.isSameType(a);
                }
                if (p instanceof ICPPPointerToMemberType) {
                    if (!(a instanceof ICPPPointerToMemberType)) {
                        return false;
                    }
                    if (!this.fromType(((ICPPPointerToMemberType)p).getMemberOfClass(), ((ICPPPointerToMemberType)a).getMemberOfClass(), false)) {
                        return false;
                    }
                    p = ((ICPPPointerToMemberType)p).getType();
                    a = ((ICPPPointerToMemberType)a).getType();
                    continue;
                }
                if (p instanceof IPointerType) {
                    if (!(a instanceof IPointerType)) {
                        return false;
                    }
                    p = ((IPointerType)p).getType();
                    a = ((IPointerType)a).getType();
                    continue;
                }
                if (p instanceof ICPPReferenceType) {
                    if (!(a instanceof ICPPReferenceType)) {
                        return false;
                    }
                    p = ((ICPPReferenceType)p).getType();
                    a = ((ICPPReferenceType)a).getType();
                    continue;
                }
                if (p instanceof IArrayType) {
                    if (!(a instanceof IArrayType)) {
                        return false;
                    }
                    aa = (IArrayType)a;
                    pa = (IArrayType)p;
                    as = aa.getSize();
                    if (as != (ps = pa.getSize())) {
                        if (as == null || ps == null) {
                            return false;
                        }
                        parID = Value.isTemplateParameter(ps);
                        if (parID >= 0 ? ((old = this.fDeducedArgs.getArgument(parID, this.fPackOffset)) == null ? this.deduce(parID, new CPPTemplateArgument(as, new CPPBasicType(IBasicType.Kind.eInt, 0))) == false : as.equals(old.getNonTypeValue()) == false) : as.equals(as) == false) {
                            return false;
                        }
                    }
                    p = pa.getType();
                    a = aa.getType();
                    continue;
                }
                if (p instanceof IQualifierType) {
                    cvqP = SemanticUtil.getCVQualifier(p);
                    cvqA = SemanticUtil.getCVQualifier(a);
                    remaining = CVQualifier.NONE;
                    if (cvqP != cvqA) {
                        if (!allowCVQConversion && !cvqA.isAtLeastAsQualifiedAs(cvqP)) {
                            return false;
                        }
                        remaining = cvqA.remove(cvqP);
                    }
                    p = SemanticUtil.getNestedType(p, 8);
                    a = SemanticUtil.getNestedType(a, 8);
                    if (p instanceof IQualifierType) {
                        return false;
                    }
                    if (remaining == CVQualifier.NONE) continue;
                    a = SemanticUtil.addQualifiers(a, remaining.isConst(), remaining.isVolatile(), remaining.isRestrict());
                    continue;
                }
                if (p instanceof IFunctionType) {
                    if (!(a instanceof IFunctionType)) {
                        return false;
                    }
                    return this.fromFunctionType((IFunctionType)p, (IFunctionType)a);
                }
                if (p instanceof ICPPTemplateParameter) {
                    current = this.fDeducedArgs.getArgument(((ICPPTemplateParameter)p).getParameterID(), this.fPackOffset);
                    if (current != null) {
                        if (current.isNonTypeValue()) {
                            return false;
                        }
                        return current.getTypeValue().isSameType(a);
                    }
                    if (a == null) {
                        return false;
                    }
                    return this.deduce(((ICPPTemplateParameter)p).getParameterID(), new CPPTemplateArgument(a));
                }
                if (p instanceof ICPPTemplateInstance) {
                    if (!(a instanceof ICPPTemplateInstance)) {
                        return false;
                    }
                    return this.fromTemplateInstance((ICPPTemplateInstance)p, (ICPPTemplateInstance)a);
                }
                if (p instanceof ICPPUnknownBinding) {
                    return true;
                }
                return p.isSameType(a);
lbl77:
                // 7 sources

            } while (p != null);
        }
        return false;
    }

    private boolean fromTemplateInstance(ICPPTemplateInstance pInst, ICPPTemplateInstance aInst) throws DOMException {
        int tparId;
        ICPPTemplateArgument current;
        ICPPClassTemplate pTemplate = TemplateArgumentDeduction.getPrimaryTemplate(pInst);
        ICPPClassTemplate aTemplate = TemplateArgumentDeduction.getPrimaryTemplate(aInst);
        if (pTemplate == null || aTemplate == null) {
            return false;
        }
        if (pTemplate instanceof ICPPTemplateTemplateParameter ? ((current = this.fDeducedArgs.getArgument(tparId = ((ICPPTemplateTemplateParameter)pTemplate).getParameterID(), this.fPackOffset)) != null ? current.isNonTypeValue() || !current.getTypeValue().isSameType(aTemplate) : !this.deduce(tparId, new CPPTemplateArgument(aTemplate))) : !aTemplate.isSameType(pTemplate)) {
            return false;
        }
        ICPPTemplateArgument[] pArgs = pInst.getTemplateArguments();
        int i = 0;
        while (i < pArgs.length - 1) {
            if (pArgs[i].isPackExpansion()) {
                return true;
            }
            ++i;
        }
        ICPPTemplateArgument[] aArgs = aInst.getTemplateArguments();
        if (pArgs.length != aArgs.length) {
            if (pArgs.length == 0 || pArgs.length > aArgs.length + 1) {
                return false;
            }
            ICPPTemplateArgument lastPParam = pArgs[pArgs.length - 1];
            if (!lastPParam.isPackExpansion()) {
                return false;
            }
        }
        ICPPTemplateArgument expansionPattern = null;
        TemplateArgumentDeduction deduct = this;
        int i2 = 0;
        while (i2 < aArgs.length) {
            ICPPTemplateArgument p;
            if (expansionPattern != null) {
                p = expansionPattern;
                deduct.incPackOffset();
                p = CPPTemplates.instantiateArgument(p, this.fExplicitArgs, deduct.fPackOffset, null);
                if (!CPPTemplates.isValidArgument(p)) {
                    return false;
                }
            } else {
                p = pArgs[i2];
                if (p.isPackExpansion()) {
                    p = expansionPattern = p.getExpansionPattern();
                    deduct = new TemplateArgumentDeduction(this, aArgs.length - i2);
                    if (!CPPTemplates.isValidArgument(p = CPPTemplates.instantiateArgument(p, this.fExplicitArgs, deduct.fPackOffset, null))) {
                        return false;
                    }
                }
            }
            if (!deduct.fromTemplateArgument(p, aArgs[i2])) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private boolean fromFunctionType(IFunctionType ftp, IFunctionType fta) throws DOMException {
        IType[] aParams;
        if (!this.fromType(ftp.getReturnType(), fta.getReturnType(), false)) {
            return false;
        }
        IType[] pParams = ftp.getParameterTypes();
        if (pParams.length != (aParams = fta.getParameterTypes()).length) {
            if (SemanticUtil.isEmptyParameterList(pParams) && SemanticUtil.isEmptyParameterList(aParams)) {
                return true;
            }
            if (pParams.length == 0 || pParams.length > aParams.length + 1) {
                return false;
            }
            IType lastPParam = pParams[pParams.length - 1];
            if (!(lastPParam instanceof ICPPParameterPackType)) {
                return false;
            }
        }
        IType parameterPack = null;
        TemplateArgumentDeduction deduct = this;
        int i = 0;
        while (i < aParams.length) {
            IType p;
            if (parameterPack != null) {
                p = parameterPack;
                deduct.incPackOffset();
                p = CPPTemplates.instantiateType(p, this.fExplicitArgs, deduct.fPackOffset, null);
                if (!CPPTemplates.isValidType(p)) {
                    return false;
                }
            } else {
                p = pParams[i];
                if (p instanceof ICPPParameterPackType) {
                    p = parameterPack = ((ICPPParameterPackType)p).getType();
                    deduct = new TemplateArgumentDeduction(this, aParams.length - i);
                    if (!CPPTemplates.isValidType(p = CPPTemplates.instantiateType(p, this.fExplicitArgs, deduct.fPackOffset, null))) {
                        return false;
                    }
                }
            }
            if (!deduct.fromType(p, aParams[i], false)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean deduce(int parID, ICPPTemplateArgument arg) {
        if (this.fTemplateParameterPacks != null && this.fTemplateParameterPacks.contains(parID)) {
            if (this.fPackSize == 0) {
                return false;
            }
            return this.fDeducedArgs.putPackElement(parID, this.fPackOffset, arg, this.fPackSize);
        }
        if (SemanticUtil.containsUniqueTypeForParameterPack(arg.getTypeValue())) {
            return false;
        }
        this.fDeducedArgs.put(parID, arg);
        return true;
    }
}

