/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.linux.x86;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.debug.edc.ITCFAgentLauncher;
import org.eclipse.cdt.debug.edc.linux.x86.LinuxDebugger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdbserverAgentDescriptor
implements ITCFAgentLauncher {
    private static final String NAME = "Gdbserver TCF Agent";
    private Process agentProcess;

    public Map<String, String> getPeerAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("Name", NAME);
        attrs.put("DebugSupport", "GDB Remote Protocol");
        return attrs;
    }

    public String getPeerName() {
        return NAME;
    }

    public List<String> getServiceNames() {
        ArrayList<String> serviceNames = new ArrayList<String>();
        serviceNames.add("Processes");
        serviceNames.add("RunControl");
        serviceNames.add("SimpleRegisters");
        serviceNames.add("Memory");
        return serviceNames;
    }

    public boolean isLaunchable() {
        return true;
    }

    public void launch() throws Exception {
        Path path = null;
        URL url = FileLocator.find((Bundle)LinuxDebugger.getDefault().getBundle(), (IPath)new Path("$os$/GdbserverAgent.jar"), null);
        if (url != null) {
            url = FileLocator.resolve((URL)url);
            path = new Path(url.getPath());
        }
        if (path == null) {
            return;
        }
        if (!path.toFile().exists()) {
            throw new Exception("GdbserverAgent.jar file does not exist at " + path.toOSString());
        }
        CommandLauncher launcher = new CommandLauncher();
        String[] cmdarray = new String[]{"-jar", path.toOSString()};
        this.agentProcess = launcher.execute((IPath)new Path("java"), cmdarray, null, null, (IProgressMonitor)new NullProgressMonitor());
    }

    public void shutdown() throws Exception {
        if (this.agentProcess != null) {
            this.agentProcess.destroy();
        }
    }
}

