/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui;

import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class IconAndMessageAndDetailsDialog
extends IconAndMessageDialog {
    private static final int TEXT_LINE_COUNT = 7;
    private Button detailsButton;
    private String title = "EDC Debug Monitor Message";
    private Text text;
    private boolean textCreated = false;
    private int severity;
    private String details;
    private Clipboard clipboard;

    public IconAndMessageAndDetailsDialog(int severity, String summary, String details) {
        super(CDebugUIPlugin.getActiveWorkbenchShell());
        this.message = JFaceResources.format((String)"Reason", (Object[])new Object[]{"Raised by Debug Monitor", summary});
        this.details = details;
        this.severity = severity;
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(id);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createDetailsButton(parent);
    }

    protected void createDetailsButton(Composite parent) {
        if (this.shouldShowDetailsButton()) {
            this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.createMessageArea(composite);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData childData = new GridData(1808);
        childData.horizontalSpan = 2;
        childData.grabExcessVerticalSpace = false;
        composite.setLayoutData((Object)childData);
        composite.setFont(parent.getFont());
        return composite;
    }

    protected void createDialogAndButtonArea(Composite parent) {
        Composite dialogComposite;
        super.createDialogAndButtonArea(parent);
        if (this.dialogArea instanceof Composite && (dialogComposite = (Composite)this.dialogArea).getChildren().length == 0) {
            new Label(dialogComposite, 0);
        }
    }

    protected Image getImage() {
        switch (this.severity) {
            case 2: {
                return this.getWarningImage();
            }
            case 1: {
                return this.getInfoImage();
            }
        }
        return this.getErrorImage();
    }

    protected Text createDropDownText(Composite parent) {
        this.text = new Text(parent, 2882);
        this.text.setText(this.details);
        GridData data = new GridData(1808);
        data.heightHint = this.text.getLineHeight() * 7;
        data.horizontalSpan = 2;
        this.text.setLayoutData((Object)data);
        this.text.setFont(parent.getFont());
        Menu copyMenu = new Menu((Control)this.text);
        MenuItem copyItem = new MenuItem(copyMenu, 0);
        copyItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IconAndMessageAndDetailsDialog.this.copyToClipboard();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                IconAndMessageAndDetailsDialog.this.copyToClipboard();
            }
        });
        copyItem.setText(JFaceResources.getString((String)"copy"));
        this.text.setMenu(copyMenu);
        this.textCreated = true;
        return this.text;
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getShell().computeSize(-1, -1);
        if (this.textCreated) {
            this.text.dispose();
            this.textCreated = false;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.text = this.createDropDownText((Composite)this.getContents());
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
            this.getContents().getShell().layout();
        }
        Point newSize = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
    }

    private void copyToClipboard() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        this.clipboard = new Clipboard(this.text.getDisplay());
        this.clipboard.setContents(new Object[]{String.valueOf(this.details) + "\n"}, new Transfer[]{TextTransfer.getInstance()});
    }

    public boolean close() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        return super.close();
    }

    protected final void showDetailsArea() {
        Control control;
        if (!this.textCreated && (control = this.getContents()) != null && !control.isDisposed()) {
            this.toggleDetailsArea();
        }
    }

    protected boolean shouldShowDetailsButton() {
        return this.details != null && this.details.length() > 0;
    }

    protected final void setStatus(IStatus status) {
        if (this.textCreated && this.text != null && !this.text.isDisposed()) {
            this.text.setText(status.getMessage());
        }
    }

    protected boolean isResizable() {
        return true;
    }
}

