/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import org.eclipse.cdt.debug.edc.IStreamBuffer;
import org.eclipse.cdt.debug.edc.internal.StreamBufferBase;

public class FileStreamBuffer
extends StreamBufferBase {
    private final boolean DEBUG = false;
    private RandomAccessFile file;

    public FileStreamBuffer(RandomAccessFile file, ByteOrder order) throws IOException {
        super(order, 0L, file.length());
        this.file = file;
    }

    public FileStreamBuffer(RandomAccessFile file, ByteOrder order, long position, long size) {
        super(order, position, size);
        this.file = file;
    }

    protected void fetchPage(byte[] buffer, long sourceOffset, int count) {
        try {
            this.file.seek(sourceOffset);
            this.file.read(buffer, 0, count);
        }
        catch (IOException e) {
            BufferUnderflowException be = new BufferUnderflowException();
            be.initCause(e);
            throw be;
        }
    }

    protected IStreamBuffer createSubBuffer(long offset, long size) {
        return new FileStreamBuffer(this.file, this.order, offset, size);
    }
}

