/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.formatter.qt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.edc.formatter.AbstractCompositeFormatProvider;
import org.eclipse.cdt.debug.edc.formatter.FormatUtils;
import org.eclipse.cdt.debug.edc.formatter.ITypeContentProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableFormatProvider;
import org.eclipse.cdt.debug.edc.formatter.IVariableValueConverter;
import org.eclipse.cdt.debug.edc.services.IEDCExpression;
import org.eclipse.cdt.debug.edc.services.IEDCExpressions;
import org.eclipse.cdt.debug.edc.symbols.IType;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IExpressions2;
import org.eclipse.core.runtime.CoreException;

public class QVariantFormatter
implements IVariableFormatProvider {
    private static final String TYPE_NAME = "QVariant";

    public ITypeContentProvider getTypeContentProvider(IType type) {
        if (FormatUtils.checkClassOrInheritanceByName(type, TYPE_NAME)) {
            return new FormatProvider(type, false);
        }
        return null;
    }

    public IVariableValueConverter getVariableValueConverter(IType type) {
        if (FormatUtils.checkClassOrInheritanceByName(type, TYPE_NAME)) {
            return new FormatProvider(type, false);
        }
        return null;
    }

    public IVariableValueConverter getDetailValueConverter(IType type) {
        if (FormatUtils.checkClassOrInheritanceByName(type, TYPE_NAME)) {
            return new FormatProvider(type, true);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FormatProvider
    extends AbstractCompositeFormatProvider {
        private static final String TYPE_NAME = "type";
        private static final String TYPE_PATH = "d.type";
        private static final String DATA_NAME = "data";
        private static final String DATA_PATH = "d.data";
        private static final String ISSHARED_NAME = "is_shared";
        private static final String ISSHARED_PATH = "d.is_shared";
        private static final String SHARED_DATA_NAME = "shared";
        private static final String SHARED_DATA_PATH = "d.data.shared->ptr";
        private static final int TYPE_CHILD_INDEX = 0;
        private static final int DATA_CHILD_INDEX = 1;
        private static final int ISSHARED_CHILD_INDEX = 2;
        private static final int SHARED_DATA_CHILD_INDEX = 3;
        private static Map<String, String> nameToFieldPathMap = new LinkedHashMap<String, String>();
        private static Map<Integer, String> typeValueToNameMap;
        private boolean isShared;

        static {
            nameToFieldPathMap.put(TYPE_NAME, TYPE_PATH);
            nameToFieldPathMap.put(DATA_NAME, DATA_PATH);
            nameToFieldPathMap.put(ISSHARED_NAME, ISSHARED_PATH);
            nameToFieldPathMap.put(SHARED_DATA_NAME, SHARED_DATA_PATH);
            typeValueToNameMap = new HashMap<Integer, String>();
            typeValueToNameMap.put(1, "bool");
            typeValueToNameMap.put(2, "int");
            typeValueToNameMap.put(3, "uint");
            typeValueToNameMap.put(4, "qlonglong");
            typeValueToNameMap.put(5, "qulonglong");
            typeValueToNameMap.put(6, "double");
            typeValueToNameMap.put(7, "QChar");
            typeValueToNameMap.put(8, "QVariantMap");
            typeValueToNameMap.put(9, "QVariantList");
            typeValueToNameMap.put(10, "QString");
            typeValueToNameMap.put(11, "QStringList");
            typeValueToNameMap.put(12, "QByteArray");
            typeValueToNameMap.put(13, "QBitArray");
            typeValueToNameMap.put(14, "QDate");
            typeValueToNameMap.put(15, "QTime");
            typeValueToNameMap.put(16, "QDateTime");
            typeValueToNameMap.put(17, "QUrl");
            typeValueToNameMap.put(18, "QLocale");
            typeValueToNameMap.put(19, "QRect");
            typeValueToNameMap.put(20, "QRectF");
            typeValueToNameMap.put(21, "QSize");
            typeValueToNameMap.put(22, "QSizeF");
            typeValueToNameMap.put(23, "QLine");
            typeValueToNameMap.put(24, "QLineF");
            typeValueToNameMap.put(25, "QPoint");
            typeValueToNameMap.put(26, "QPointF");
            typeValueToNameMap.put(27, "QRegExp");
            typeValueToNameMap.put(28, "QVariantHash");
            typeValueToNameMap.put(135, "float");
            typeValueToNameMap.put(136, "QObject*");
        }

        public FormatProvider(IType type, boolean forDetails) {
            super(type, forDetails, FormatProvider.getNameToFieldPaths());
        }

        private static List<AbstractCompositeFormatProvider.NameToFieldPath> getNameToFieldPaths() {
            ArrayList<AbstractCompositeFormatProvider.NameToFieldPath> nameToFieldPaths = new ArrayList<AbstractCompositeFormatProvider.NameToFieldPath>();
            for (Map.Entry<String, String> entry : nameToFieldPathMap.entrySet()) {
                nameToFieldPaths.add(new AbstractCompositeFormatProvider.NameToFieldPath(entry.getKey(), entry.getValue()));
            }
            return nameToFieldPaths;
        }

        @Override
        protected List<IExpressions.IExpressionDMContext> getChildren(IExpressions.IExpressionDMContext variable) throws CoreException {
            ArrayList<IExpressions.IExpressionDMContext> children = new ArrayList<IExpressions.IExpressionDMContext>();
            List<IExpressions.IExpressionDMContext> childContexts = super.getChildren(variable);
            IEDCExpression typeChild = (IEDCExpression)childContexts.get(0);
            FormatUtils.evaluateExpression(typeChild);
            children.add(typeChild);
            IEDCExpression isSharedChild = (IEDCExpression)childContexts.get(2);
            FormatUtils.evaluateExpression(isSharedChild);
            Number isSharedValue = isSharedChild.getEvaluatedValue();
            this.isShared = isSharedValue.intValue() != 0;
            IEDCExpression dataChild = (IEDCExpression)childContexts.get(this.isShared ? 3 : 1);
            Number typeValue = typeChild.getEvaluatedValue();
            String typeString = typeValueToNameMap.get(typeValue.intValue());
            if (this.isShared) {
                typeString = String.valueOf(typeString) + '*';
            }
            if (typeString != null) {
                IEDCExpressions expressions2 = dataChild.getExpressionsService();
                IExpressions2.CastInfo castInfo = new IExpressions2.CastInfo(typeString);
                dataChild = (IEDCExpression)expressions2.createCastedExpression(dataChild, castInfo);
            }
            FormatUtils.evaluateExpression(dataChild);
            children.add(dataChild);
            return children;
        }

        @Override
        public String getValue(IExpressions.IExpressionDMContext variable) throws CoreException {
            List<IExpressions.IExpressionDMContext> children = this.getChildren(variable);
            IEDCExpression dataChild = (IEDCExpression)children.get(1);
            return FormatUtils.getFormattedValue(dataChild);
        }
    }
}

