/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.launching;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.debug.sourcelookup.DsfSourceLookupDirector;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.dsf.gdb.launching.ServicesLaunchSequence;
import org.eclipse.cdt.dsf.gdb.service.GdbDebugServicesFactory;
import org.eclipse.cdt.dsf.gdb.service.GdbDebugServicesFactoryNS;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.gdb.service.macos.MacOSGdbDebugServicesFactory;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate2;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ISourceLocator;

@ThreadSafe
public class GdbLaunchDelegate
extends AbstractCLaunchDelegate2 {
    public static final String GDB_DEBUG_MODEL_ID = "org.eclipse.cdt.dsf.gdb";
    private static final String NON_STOP_FIRST_VERSION = "6.8.50";
    private boolean fIsNonStopSession = false;
    private static final String TRACING_FIRST_VERSION = "7.1.50";
    private boolean fIsPostMortemTracingSession;

    public GdbLaunchDelegate() {
        this(false);
    }

    public GdbLaunchDelegate(boolean requireCProject) {
        super(requireCProject);
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        org.eclipse.cdt.launch.LaunchUtils.enableActivity((String)"org.eclipse.cdt.debug.dsfgdbActivity", (boolean)true);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (mode.equals("debug")) {
            this.launchDebugger(config, launch, monitor);
        }
    }

    private void launchDebugger(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(LaunchMessages.getString("GdbLaunchDelegate.0"), 10);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            this.launchDebugSession(config, launch, monitor);
        }
        finally {
            monitor.done();
        }
    }

    private void launchDebugSession(ILaunchConfiguration config, ILaunch l, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        SessionType sessionType = LaunchUtils.getSessionType(config);
        boolean attach = LaunchUtils.getIsAttach(config);
        final GdbLaunch launch = (GdbLaunch)l;
        if (sessionType == SessionType.REMOTE) {
            monitor.subTask(LaunchMessages.getString("GdbLaunchDelegate.1"));
        } else if (sessionType == SessionType.CORE) {
            monitor.subTask(LaunchMessages.getString("GdbLaunchDelegate.2"));
        } else {
            assert (sessionType == SessionType.LOCAL) : "Unexpected session type: " + sessionType.toString();
            monitor.subTask(LaunchMessages.getString("GdbLaunchDelegate.3"));
        }
        if (!attach) {
            this.checkBinaryDetails(config);
        }
        monitor.worked(1);
        String gdbVersion = this.getGDBVersion(config);
        if (this.fIsNonStopSession && !this.isNonStopSupportedInGdbVersion(gdbVersion)) {
            throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5012, "Non-stop mode is only supported starting with GDB 6.8.50", null));
        }
        if (this.fIsPostMortemTracingSession && !this.isPostMortemTracingSupportedInGdbVersion(gdbVersion)) {
            throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5012, "Post-mortem tracing is only supported starting with GDB 7.1.50", null));
        }
        launch.setServiceFactory(this.newServiceFactory(gdbVersion));
        SubProgressMonitor subMon1 = new SubProgressMonitor(monitor, 4, 4);
        ServicesLaunchSequence servicesLaunchSequence = new ServicesLaunchSequence(launch.getSession(), launch, (IProgressMonitor)subMon1);
        launch.getSession().getExecutor().execute((Runnable)((Object)servicesLaunchSequence));
        try {
            servicesLaunchSequence.get();
        }
        catch (InterruptedException e1) {
            throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5013, "Interrupted Exception in dispatch thread", (Throwable)e1));
        }
        catch (ExecutionException e1) {
            throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5012, "Error in services launch sequence", e1.getCause()));
        }
        catch (CancellationException cancellationException) {
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        launch.initializeControl();
        launch.addCLIProcess("gdb");
        monitor.worked(1);
        SubProgressMonitor subMon2 = new SubProgressMonitor(monitor, 4, 4);
        Query<Object> completeLaunchQuery = new Query<Object>((IProgressMonitor)subMon2){
            private final /* synthetic */ IProgressMonitor val$subMon2;
            {
                this.val$subMon2 = iProgressMonitor;
            }

            protected void execute(final DataRequestMonitor<Object> rm) {
                DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), launch.getSession().getId());
                IGDBControl control = (IGDBControl)tracker.getService(IGDBControl.class);
                tracker.dispose();
                control.completeInitialization((RequestMonitor)new RequestMonitorWithProgress(ImmediateExecutor.getInstance(), this.val$subMon2){

                    protected void handleCompleted() {
                        if (this.isCanceled()) {
                            rm.cancel();
                        } else {
                            rm.setStatus(this.getStatus());
                        }
                        rm.done();
                    }
                });
            }
        };
        launch.getSession().getExecutor().execute((Runnable)completeLaunchQuery);
        boolean succeed = false;
        try {
            try {
                completeLaunchQuery.get();
                succeed = true;
            }
            catch (InterruptedException e1) {
                throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5013, "Interrupted Exception in dispatch thread", (Throwable)e1));
            }
            catch (ExecutionException e1) {
                throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5012, "Error in final launch sequence", e1.getCause()));
            }
            catch (CancellationException cancellationException) {
                if (!succeed) {
                    Query<Object> launchShutdownQuery = new Query<Object>(launch){
                        private final /* synthetic */ GdbLaunch val$launch;
                        {
                            this.val$launch = gdbLaunch;
                        }

                        protected void execute(DataRequestMonitor<Object> rm) {
                            this.val$launch.shutdownSession((RequestMonitor)rm);
                        }
                    };
                    launch.getSession().getExecutor().execute((Runnable)launchShutdownQuery);
                    try {
                        launchShutdownQuery.get();
                    }
                    catch (InterruptedException e) {
                        throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5013, "InterruptedException while shutting down debugger launch " + launch, (Throwable)e));
                    }
                    catch (ExecutionException e) {
                        throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5012, "Error in shutting down debugger launch " + launch, (Throwable)e));
                    }
                }
                return;
            }
        }
        catch (Throwable throwable) {
            if (!succeed) {
                Query<Object> launchShutdownQuery = new /* invalid duplicate definition of identical inner class */;
                launch.getSession().getExecutor().execute((Runnable)launchShutdownQuery);
                try {
                    launchShutdownQuery.get();
                }
                catch (InterruptedException e) {
                    throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5013, "InterruptedException while shutting down debugger launch " + launch, (Throwable)e));
                }
                catch (ExecutionException e) {
                    throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5012, "Error in shutting down debugger launch " + launch, (Throwable)e));
                }
            }
            throw throwable;
        }
        if (!succeed) {
            Query<Object> launchShutdownQuery = new /* invalid duplicate definition of identical inner class */;
            launch.getSession().getExecutor().execute((Runnable)launchShutdownQuery);
            try {
                launchShutdownQuery.get();
            }
            catch (InterruptedException e) {
                throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5013, "InterruptedException while shutting down debugger launch " + launch, (Throwable)e));
            }
            catch (ExecutionException e) {
                throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5012, "Error in shutting down debugger launch " + launch, (Throwable)e));
            }
        }
    }

    protected IPath checkBinaryDetails(ILaunchConfiguration config) throws CoreException {
        ICProject project = this.verifyCProject(config);
        IPath exePath = LaunchUtils.verifyProgramPath(config, project);
        LaunchUtils.verifyBinary(config, exePath);
        return exePath;
    }

    protected String getGDBVersion(ILaunchConfiguration config) throws CoreException {
        return LaunchUtils.getGDBVersion(config);
    }

    public boolean preLaunchCheck(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        if (mode.equals("debug") && LaunchUtils.getSessionType(config) == SessionType.CORE) {
            return true;
        }
        return super.preLaunchCheck(config, mode, monitor);
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        this.fIsNonStopSession = LaunchUtils.getIsNonStopMode(configuration);
        this.fIsPostMortemTracingSession = LaunchUtils.getIsPostMortemTracing(configuration);
        GdbLaunch launch = new GdbLaunch(configuration, mode, null);
        launch.initialize();
        launch.setSourceLocator(this.getSourceLocator(configuration, launch.getSession()));
        return launch;
    }

    private ISourceLocator getSourceLocator(ILaunchConfiguration configuration, DsfSession session) throws CoreException {
        DsfSourceLookupDirector locator = new DsfSourceLookupDirector(session);
        String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
        if (memento == null) {
            locator.initializeDefaults(configuration);
        } else {
            locator.initializeFromMemento(memento, configuration);
        }
        return locator;
    }

    protected boolean isNonStopSupportedInGdbVersion(String version) {
        if (version.contains("APPLE")) {
            return false;
        }
        return NON_STOP_FIRST_VERSION.compareTo(version) <= 0;
    }

    protected boolean isPostMortemTracingSupportedInGdbVersion(String version) {
        if (version.contains("APPLE")) {
            return false;
        }
        return TRACING_FIRST_VERSION.compareTo(version) <= 0 || "6.8.50.20090414".equals(version);
    }

    protected IDsfDebugServicesFactory newServiceFactory(String version) {
        String[] versions;
        if (this.fIsNonStopSession && this.isNonStopSupportedInGdbVersion(version)) {
            return new GdbDebugServicesFactoryNS(version);
        }
        if (version.contains("APPLE") && (versions = version.split("APPLE")).length == 2) {
            return new MacOSGdbDebugServicesFactory(versions[0], versions[1]);
        }
        return new GdbDebugServicesFactory(version);
    }

    protected String getPluginID() {
        return GDB_DEBUG_MODEL_ID;
    }
}

