/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.timers;

import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.eclipse.cdt.examples.dsf.DsfExamplesPlugin;
import org.eclipse.cdt.examples.dsf.timers.AlarmService;
import org.eclipse.cdt.examples.dsf.timers.TimerService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicesShutdownSequence
extends Sequence {
    private final DsfSession fSession;
    DsfServicesTracker fTracker;
    Sequence.Step[] fSteps = new Sequence.Step[]{new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ServicesShutdownSequence.this.fTracker = new DsfServicesTracker(DsfExamplesPlugin.getBundleContext(), ServicesShutdownSequence.this.fSession.getId());
            requestMonitor.done();
        }

        public void rollBack(RequestMonitor requestMonitor) {
            ServicesShutdownSequence.this.fTracker.dispose();
            ServicesShutdownSequence.this.fTracker = null;
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ServicesShutdownSequence.this.shutdownService(AlarmService.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ServicesShutdownSequence.this.shutdownService(TimerService.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ServicesShutdownSequence.this.fTracker.dispose();
            ServicesShutdownSequence.this.fTracker = null;
            requestMonitor.done();
        }
    }};

    public ServicesShutdownSequence(DsfSession session) {
        super(session.getExecutor());
        this.fSession = session;
    }

    public Sequence.Step[] getSteps() {
        return this.fSteps;
    }

    private <V extends IDsfService> void shutdownService(Class<V> clazz, RequestMonitor requestMonitor) {
        IDsfService service = (IDsfService)this.fTracker.getService(clazz);
        if (service != null) {
            service.shutdown(requestMonitor);
        } else {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.examples.dsf", 10005, "Service '" + clazz.getName() + "' not found.", null));
            requestMonitor.done();
        }
    }
}

