/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProjectManager;
import org.eclipse.cdt.managedbuilder.testplugin.CTestPlugin;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class MultiVersionSupportTests
extends TestCase {
    static IProject proj = null;
    static IManagedProject mproj = null;
    IConfiguration[] cfgs = null;
    private IWorkspace worksp;

    public MultiVersionSupportTests() {
    }

    public MultiVersionSupportTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(MultiVersionSupportTests.class.getName());
        suite.addTest((Test)new MultiVersionSupportTests("testProjectConverterConvenienceRoutines"));
        suite.addTest((Test)new MultiVersionSupportTests("testConfigurationNameProvider"));
        suite.addTest((Test)new MultiVersionSupportTests("testConfigurationDescription"));
        suite.addTest((Test)new MultiVersionSupportTests("testVersionInfo"));
        suite.addTest((Test)new MultiVersionSupportTests("testVersionsSupportedAttribute"));
        suite.addTest((Test)new MultiVersionSupportTests("testToolChainConversion_CDT21"));
        suite.addTest((Test)new MultiVersionSupportTests("testProjectConversion"));
        return suite;
    }

    public void testProjectConverterConvenienceRoutines() throws Exception {
        String projectName = "TestProjectConverterConvenienceRoutines";
        String projectTypeId = "testProjectConverterConvenienceRoutines.exe";
        this.doInit(projectName, projectTypeId);
        MultiVersionSupportTests.assertEquals((int)this.cfgs.length, (int)1);
        IToolChain toolChain = this.cfgs[0].getToolChain();
        boolean hasConverters = ManagedBuildManager.hasTargetConversionElements((IBuildObject)toolChain);
        MultiVersionSupportTests.assertEquals((boolean)hasConverters, (boolean)true);
        Map converters = ManagedBuildManager.getConversionElements((IBuildObject)toolChain);
        MultiVersionSupportTests.assertEquals((int)converters.size(), (int)1);
    }

    public void testConfigurationNameProvider() throws Exception {
        String[] expectedConfigNames = new String[]{"Debug", "Release", "Debug_ia64", "Release_ia64"};
        String[] actualConfigNames = new String[4];
        String projectName = "TestConfigurationNameProvider";
        String projectTypeId = "cdt.managedbuild.target.testMultipleVersions.exe";
        this.doInit(projectName, projectTypeId);
        this.cfgs = mproj.getConfigurations();
        int i = 0;
        while (i < this.cfgs.length) {
            actualConfigNames[i] = this.cfgs[i].getName();
            ++i;
        }
        i = 0;
        while (i < expectedConfigNames.length) {
            MultiVersionSupportTests.assertTrue((boolean)this.isArrayContains(actualConfigNames, expectedConfigNames[i]));
            ++i;
        }
    }

    public void testConfigurationDescription() throws Exception {
        String[] expectedConfigDescriptions = new String[]{"debug configuration for IA32 windows", "release configuration for IA32 windows", "debug configuration for IA64 windows", "release configuration for IA64 windows"};
        String[] actualConfigDescriptions = new String[4];
        String projectName = "TestConfigurationDescription";
        String projectTypeId = "cdt.managedbuild.target.testMultipleVersions.exe";
        this.doInit(projectName, projectTypeId);
        this.cfgs = mproj.getConfigurations();
        int i = 0;
        while (i < this.cfgs.length) {
            actualConfigDescriptions[i] = this.cfgs[i].getDescription();
            ++i;
        }
        i = 0;
        while (i < expectedConfigDescriptions.length) {
            MultiVersionSupportTests.assertTrue((boolean)this.isArrayContains(actualConfigDescriptions, expectedConfigDescriptions[i]));
            ++i;
        }
    }

    public void testVersionInfo() throws Exception {
        String projectName = "TestVersionInfo";
        String projectTypeId = "cdt.managedbuild.target.testMultipleVersions.exe";
        this.doInit(projectName, projectTypeId);
        this.cfgs = mproj.getConfigurations();
        IConfiguration releaseConfig = mproj.getConfiguration("cdt.managedbuild.config.testMultipleVersions.exe.release.1");
        MultiVersionSupportTests.assertEquals((String)releaseConfig.getToolChain().getVersion().toString(), (String)"0.0.4");
        ITool[] tools = releaseConfig.getToolChain().getTools();
        int i = 0;
        while (i < tools.length) {
            ITool tool = tools[i];
            MultiVersionSupportTests.assertEquals((String)tool.getVersion().toString(), (String)"0.0.4");
            ++i;
        }
        IBuilder builder = releaseConfig.getToolChain().getBuilder();
        MultiVersionSupportTests.assertEquals((String)builder.getVersion().toString(), (String)"0.0.4");
        IConfiguration debugConfig = mproj.getConfiguration("cdt.managedbuild.config.testMultipleVersions.exe.debug.0");
        MultiVersionSupportTests.assertEquals((String)debugConfig.getToolChain().getVersion().toString(), (String)"1.1.0");
        tools = debugConfig.getToolChain().getTools();
        int i2 = 0;
        while (i2 < tools.length) {
            ITool tool = tools[i2];
            MultiVersionSupportTests.assertEquals((String)tool.getVersion().toString(), (String)"1.1.0");
            ++i2;
        }
        builder = debugConfig.getToolChain().getBuilder();
        MultiVersionSupportTests.assertEquals((String)builder.getVersion().toString(), (String)"1.1.0");
        IConfiguration debug64Config = mproj.getConfiguration("cdt.managedbuild.config.testMultipleVersions.exe.debug64.2");
        MultiVersionSupportTests.assertEquals((String)debug64Config.getToolChain().getVersion().toString(), (String)"2.2.0");
        tools = debug64Config.getToolChain().getTools();
        int i3 = 0;
        while (i3 < tools.length) {
            ITool tool = tools[i3];
            MultiVersionSupportTests.assertEquals((String)tool.getVersion().toString(), (String)"5.0.9");
            ++i3;
        }
        builder = debug64Config.getToolChain().getBuilder();
        MultiVersionSupportTests.assertEquals((String)builder.getVersion().toString(), (String)"3.2.1");
    }

    public void testVersionsSupportedAttribute() throws Exception {
        String projectName = "TestVersionSupportAttribute";
        String projectTypeId = "cdt.managedbuild.target.testMultipleVersions.exe";
        this.doInit(projectName, projectTypeId);
        this.cfgs = mproj.getConfigurations();
        IConfiguration releaseConfig = mproj.getConfiguration("cdt.managedbuild.config.testMultipleVersions.exe.release64.3");
        IToolChain toolChain = releaseConfig.getToolChain();
        String toolChainVersionsSupported = toolChain.getVersionsSupported();
        MultiVersionSupportTests.assertEquals((String)toolChainVersionsSupported, (String)"1.2.0,2.0.0,2.1.3");
        IBuilder builder = releaseConfig.getToolChain().getBuilder();
        String versionsSupported = builder.getVersionsSupported();
        MultiVersionSupportTests.assertEquals((String)versionsSupported, (String)"2.0.0,2.1.1,3.0.3");
    }

    static void createManagedProject(String name, String projectTypeId) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        proj = root.getProject(name);
        if (proj.exists()) {
            mproj = ManagedBuildManager.getBuildInfo((IResource)proj).getManagedProject();
        } else {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription workspaceDesc = workspace.getDescription();
            workspaceDesc.setAutoBuilding(false);
            try {
                workspace.setDescription(workspaceDesc);
                proj = CCorePlugin.getDefault().createCProject(workspace.newProjectDescription(proj.getName()), proj, (IProgressMonitor)new NullProgressMonitor(), ManagedBuilderCorePlugin.MANAGED_MAKE_PROJECT_ID);
                ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)proj);
                info.setValid(true);
                ManagedCProjectNature.addManagedNature((IProject)proj, null);
                ManagedCProjectNature.addManagedBuilder((IProject)proj, null);
                ICDescriptor desc = CCorePlugin.getDefault().getCProjectDescription(proj, true);
                desc.remove("org.eclipse.cdt.core.ScannerInfoProvider");
                desc.create("org.eclipse.cdt.core.ScannerInfoProvider", ManagedBuildManager.INTERFACE_IDENTITY);
                desc.saveProjectData();
            }
            catch (CoreException e) {
                MultiVersionSupportTests.fail((String)("Cannot create project: " + e.getLocalizedMessage()));
            }
            ManagedBuildManager.getDefinedProjectTypes();
            IProjectType projType = ManagedBuildManager.getProjectType((String)projectTypeId);
            MultiVersionSupportTests.assertNotNull((Object)projType);
            try {
                mproj = ManagedBuildManager.createManagedProject((IResource)proj, (IProjectType)projType);
            }
            catch (BuildException buildException) {}
            ManagedBuildManager.setNewProjectVersion((IProject)proj);
            IConfiguration[] cfgs = projType.getConfigurations();
            int i = 0;
            while (i < cfgs.length) {
                mproj.createConfiguration(cfgs[i], String.valueOf(cfgs[i].getId()) + "." + i);
                ++i;
            }
            if (cfgs.length > 0) {
                ManagedBuildManager.setDefaultConfiguration((IProject)proj, (IConfiguration)cfgs[0]);
            } else {
                ManagedBuildManager.setDefaultConfiguration((IProject)proj, null);
            }
        }
        try {
            proj.open(null);
        }
        catch (CoreException coreException) {}
    }

    private boolean isArrayContains(String[] actualConfigNames, String name) {
        if (actualConfigNames != null) {
            int i = 0;
            while (i < actualConfigNames.length) {
                if (actualConfigNames[i] != null && actualConfigNames[i].equals(name)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void doInit(String projectName, String projectTypeId) {
        MultiVersionSupportTests.createManagedProject(projectName, projectTypeId);
        MultiVersionSupportTests.assertNotNull((Object)proj);
        MultiVersionSupportTests.assertNotNull((Object)mproj);
        this.worksp = proj.getWorkspace();
        MultiVersionSupportTests.assertNotNull((Object)this.worksp);
        this.cfgs = mproj.getConfigurations();
        MultiVersionSupportTests.assertNotNull((Object)this.cfgs);
    }

    public void testToolChainConversion_CDT20() throws Exception {
        this.doTestProjectUpdate("test20", true);
        String tmpDir = System.getProperty("java.io.tmpdir");
        File inputFile = new File(String.valueOf(tmpDir) + "/converterOutput20.txt");
        try {
            MultiVersionSupportTests.assertTrue((boolean)inputFile.exists());
            String expectedContent = "Converter for CDT 2.0 Project is invoked";
            BufferedReader data = new BufferedReader(new FileReader(inputFile));
            String actualContent = data.readLine();
            if (actualContent != null) {
                MultiVersionSupportTests.assertEquals((String)actualContent, (String)expectedContent);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void testToolChainConversion_CDT21() throws Exception {
        this.doTestProjectUpdate("test21", true);
        String tmpDir = System.getProperty("java.io.tmpdir");
        File inputFile = new File(String.valueOf(tmpDir) + "/converterOutput21.txt");
        try {
            MultiVersionSupportTests.assertTrue((boolean)inputFile.exists());
            String expectedContent = "Converter for CDT 2.1 Project is invoked";
            BufferedReader data = new BufferedReader(new FileReader(inputFile));
            String actualContent = data.readLine();
            if (actualContent != null) {
                MultiVersionSupportTests.assertEquals((String)actualContent, (String)expectedContent);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void testProjectConversion() throws Exception {
        this.doTestProjectUpdate("testProjectConversion", true);
        String tmpDir = System.getProperty("java.io.tmpdir");
        File inputFile = new File(String.valueOf(tmpDir) + "/testProjectConverterOutput.txt");
        try {
            MultiVersionSupportTests.assertTrue((boolean)inputFile.exists());
            String expectedContent = "The converter for the projectType testProject_1.0.0 is invoked";
            BufferedReader data = new BufferedReader(new FileReader(inputFile));
            String actualContent = data.readLine();
            if (actualContent != null) {
                MultiVersionSupportTests.assertEquals((String)actualContent, (String)expectedContent);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private IProject getCDT_TestProject(String projDirName) {
        IProject project = null;
        File file = null;
        if (projDirName.equalsIgnoreCase("test20")) {
            file = CTestPlugin.getFileInPlugin((IPath)new Path("resources/toolChainConversionProjects/test20"));
        } else if (projDirName.equals("test21")) {
            file = CTestPlugin.getFileInPlugin((IPath)new Path("resources/toolChainConversionProjects/test21"));
        } else if (projDirName.equals("testProjectConversion")) {
            file = CTestPlugin.getFileInPlugin((IPath)new Path("resources/toolChainConversionProjects/testProjectConversion"));
        }
        if (file == null) {
            MultiVersionSupportTests.fail((String)"Test project directory  is missing.");
            return null;
        }
        File[] projectZips = file.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return !pathname.isDirectory();
            }
        });
        ArrayList<IProject> projectList = new ArrayList<IProject>(projectZips.length);
        MultiVersionSupportTests.assertEquals((int)projectZips.length, (int)1);
        try {
            String projectName = projectZips[0].getName();
            if (!projectName.endsWith(".zip")) {
                MultiVersionSupportTests.fail((String)("No projects found in test 'toolChainConversionProjects' project directory " + file.getName() + ".  The .zip file may be missing or corrupt."));
            }
            if ((projectName = projectName.substring(0, projectName.length() - ".zip".length())).length() == 0) {
                MultiVersionSupportTests.fail((String)("No projects found in test 'toolChainConversionProjects' project directory " + file.getName() + ".  The .zip file may be missing or corrupt."));
            }
            if ((project = ManagedBuildTestHelper.createProject(projectName, projectZips[0], null, null)) != null) {
                projectList.add(project);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception Occured.");
        }
        if (projectList.size() == 0) {
            MultiVersionSupportTests.fail((String)("No projects found in test project directory " + file.getName() + ".  The .zip file may be missing or corrupt."));
            return null;
        }
        return project;
    }

    private void doTestProjectUpdate(String projDirName, boolean updateProject) {
        IOverwriteQuery queryALL = new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "ALL";
            }
        };
        IOverwriteQuery queryNOALL = new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "NOALL";
            }
        };
        UpdateManagedProjectManager.setUpdateProjectQuery((IOverwriteQuery)(updateProject ? queryALL : queryNOALL));
        IProject project = this.getCDT_TestProject(projDirName);
        if (project == null) {
            return;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        boolean isCompatible = UpdateManagedProjectManager.isCompatibleProject((IManagedBuildInfo)info);
        MultiVersionSupportTests.assertTrue((boolean)isCompatible);
        if (isCompatible && updateProject && (info == null || info.getManagedProject() == null || !info.getManagedProject().isValid())) {
            MultiVersionSupportTests.fail((String)("the project \"" + project.getName() + "\" was not properly converted"));
        }
        ManagedBuildTestHelper.removeProject(project.getName());
    }
}

