/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.c.hover;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.c.hover.ICEditorTextHover;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CEditorTextHoverDescriptor
implements Comparable<CEditorTextHoverDescriptor> {
    private static final String C_EDITOR_TEXT_HOVER_EXTENSION_POINT = "org.eclipse.cdt.ui.textHovers";
    private static final String HOVER_TAG = "hover";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String ACTIVATE_PLUG_IN_ATTRIBUTE = "activate";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String PERSPECTIVE = "perspective";
    public static final String NO_MODIFIER = "0";
    public static final String DISABLED_TAG = "!";
    public static final String VALUE_SEPARATOR = ";";
    private int fStateMask;
    private String fModifierString;
    private boolean fIsEnabled;
    private IConfigurationElement fElement;

    public static CEditorTextHoverDescriptor[] getContributedHovers() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(C_EDITOR_TEXT_HOVER_EXTENSION_POINT);
        CEditorTextHoverDescriptor[] hoverDescs = CEditorTextHoverDescriptor.createDescriptors(elements);
        CEditorTextHoverDescriptor.initializeFromPreferences(hoverDescs);
        return hoverDescs;
    }

    public static int computeStateMask(String modifiers) {
        if (modifiers == null) {
            return -1;
        }
        if (modifiers.length() == 0) {
            return 0;
        }
        int stateMask = 0;
        StringTokenizer modifierTokenizer = new StringTokenizer(modifiers, ",;.:+-* ");
        while (modifierTokenizer.hasMoreTokens()) {
            int modifier = EditorUtility.findLocalizedModifier(modifierTokenizer.nextToken());
            if (modifier == 0 || (stateMask & modifier) == modifier) {
                return -1;
            }
            stateMask |= modifier;
        }
        return stateMask;
    }

    private CEditorTextHoverDescriptor(IConfigurationElement element) {
        Assert.isNotNull((Object)element);
        this.fElement = element;
    }

    public ICEditorTextHover createTextHover() {
        boolean isHoversPlugInActivated;
        String pluginId = this.fElement.getDeclaringExtension().getContributor().getName();
        boolean bl = isHoversPlugInActivated = Platform.getBundle((String)pluginId).getState() == 32;
        if (isHoversPlugInActivated || this.canActivatePlugIn()) {
            try {
                return (ICEditorTextHover)this.fElement.createExecutableExtension(CLASS_ATTRIBUTE);
            }
            catch (CoreException coreException) {
                CUIPlugin.log((IStatus)new Status(4, CUIPlugin.getPluginId(), 0, "CEditorTextHover.createTextHover", null));
            }
        }
        return null;
    }

    public String getId() {
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public String getHoverClassName() {
        return this.fElement.getAttribute(CLASS_ATTRIBUTE);
    }

    public String getLabel() {
        String label = this.fElement.getAttribute(LABEL_ATTRIBUTE);
        if (label != null) {
            return label;
        }
        label = this.getHoverClassName();
        int lastDot = label.lastIndexOf(46);
        if (lastDot >= 0 && lastDot < label.length() - 1) {
            return label.substring(lastDot + 1);
        }
        return label;
    }

    public String getDescription() {
        return this.fElement.getAttribute(DESCRIPTION_ATTRIBUTE);
    }

    public String getPerspective() {
        return this.fElement.getAttribute(PERSPECTIVE);
    }

    public boolean canActivatePlugIn() {
        return Boolean.valueOf(this.fElement.getAttribute(ACTIVATE_PLUG_IN_ATTRIBUTE));
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass()) || this.getId() == null) {
            return false;
        }
        return this.getId().equals(((CEditorTextHoverDescriptor)obj).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public int compareTo(CEditorTextHoverDescriptor o) {
        return Collator.getInstance().compare(this.getLabel(), o.getLabel());
    }

    private static CEditorTextHoverDescriptor[] createDescriptors(IConfigurationElement[] elements) {
        ArrayList<CEditorTextHoverDescriptor> result = new ArrayList<CEditorTextHoverDescriptor>(elements.length);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (HOVER_TAG.equals(element.getName())) {
                CEditorTextHoverDescriptor desc = new CEditorTextHoverDescriptor(element);
                result.add(desc);
            }
            ++n2;
        }
        Collections.sort(result);
        return result.toArray(new CEditorTextHoverDescriptor[result.size()]);
    }

    private static void initializeFromPreferences(CEditorTextHoverDescriptor[] hovers) {
        String compiledTextHoverModifiers = CUIPlugin.getDefault().getPreferenceStore().getString("hoverModifiers");
        StringTokenizer tokenizer = new StringTokenizer(compiledTextHoverModifiers, VALUE_SEPARATOR);
        HashMap<String, String> idToModifier = new HashMap<String, String>(tokenizer.countTokens() / 2);
        while (tokenizer.hasMoreTokens()) {
            String id = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) continue;
            idToModifier.put(id, tokenizer.nextToken());
        }
        String compiledTextHoverModifierMasks = CUIPlugin.getDefault().getPreferenceStore().getString("hoverModifierMasks");
        tokenizer = new StringTokenizer(compiledTextHoverModifierMasks, VALUE_SEPARATOR);
        HashMap<String, String> idToModifierMask = new HashMap<String, String>(tokenizer.countTokens() / 2);
        while (tokenizer.hasMoreTokens()) {
            String id = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) continue;
            idToModifierMask.put(id, tokenizer.nextToken());
        }
        int i = 0;
        while (i < hovers.length) {
            String modifierString = (String)idToModifier.get(hovers[i].getId());
            boolean enabled = true;
            if (modifierString == null) {
                modifierString = DISABLED_TAG;
            }
            if (modifierString.startsWith(DISABLED_TAG)) {
                enabled = false;
                modifierString = modifierString.substring(1);
            }
            if (modifierString.equals(NO_MODIFIER)) {
                modifierString = "";
            }
            hovers[i].fModifierString = modifierString;
            hovers[i].fIsEnabled = enabled;
            hovers[i].fStateMask = CEditorTextHoverDescriptor.computeStateMask(modifierString);
            if (hovers[i].fStateMask == -1) {
                try {
                    hovers[i].fStateMask = Integer.parseInt((String)idToModifierMask.get(hovers[i].getId()));
                }
                catch (NumberFormatException numberFormatException) {
                    hovers[i].fStateMask = -1;
                }
                int stateMask = hovers[i].fStateMask;
                hovers[i].fModifierString = stateMask == -1 ? "" : EditorUtility.getModifierString(stateMask);
            }
            ++i;
        }
    }

    public int getStateMask() {
        return this.fStateMask;
    }

    public String getModifierString() {
        return this.fModifierString;
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.fElement;
    }

    public String toString() {
        return this.getId();
    }
}

