/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.rewrite.MacroExpansionExplorer;
import org.eclipse.cdt.core.parser.util.CharArrayMap;
import org.eclipse.cdt.internal.core.parser.scanner.ILexerLog;
import org.eclipse.cdt.internal.core.parser.scanner.Lexer;
import org.eclipse.cdt.internal.core.parser.scanner.MacroExpander;
import org.eclipse.cdt.internal.core.parser.scanner.MacroExpansionStep;
import org.eclipse.cdt.internal.core.parser.scanner.MacroExpansionTracker;
import org.eclipse.cdt.internal.core.parser.scanner.PreprocessorMacro;
import org.eclipse.text.edits.ReplaceEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleMacroExpansionExplorer
extends MacroExpansionExplorer {
    private final String fInput;
    private final CharArrayMap<PreprocessorMacro> fDictionary;
    private MacroExpansionStep fFullExpansion;
    private int fExpansionCount;
    private final String fFilePath;
    private final int fLineNumber;
    private final Map<IMacroBinding, IASTFileLocation> fMacroLocationMap;
    private final boolean fIsPPCondition;
    private final Lexer.LexerOptions fLexerOptions;

    public SingleMacroExpansionExplorer(String input, IASTName[] refs, Map<IMacroBinding, IASTFileLocation> macroDefinitionLocationMap, String filePath, int lineNumber, boolean isPPCondition, Lexer.LexerOptions options) {
        this.fInput = input;
        this.fDictionary = this.createDictionary(refs);
        this.fMacroLocationMap = macroDefinitionLocationMap;
        this.fFilePath = filePath;
        this.fLineNumber = lineNumber;
        this.fIsPPCondition = isPPCondition;
        this.fLexerOptions = (Lexer.LexerOptions)options.clone();
        this.fLexerOptions.fCreateImageLocations = false;
    }

    private CharArrayMap<PreprocessorMacro> createDictionary(IASTName[] refs) {
        CharArrayMap<PreprocessorMacro> map = new CharArrayMap<PreprocessorMacro>(refs.length);
        IASTName[] iASTNameArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName name = iASTNameArray[n2];
            this.addMacroDefinition(map, name);
            ++n2;
        }
        return map;
    }

    private void addMacroDefinition(CharArrayMap<PreprocessorMacro> map, IASTName name) {
        IBinding binding = name.getBinding();
        if (binding instanceof PreprocessorMacro) {
            map.put(name.getSimpleID(), (PreprocessorMacro)binding);
        }
    }

    @Override
    public MacroExpansionExplorer.IMacroExpansionStep getFullExpansion() {
        this.computeExpansion();
        return this.fFullExpansion;
    }

    @Override
    public int getExpansionStepCount() {
        this.computeExpansion();
        return this.fExpansionCount;
    }

    private void computeExpansion() {
        ReplaceEdit[] replaceEditArray;
        MacroExpander expander = new MacroExpander(ILexerLog.NULL, this.fDictionary, null, this.fLexerOptions);
        MacroExpansionTracker tracker = new MacroExpansionTracker(Integer.MAX_VALUE);
        expander.expand(this.fInput, tracker, this.fFilePath, this.fLineNumber, this.fIsPPCondition);
        this.fExpansionCount = tracker.getStepCount();
        ReplaceEdit r = tracker.getReplacement();
        if (r == null) {
            replaceEditArray = new ReplaceEdit[]{};
        } else {
            ReplaceEdit[] replaceEditArray2 = new ReplaceEdit[1];
            replaceEditArray = replaceEditArray2;
            replaceEditArray2[0] = r;
        }
        ReplaceEdit[] replacements = replaceEditArray;
        this.fFullExpansion = new MacroExpansionStep(this.fInput, null, null, replacements);
    }

    @Override
    public MacroExpansionStep getExpansionStep(int step) throws IndexOutOfBoundsException {
        ReplaceEdit[] replaceEditArray;
        this.computeExpansion();
        if (step < 0 || step >= this.fExpansionCount) {
            throw new IndexOutOfBoundsException();
        }
        MacroExpander expander = new MacroExpander(ILexerLog.NULL, this.fDictionary, null, this.fLexerOptions);
        MacroExpansionTracker tracker = new MacroExpansionTracker(step);
        expander.expand(this.fInput, tracker, this.fFilePath, this.fLineNumber, this.fIsPPCondition);
        this.fExpansionCount = tracker.getStepCount();
        ReplaceEdit r = tracker.getReplacement();
        if (r == null) {
            replaceEditArray = new ReplaceEdit[]{};
        } else {
            ReplaceEdit[] replaceEditArray2 = new ReplaceEdit[1];
            replaceEditArray = replaceEditArray2;
            replaceEditArray2[0] = r;
        }
        ReplaceEdit[] replacements = replaceEditArray;
        IMacroBinding macro = tracker.getExpandedMacro();
        return new MacroExpansionStep(tracker.getCodeBeforeStep(), macro, this.fMacroLocationMap.get(macro), replacements);
    }
}

