/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui;

import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.edc.internal.ui.EDCDebugUI;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfCommandRunnable;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.core.commands.ITerminateHandler;

public class DsfTerminateCommand
implements ITerminateHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public DsfTerminateCommand(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(EDCDebugUI.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public void canExecute(final IEnabledStateRequest request) {
        if (request.getElements().length != 1 || !(request.getElements()[0] instanceof IDMVMContext)) {
            request.setEnabled(false);
            request.done();
            return;
        }
        IDMVMContext vmc = (IDMVMContext)request.getElements()[0];
        final IProcesses.IThreadDMContext dmc = (IProcesses.IThreadDMContext)DMContexts.getAncestorOfType((IDMContext)vmc.getDMContext(), IProcesses.IThreadDMContext.class);
        if (dmc == null) {
            request.setEnabled(false);
            request.done();
            return;
        }
        this.fExecutor.execute((Runnable)new DsfRunnable(){

            public void run() {
                IProcesses processesService = (IProcesses)DsfTerminateCommand.this.fTracker.getService(IProcesses.class);
                if (processesService == null || dmc == null) {
                    request.setEnabled(false);
                    request.done();
                } else {
                    processesService.canTerminate(dmc, (DataRequestMonitor)new DataRequestMonitor<Boolean>(ImmediateExecutor.getInstance(), null){

                        protected void handleCompleted() {
                            if (this.isSuccess()) {
                                Boolean result = (Boolean)this.getData();
                                if (!$assertionsDisabled && result == null) {
                                    throw new AssertionError((Object)"successful request should provide a result");
                                }
                                request.setEnabled(result != null ? result : false);
                            } else {
                                request.setEnabled(false);
                            }
                            request.done();
                        }
                    });
                }
            }
        });
    }

    public boolean execute(IDebugCommandRequest request) {
        if (request.getElements().length != 1) {
            request.done();
            return false;
        }
        IDMVMContext vmc = (IDMVMContext)request.getElements()[0];
        final IProcesses.IThreadDMContext dmc = (IProcesses.IThreadDMContext)DMContexts.getAncestorOfType((IDMContext)vmc.getDMContext(), IProcesses.IThreadDMContext.class);
        this.fExecutor.submit((Runnable)new DsfCommandRunnable(this.fTracker, request.getElements()[0], request){

            public void doExecute() {
                IProcesses processesService = (IProcesses)DsfTerminateCommand.this.fTracker.getService(IProcesses.class);
                processesService.terminate(dmc, new RequestMonitor((Executor)DsfTerminateCommand.this.fExecutor, null));
            }
        });
        return false;
    }
}

