/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.debug.edc.internal.ui.AbstractEDCDetailPane;
import org.eclipse.cdt.debug.edc.internal.ui.EDCDebugUI;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.FormattedValueVMUtil;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.SyncVariableDataAccess;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class EDCVariableDetailPane
extends AbstractEDCDetailPane {
    public static final String ID = "EDCDetailPane";
    public static final String DESCRIPTION = "EDC detail pane";
    public static final String NAME = "EDC Variable Details";
    protected static final String NUMBER_FORMAT_ACTION = "setNumberFormat";
    private SetNumberFormatAction setNumberFormatAction;

    protected Job createDisplayDetailJob(IStructuredSelection selection) {
        IFormattedValues.IFormattedDataDMContext context = this.getContextFromSelection(selection);
        if (context != null) {
            return new DisplayDetailJob(context);
        }
        return null;
    }

    protected boolean canSetValue(IStructuredSelection selection) {
        IFormattedValues.IFormattedDataDMContext context = this.getContextFromSelection(selection);
        if (context != null) {
            return EDCVariableDetailPane.createSyncVariableDataAccess(context).canWriteExpression((Object)context);
        }
        return false;
    }

    protected Job createSetValueJob(IStructuredSelection selection, String newValue) {
        IFormattedValues.IFormattedDataDMContext context = this.getContextFromSelection(selection);
        if (context != null) {
            return new SetValueJob(context, newValue);
        }
        return null;
    }

    protected void createActions() {
        super.createActions();
        this.setNumberFormatAction = new SetNumberFormatAction();
        this.setAction(NUMBER_FORMAT_ACTION, (IAction)this.setNumberFormatAction);
    }

    protected void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(NUMBER_FORMAT_ACTION));
    }

    public IFormattedValues.IFormattedDataDMContext getContextFromSelection(IStructuredSelection selection) {
        Object element;
        if (selection != null && !selection.isEmpty() && (element = selection.getFirstElement()) instanceof IAdaptable) {
            return (IFormattedValues.IFormattedDataDMContext)((IAdaptable)element).getAdapter(IFormattedValues.IFormattedDataDMContext.class);
        }
        return null;
    }

    public void display(IStructuredSelection selection) {
        if (this.setNumberFormatAction != null) {
            this.setNumberFormatAction.setSelection(selection);
        }
        super.display(selection);
    }

    protected String getCurrentFormat() {
        if (this.setNumberFormatAction == null) {
            return "NATURAL.Format";
        }
        return this.setNumberFormatAction.getCurrentFormat();
    }

    public String getID() {
        return ID;
    }

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public abstract class DetailJob
    extends Job {
        protected SyncVariableDataAccess syncVariableDataAccess;

        public DetailJob(String name, IFormattedValues.IFormattedDataDMContext context) {
            super(name);
            this.syncVariableDataAccess = EDCVariableDetailPane.createSyncVariableDataAccess(context);
        }
    }

    public class DisplayDetailJob
    extends DetailJob {
        private final IFormattedValues.IFormattedDataDMContext context;

        public DisplayDetailJob(IFormattedValues.IFormattedDataDMContext context) {
            super("compute variable details", context);
            this.context = context;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                final String text = this.syncVariableDataAccess.getFormattedValue((Object)this.context, EDCVariableDetailPane.this.getCurrentFormat());
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        ((DisplayDetailJob)DisplayDetailJob.this).EDCVariableDetailPane.this.document.set(text == null ? "" : text);
                    }
                });
            }
            catch (Throwable t) {
                return EDCDebugUI.newErrorStatus(10004, "could not compute variable details", t);
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void canceling() {
            super.canceling();
            DisplayDetailJob displayDetailJob = this;
            synchronized (displayDetailJob) {
                ((Object)((Object)this)).notifyAll();
            }
        }
    }

    public class SetNumberFormatAction
    extends Action {
        public String currentFormat;
        private List<String> formatList;

        public SetNumberFormatAction() {
            super("Number Format", 4);
            this.formatList = new ArrayList<String>();
            this.setMenuCreator(new IMenuCreator(){

                public Menu getMenu(Menu parent) {
                    Menu menu = new Menu(parent);
                    menu.addMenuListener((MenuListener)new MenuAdapter(){

                        public void menuShown(MenuEvent e) {
                            this.fillMenu((Menu)e.widget);
                        }

                        private void fillMenu(Menu menu) {
                            MenuItem[] menuItemArray = menu.getItems();
                            int n = menuItemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                MenuItem item = menuItemArray[n2];
                                item.dispose();
                                ++n2;
                            }
                            for (String formatId : SetNumberFormatAction.this.formatList) {
                                SingleNumberFormatAction action = new SingleNumberFormatAction(formatId);
                                if (formatId.equals((this).SetNumberFormatAction.this.currentFormat)) {
                                    action.setChecked(true);
                                }
                                ActionContributionItem item = new ActionContributionItem((IAction)action);
                                item.fill(menu, -1);
                            }
                        }
                    });
                    return menu;
                }

                public Menu getMenu(Control parent) {
                    return null;
                }

                public void dispose() {
                }
            });
        }

        public void setSelection(IStructuredSelection selection) {
            this.formatList.clear();
            IFormattedValues.IFormattedDataDMContext context = EDCVariableDetailPane.this.getContextFromSelection(selection);
            if (context == null) {
                return;
            }
            String[] formats = EDCVariableDetailPane.createSyncVariableDataAccess(context).getSupportedFormats((Object)context);
            if (formats == null) {
                return;
            }
            this.formatList.addAll(Arrays.asList(formats));
            if (this.formatList.remove("NATURAL.Format")) {
                this.formatList.add(0, "NATURAL.Format");
            }
            if (!(this.currentFormat != null && this.formatList.contains(this.currentFormat) || this.formatList.isEmpty())) {
                this.currentFormat = this.formatList.get(0);
            }
        }

        public boolean isEnabled() {
            return !this.formatList.isEmpty();
        }

        public String getCurrentFormat() {
            if (this.currentFormat == null) {
                this.currentFormat = "NATURAL.Format";
            }
            return this.currentFormat;
        }

        private class SingleNumberFormatAction
        extends Action {
            private final String formatId;

            SingleNumberFormatAction(String formatId) {
                super(FormattedValueVMUtil.getFormatLabel((String)formatId), 8);
                this.formatId = formatId;
            }

            public void run() {
                if (this.isChecked()) {
                    SetNumberFormatAction.this.currentFormat = this.formatId;
                    if (EDCVariableDetailPane.this.isInView()) {
                        EDCVariableDetailPane.this.redisplay();
                    }
                }
            }
        }
    }

    public class SetValueJob
    extends DetailJob {
        private final IFormattedValues.IFormattedDataDMContext context;
        private final String newValue;

        public SetValueJob(IFormattedValues.IFormattedDataDMContext context, String newValue) {
            super("set variable value", context);
            this.context = context;
            this.newValue = newValue;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.syncVariableDataAccess.writeVariable((Object)this.context, this.newValue, EDCVariableDetailPane.this.getCurrentFormat());
            }
            catch (Throwable t) {
                return EDCDebugUI.newErrorStatus(10004, "set variable value", t);
            }
            return Status.OK_STATUS;
        }
    }
}

