/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.x86.disassembler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.edc.disassembler.AssemblyFormatter;
import org.eclipse.cdt.debug.edc.x86.disassembler.OpcodeX86;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssemblyFormatterX86
extends AssemblyFormatter {
    public static Map<Integer, String> sPrefixStrings = new HashMap<Integer, String>(){
        {
            this.put(240, "lock");
            this.put(243, "rep");
            this.put(242, "repnz");
            this.put(46, "%cs");
            this.put(54, "%ss");
            this.put(62, "%ds");
            this.put(38, "%es");
            this.put(100, "%gs");
            this.put(101, "%gs");
        }
    };
    public static Map<Integer, String[]> sGPRNames = new HashMap<Integer, String[]>(){
        {
            this.put(8, new String[]{"%al", "%cl", "%dl", "%bl", "%ah", "%ch", "%dh", "%bh"});
            this.put(16, new String[]{"%ax", "%cx", "%dx", "%bx", "%sp", "%bp", "%si", "%di", "%r8w", "%r9w", "%r10w", "%r11w", "%r12w", "%r13w", "%r14w", "%r15w"});
            this.put(32, new String[]{"%eax", "%ecx", "%edx", "%ebx", "%esp", "%ebp", "%esi", "%edi", "%r8d", "%r9d", "%r10d", "%r11d", "%r12d", "%r13d", "%r14d", "%r15d"});
            this.put(64, new String[]{"%rax", "%rcx", "%rdx", "%rbx", "%rsp", "%rbp", "%rsi", "%rdi", "%r8", "%r9", "%r10", "%r11", "%r12", "%r13", "%r14", "%r15"});
        }
    };
    public static String[] sSegmentRegisterNames = new String[]{"%es", "%cs", "%ss", "%ds", "%fs", "%gs"};
    public static String[] sControlRegisterNames = new String[]{"%cr0", "%cr1", "%cr2", "%cr3", "%cr4"};
    public static String[] sDebugRegisterNames = new String[]{"%db0", "%db1", "%db2", "%db3", "%db4", "%db5", "%db6", "%db7"};
    public static ArrayList<String> sInstructionsNotReverseOperand = new ArrayList();
    public static ArrayList<String> sInstructionsSuffixFromRegisterOperand = new ArrayList();
    private static final Map<String, String> sSpecialFormInstructions = new HashMap<String, String>(){
        {
            this.put("xlat", "xlat   %ds:(%ebx)");
        }
    };

    public static String format(boolean indirectAddressing, Integer displacement, int baseRegID, int indexRegID, int scale) {
        StringBuffer sb = new StringBuffer();
        if (indirectAddressing) {
            sb.append("*");
        }
        if (displacement != null) {
            sb.append(AssemblyFormatterX86.formatDisplacement((int)displacement));
        }
        if (baseRegID != -1 || indexRegID != -1) {
            sb.append('(');
        }
        if (baseRegID != -1) {
            sb.append(sGPRNames.get(32)[baseRegID]);
        }
        if (indexRegID != -1) {
            sb.append(',');
            sb.append(sGPRNames.get(32)[indexRegID]);
            if (scale >= 0) {
                sb.append(',');
                sb.append(1 << scale);
            }
        }
        if (baseRegID != -1 || indexRegID != -1) {
            sb.append(')');
        }
        return sb.toString();
    }

    public static String formatInstruction(List<Integer> prefixes, String instructionName, String instructionNameSuffix, String[] operands) {
        StringBuffer sb;
        block16: {
            if (instructionName == null) {
                throw new IllegalArgumentException();
            }
            sb = new StringBuffer();
            for (int p : prefixes) {
                assert (OpcodeX86.sPrefixesForInstruction.contains(p));
                String pstr = AssemblyFormatterX86.formatPrefix(p);
                if (p == 243 && instructionName.startsWith("cmps")) {
                    pstr = "repz";
                }
                sb.append(pstr).append(" ");
            }
            if (sSpecialFormInstructions.containsKey(instructionName)) {
                assert (operands == null);
                sb.append(sSpecialFormInstructions.get(instructionName));
            } else {
                sb.append(instructionName);
            }
            if (instructionName.endsWith("T") || instructionName.endsWith("S")) {
                sb.deleteCharAt(sb.length() - 1);
                if (instructionNameSuffix != null) {
                    sb.append(instructionNameSuffix);
                }
            }
            if (operands == null) break block16;
            int i = 0;
            while (i < 10 - instructionName.length()) {
                sb.append(' ');
                ++i;
            }
            boolean not_reverse = sInstructionsNotReverseOperand.contains(instructionName);
            if (not_reverse) {
                i = 0;
                while (i < operands.length) {
                    sb.append(operands[i]);
                    if (i + 1 < operands.length) {
                        sb.append(',');
                    }
                    ++i;
                }
            } else {
                i = operands.length - 1;
                while (i >= 0) {
                    sb.append(operands[i]);
                    if (i > 0) {
                        sb.append(',');
                    }
                    --i;
                }
            }
        }
        return sb.toString();
    }

    public static String registerPair_ESrDI(int addressMode) {
        if (addressMode == 1) {
            return "%es:(%di)";
        }
        return "%es:(%edi)";
    }

    public static String registerPair_DSrSI(int addressMode) {
        if (addressMode == 1) {
            return "%ds:(%si)";
        }
        return "%ds:(%esi)";
    }

    public static String formatPrefix(int p) {
        String ret = sPrefixStrings.get(p);
        if (ret == null) {
            ret = "";
        }
        return ret;
    }
}

