/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.eval.ast.engine;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.parser.IScannerExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.c.GCCScannerExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.cpp.GPPParserExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.cpp.ICPPParserExtensionConfiguration;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.ASTEvalMessages;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.ASTInstructionCompiler;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.InstructionSequence;
import org.eclipse.cdt.debug.edc.internal.eval.ast.engine.instructions.Interpreter;
import org.eclipse.cdt.debug.edc.services.EDCServicesTracker;
import org.eclipse.cdt.debug.edc.symbols.TypeEngine;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.GNUCPPSourceParser;
import org.eclipse.cdt.internal.core.parser.scanner.CPreprocessor;
import org.eclipse.core.runtime.CoreException;

public class ASTEvaluationEngine {
    public static final String UNKNOWN_TYPE = "<UNKNOWN>";
    private final EDCServicesTracker tracker;
    private final IDMContext context;
    private final TypeEngine typeEngine;
    private static final Map<String, InstructionSequence> compiledExpressionsCache = Collections.synchronizedMap(new HashMap());

    public ASTEvaluationEngine(EDCServicesTracker tracker, IDMContext context, TypeEngine typeEngine) {
        this.tracker = tracker;
        this.context = context;
        this.typeEngine = typeEngine;
    }

    public InstructionSequence getCompiledExpression(String expression) throws CoreException {
        InstructionSequence instructions = compiledExpressionsCache.get(expression);
        if (instructions == null) {
            FileContent reader = FileContent.create((String)"<edc-expression>", (char[])("void* dummy_func() { return " + expression + " ; }").toCharArray());
            ScannerInfo scannerInfo = new ScannerInfo();
            CPreprocessor scanner = new CPreprocessor(reader, (IScannerInfo)scannerInfo, ParserLanguage.CPP, (IParserLogService)new NullLogService(), (IScannerExtensionConfiguration)GCCScannerExtensionConfiguration.getInstance(), IncludeFileContentProvider.getEmptyFilesProvider());
            GNUCPPSourceParser parser = new GNUCPPSourceParser((IScanner)scanner, ParserMode.COMPLETE_PARSE, (IParserLogService)new NullLogService(), (ICPPParserExtensionConfiguration)GPPParserExtensionConfiguration.getInstance(), null);
            IASTTranslationUnit ast = parser.parse();
            ASTInstructionCompiler visitor = new ASTInstructionCompiler(expression);
            ast.accept((ASTVisitor)visitor);
            if (visitor.hasErrors()) {
                throw EDCDebugger.newCoreException(visitor.getErrorMessage());
            }
            instructions = visitor.getInstructions();
            instructions.removeNoOps();
            compiledExpressionsCache.put(expression, instructions);
        }
        InstructionSequence sequence = new InstructionSequence(instructions);
        sequence.reduceCasts(this.typeEngine);
        return sequence;
    }

    public Interpreter evaluateCompiledExpression(InstructionSequence expression) throws CoreException {
        Interpreter interpreter = new Interpreter(this.tracker, this.context, this.typeEngine, expression);
        interpreter.execute();
        return interpreter;
    }

    public TypeEngine getTypeEngine() {
        return this.typeEngine;
    }

    public IASTTypeId getCompiledType(String type) throws CoreException {
        FileContent reader = FileContent.create((String)"<edc-expression>", (char[])("void* dummy_func() { typeof(" + type + ") x; }").toCharArray());
        ScannerInfo scannerInfo = new ScannerInfo();
        CPreprocessor scanner = new CPreprocessor(reader, (IScannerInfo)scannerInfo, ParserLanguage.CPP, (IParserLogService)new NullLogService(), (IScannerExtensionConfiguration)GCCScannerExtensionConfiguration.getInstance(), IncludeFileContentProvider.getEmptyFilesProvider());
        GNUCPPSourceParser parser = new GNUCPPSourceParser((IScanner)scanner, ParserMode.COMPLETE_PARSE, (IParserLogService)new NullLogService(), (ICPPParserExtensionConfiguration)GPPParserExtensionConfiguration.getInstance(), null);
        IASTTranslationUnit ast = parser.parse();
        ASTTypeVisitor visitor = new ASTTypeVisitor();
        ast.accept((ASTVisitor)visitor);
        if (visitor.errorMessage != null) {
            throw EDCDebugger.newCoreException(visitor.errorMessage);
        }
        if (visitor.theType == null) {
            throw EDCDebugger.newCoreException(ASTEvalMessages.ASTEvaluationEngine_DidNotDetectType);
        }
        return visitor.theType;
    }

    private static class ASTTypeVisitor
    extends ASTVisitor {
        private IASTTypeId theType;
        private String errorMessage;

        private ASTTypeVisitor() {
            this.shouldVisitTypeIds = true;
            this.shouldVisitProblems = true;
        }

        public int visit(IASTTypeId typeId) {
            this.theType = typeId;
            return 2;
        }

        public int visit(IASTProblem problem) {
            this.errorMessage = problem.getMessage();
            return 2;
        }
    }
}

