/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.edc.internal.services.dsf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.edc.internal.EDCDebugger;
import org.eclipse.cdt.debug.edc.internal.EDCTrace;
import org.eclipse.cdt.debug.edc.internal.services.dsf.Breakpoints;
import org.eclipse.cdt.debug.edc.internal.services.dsf.MemoryCache;
import org.eclipse.cdt.debug.edc.internal.services.dsf.RunControl;
import org.eclipse.cdt.debug.edc.services.AbstractEDCService;
import org.eclipse.cdt.debug.edc.services.IDSFServiceUsingTCF;
import org.eclipse.cdt.debug.edc.services.IEDCDMContext;
import org.eclipse.cdt.debug.edc.services.IEDCExecutionDMC;
import org.eclipse.cdt.debug.edc.services.IEDCMemory;
import org.eclipse.cdt.debug.edc.snapshot.IAlbum;
import org.eclipse.cdt.debug.edc.snapshot.ISnapshotContributor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.tm.tcf.protocol.IService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Memory
extends AbstractEDCService
implements IEDCMemory,
ICachingService,
ISnapshotContributor,
IDSFServiceUsingTCF {
    private org.eclipse.tm.tcf.services.IMemory tcfMemoryService;
    private Map<String, MemoryCache> memoryCaches;
    private long tcfTimeout;
    private static final String MEMORY_CONTEXT = "memory_context";
    private static final String MEMORY = "memory";
    private static final String CONTEXT_ID = "context_id";

    public Memory(DsfSession session) {
        super(session, new String[]{IEDCMemory.class.getName(), IMemory.class.getName(), Memory.class.getName(), ISnapshotContributor.class.getName()});
        this.setTCFTimeout(15000L);
    }

    private MemoryCache getMemoryCache(IMemory.IMemoryDMContext memoryDMC) {
        assert (memoryDMC instanceof IEDCDMContext);
        MemoryCache cache = this.memoryCaches.get(((IEDCDMContext)memoryDMC).getID());
        if (cache == null) {
            cache = new MemoryCache(this.getTargetEnvironmentService().getMemoryCacheMinimumBlockSize());
            this.memoryCaches.put(((IEDCDMContext)memoryDMC).getID(), cache);
        }
        return cache;
    }

    @Override
    protected void doInitialize(RequestMonitor requestMonitor) {
        super.doInitialize(requestMonitor);
        this.memoryCaches = new HashMap<String, MemoryCache>();
        this.getSession().addServiceEventListener((Object)this, null);
    }

    public MemoryByte[] getMemory(IMemory.IMemoryDMContext context, IAddress address, long offset, int word_size, int count) throws CoreException {
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{address.toHexAddressString(), offset, word_size, count}));
        }
        if (context == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Unknown context type", null));
        }
        if (word_size < 1) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10003, "Word size not supported (< 1)", null));
        }
        if (count < 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Invalid word count (< 0)", null));
        }
        MemoryByte[] memoryBytes = this.getMemoryCache(context).getMemory(this.tcfMemoryService, context, address.add(offset), 1, count * word_size, this.getTCFTimeout());
        Breakpoints bpService = this.getService(Breakpoints.class);
        bpService.removeBreakpointFromMemoryBuffer(address.add(offset), memoryBytes);
        if (RunControl.timeStepping()) {
            System.out.println("Time since stepping start: " + (double)(System.currentTimeMillis() - RunControl.getSteppingStartTime()) / 1000.0);
        }
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null);
        }
        return memoryBytes;
    }

    @Override
    public IStatus getMemory(IEDCExecutionDMC context, IAddress address, ArrayList<MemoryByte> memBuffer, int count, int word_size) {
        try {
            MemoryByte[] memArray = this.getMemory((IMemory.IMemoryDMContext)context, address, 0L, count, word_size);
            memBuffer.addAll(Arrays.asList(memArray));
        }
        catch (CoreException coreException) {
            return new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Error reading memory from: " + address.toHexAddressString(), null);
        }
        return Status.OK_STATUS;
    }

    public void flushCache(IDMContext context) {
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{context}));
        }
        if (this.isSnapshot()) {
            return;
        }
        if (context == null) {
            for (String key : this.memoryCaches.keySet()) {
                this.memoryCaches.get(key).reset();
            }
        } else {
            IMemory.IMemoryDMContext memoryDMC = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMemory.IMemoryDMContext.class);
            if (this.memoryCaches.containsKey(((IEDCDMContext)memoryDMC).getID())) {
                this.memoryCaches.get(((IEDCDMContext)memoryDMC).getID()).reset();
            }
        }
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null);
        }
    }

    public IStatus setMemory(IMemory.IMemoryDMContext context, IAddress address, int word_size, int count, byte[] buffer) {
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{address.toHexAddressString(), count}));
        }
        final IStatus[] ret = new IStatus[]{Status.OK_STATUS};
        this.setMemory(context, address, 0L, word_size, count, buffer, new RequestMonitor(ImmediateExecutor.getInstance(), null){

            protected void handleFailure() {
                ret[0] = this.getStatus();
            }
        });
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null, (Object)EDCTrace.fixArg(ret[0]));
        }
        return ret[0];
    }

    @Override
    public void tcfServiceReady(IService service) {
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{service}));
        }
        this.tcfMemoryService = (org.eclipse.tm.tcf.services.IMemory)service;
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null);
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{e.getClass()}));
        }
        this.flushCache(e.getDMContext());
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null);
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{e.getClass()}));
        }
        if (e.getReason() != IRunControl.StateChangeReason.STEP) {
            this.flushCache(e.getDMContext());
        }
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null);
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IExpressions.IExpressionChangedDMEvent e) {
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{e.getClass()}));
        }
        final IExpressions.IExpressionDMContext context = (IExpressions.IExpressionDMContext)e.getDMContext();
        IExpressions expressionService = this.getService(IExpressions.class);
        if (expressionService != null) {
            expressionService.getExpressionAddressData(context, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMAddress>((Executor)this.getExecutor(), null){

                protected void handleSuccess() {
                    Addr64 address;
                    IExpressions.IExpressionDMAddress expression = (IExpressions.IExpressionDMAddress)this.getData();
                    int count = expression.getSize();
                    IAddress expAddress = expression.getAddress();
                    if (expAddress instanceof Addr64) {
                        address = (Addr64)expAddress;
                    } else if (expAddress instanceof IAddress) {
                        address = new Addr64(expAddress.getValue());
                    } else {
                        return;
                    }
                    IMemory.IMemoryDMContext memoryDMC = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMemory.IMemoryDMContext.class);
                    boolean modified = Memory.this.getMemoryCache(memoryDMC).refreshMemory(Memory.this.tcfMemoryService, memoryDMC, (IAddress)address, 0, 1, count, new RequestMonitor((Executor)Memory.this.getExecutor(), null), Memory.this.getTCFTimeout());
                    if (modified) {
                        IAddress[] addresses = new IAddress[count];
                        int i = 0;
                        while (i < count) {
                            addresses[i] = address.add((long)i);
                            ++i;
                        }
                        Memory.this.getSession().dispatchEvent((Object)new MemoryChangedEvent(memoryDMC, addresses), Memory.this.getProperties());
                    }
                }
            });
        }
        if (EDCTrace.MEMORY_TRACE_ON) {
            EDCTrace.getTrace().traceExit(null);
        }
    }

    @Override
    public void loadSnapshot(Element element) throws Exception {
        this.memoryCaches = new HashMap<String, MemoryCache>();
        NodeList contextElements = element.getElementsByTagName(MEMORY_CONTEXT);
        int numContexts = contextElements.getLength();
        int i = 0;
        while (i < numContexts) {
            Element contextElement = (Element)contextElements.item(i);
            String contextID = contextElement.getAttribute(CONTEXT_ID);
            MemoryCache cache = new MemoryCache(this.getTargetEnvironmentService().getMemoryCacheMinimumBlockSize());
            cache.loadSnapshot(contextElement);
            this.memoryCaches.put(contextID, cache);
            ++i;
        }
    }

    @Override
    public Element takeSnapshot(IAlbum album, Document document, IProgressMonitor monitor) {
        Element memoryElement = document.createElement(MEMORY);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.memoryCaches.keySet().size() * 1000));
        progress.subTask("Memory");
        for (String key : this.memoryCaches.keySet()) {
            MemoryCache cache = this.memoryCaches.get(key);
            Element memoryCacheElement = document.createElement(MEMORY_CONTEXT);
            memoryCacheElement.setAttribute(CONTEXT_ID, key);
            memoryCacheElement.appendChild(cache.takeSnapshot(album, document, (IProgressMonitor)progress.newChild(1000)));
            memoryElement.appendChild(memoryCacheElement);
        }
        return memoryElement;
    }

    public void setTCFTimeout(long msecs) {
        this.tcfTimeout = msecs;
    }

    public long getTCFTimeout() {
        return this.tcfTimeout;
    }

    public void fillMemory(final IMemory.IMemoryDMContext context, final IAddress address, final long offset, final int word_size, final int count, final byte[] pattern, final RequestMonitor rm) {
        this.asyncExec(new Runnable(){

            public void run() {
                if (EDCTrace.MEMORY_TRACE_ON) {
                    EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{address.toHexAddressString(), offset, word_size, count}));
                }
                if (context == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Unknown context type", null));
                    rm.done();
                    return;
                }
                if (word_size < 1) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10003, "Word size not supported (< 1)", null));
                    rm.done();
                    return;
                }
                if (count < 0) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Invalid repeat count (< 0)", null));
                    rm.done();
                    return;
                }
                if (pattern.length < 1) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Empty pattern", null));
                    rm.done();
                    return;
                }
                int length = pattern.length;
                byte[] buffer = new byte[count * length];
                int i = 0;
                while (i < count) {
                    System.arraycopy(pattern, 0, buffer, i * length, length);
                    ++i;
                }
                try {
                    Memory.this.getMemoryCache(context).setMemory(Memory.this.tcfMemoryService, context, address, offset, 1, count * length * word_size, buffer, Memory.this.getTCFTimeout());
                }
                catch (CoreException e) {
                    EDCDebugger.getMessageLogger().log(e.getStatus());
                    rm.setStatus(e.getStatus());
                }
                rm.done();
                if (EDCTrace.MEMORY_TRACE_ON) {
                    EDCTrace.getTrace().traceExit(null);
                }
            }
        }, rm);
    }

    public void getMemory(final IMemory.IMemoryDMContext context, final IAddress address, final long offset, final int word_size, final int count, final DataRequestMonitor<MemoryByte[]> drm) {
        this.asyncExec(new Runnable(){

            public void run() {
                if (EDCTrace.MEMORY_TRACE_ON) {
                    EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{address.toHexAddressString(), offset, word_size, count}));
                }
                try {
                    MemoryByte[] memoryBytes = Memory.this.getMemory(context, address, offset, word_size, count);
                    drm.setData((Object)memoryBytes);
                }
                catch (CoreException e) {
                    EDCDebugger.getMessageLogger().log(e.getStatus());
                    drm.setStatus(e.getStatus());
                }
                drm.done();
                if (EDCTrace.MEMORY_TRACE_ON) {
                    EDCTrace.getTrace().traceExit(null);
                }
            }
        }, (RequestMonitor)drm);
    }

    public void setMemory(final IMemory.IMemoryDMContext context, final IAddress address, final long offset, final int word_size, final int count, final byte[] buffer, final RequestMonitor rm) {
        this.asyncExec(new Runnable(){

            public void run() {
                if (EDCTrace.MEMORY_TRACE_ON) {
                    EDCTrace.getTrace().traceEntry(null, (Object[])EDCTrace.fixArgs(new Object[]{address.toHexAddressString(), offset, word_size, count}));
                }
                if (context == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Unknown context type", null));
                    rm.done();
                    return;
                }
                if (word_size != 1) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10003, "Word size not supported (!= 1)", null));
                    rm.done();
                    return;
                }
                if (count < 0) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Invalid word count (< 0)", null));
                    rm.done();
                    return;
                }
                if (buffer.length < count) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.debug.edc", 10005, "Buffer too short", null));
                    rm.done();
                    return;
                }
                try {
                    Memory.this.getMemoryCache(context).setMemory(Memory.this.tcfMemoryService, context, address, offset, word_size, count, buffer, Memory.this.getTCFTimeout());
                    if (rm.isSuccess()) {
                        IAddress[] addresses = new IAddress[count];
                        int i = 0;
                        while (i < count) {
                            addresses[i] = address.add(offset + (long)i);
                            ++i;
                        }
                        Memory.this.getSession().dispatchEvent((Object)new MemoryChangedEvent(context, addresses), Memory.this.getProperties());
                    }
                }
                catch (CoreException e) {
                    EDCDebugger.getMessageLogger().log(e.getStatus());
                    rm.setStatus(e.getStatus());
                }
                rm.done();
                if (EDCTrace.MEMORY_TRACE_ON) {
                    EDCTrace.getTrace().traceExit(null);
                }
            }
        }, rm);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MemoryChangedEvent
    extends AbstractDMEvent<IMemory.IMemoryDMContext>
    implements IMemory.IMemoryChangedEvent {
        IAddress[] addresses;

        public MemoryChangedEvent(IMemory.IMemoryDMContext context, IAddress[] addresses) {
            super((IDMContext)context);
            this.addresses = addresses;
        }

        public IAddress[] getAddresses() {
            return this.addresses;
        }
    }
}

