/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.gnu.cygwin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.cdt.managedbuilder.core.IManagedIsToolChainSupported;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.gnu.cygwin.CygwinPathResolver;
import org.osgi.framework.Version;

public class IsGnuCygwinToolChainSupported
implements IManagedIsToolChainSupported {
    static final String[] CHECKED_NAMES = new String[]{"gcc", "binutils", "make"};
    static boolean suppChecked = false;
    static boolean toolchainIsSupported = false;

    public boolean isSupported(IToolChain toolChain, Version version, String instance) {
        if (suppChecked) {
            return toolchainIsSupported;
        }
        String etcCygwin = CygwinPathResolver.getEtcPath();
        if (etcCygwin != null) {
            toolchainIsSupported = this.arePackagesInstalled(etcCygwin);
        }
        suppChecked = true;
        return toolchainIsSupported;
    }

    private boolean arePackagesInstalled(String etcCygwin) {
        boolean arePackagesInstalled = false;
        File file = new File(String.valueOf(etcCygwin) + "/setup/installed.db");
        try {
            int j;
            String s;
            BufferedReader data = new BufferedReader(new FileReader(file));
            boolean[] found = new boolean[CHECKED_NAMES.length];
            while ((s = data.readLine()) != null) {
                j = 0;
                while (j < CHECKED_NAMES.length) {
                    if (s.startsWith(CHECKED_NAMES[j])) {
                        found[j] = true;
                    }
                    ++j;
                }
            }
            arePackagesInstalled = true;
            j = 0;
            while (j < CHECKED_NAMES.length) {
                arePackagesInstalled &= found[j];
                ++j;
            }
            data.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
        return arePackagesInstalled;
    }
}

