/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.gettersandsetters;

import java.util.Arrays;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTBinaryExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompoundStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTExpressionStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTLiteralExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTParameterDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTReturnStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclaration;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.GetterSetterNameGenerator;

public class FunctionFactory {
    public static IASTFunctionDefinition createGetterDefinition(IASTName fieldName, IASTSimpleDeclaration fieldDeclaration, ICPPASTQualifiedName name) {
        CPPASTFunctionDefinition getter = new CPPASTFunctionDefinition();
        getter.setDeclSpecifier(fieldDeclaration.getDeclSpecifier().copy(IASTNode.CopyStyle.withLocations));
        IASTDeclarator getterDeclarator = FunctionFactory.getGetterDeclarator(fieldName, fieldDeclaration, name);
        while (!(getterDeclarator instanceof IASTFunctionDeclarator)) {
            getterDeclarator = getterDeclarator.getNestedDeclarator();
        }
        getter.setDeclarator((IASTFunctionDeclarator)getterDeclarator);
        getter.setBody((IASTStatement)FunctionFactory.getGetterBody(fieldName));
        return getter;
    }

    private static CPPASTCompoundStatement getGetterBody(IASTName fieldName) {
        CPPASTCompoundStatement compound = new CPPASTCompoundStatement();
        CPPASTReturnStatement returnStatement = new CPPASTReturnStatement();
        CPPASTIdExpression idExpr = new CPPASTIdExpression();
        CPPASTName returnVal = new CPPASTName();
        returnVal.setName(fieldName.toCharArray());
        idExpr.setName((IASTName)returnVal);
        returnStatement.setReturnValue((IASTExpression)idExpr);
        compound.addStatement((IASTStatement)returnStatement);
        return compound;
    }

    private static IASTDeclarator getGetterDeclarator(IASTName fieldName, IASTSimpleDeclaration fieldDeclaration, ICPPASTQualifiedName name) {
        IASTDeclarator topDeclarator;
        CPPASTName getterName = new CPPASTName();
        getterName.setName(GetterSetterNameGenerator.generateGetterName(fieldName).toCharArray());
        IASTDeclarator innermost = topDeclarator = fieldDeclaration.getDeclarators()[0].copy(IASTNode.CopyStyle.withLocations);
        while (innermost.getNestedDeclarator() != null) {
            innermost = innermost.getNestedDeclarator();
        }
        CPPASTFunctionDeclarator functionDeclarator = new CPPASTFunctionDeclarator();
        functionDeclarator.setConst(true);
        if (name != null) {
            name.addName((IASTName)getterName);
            functionDeclarator.setName((IASTName)name);
        } else {
            functionDeclarator.setName((IASTName)getterName);
        }
        IASTPointerOperator[] iASTPointerOperatorArray = innermost.getPointerOperators();
        int n = iASTPointerOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPointerOperator pointer = iASTPointerOperatorArray[n2];
            functionDeclarator.addPointerOperator(pointer.copy(IASTNode.CopyStyle.withLocations));
            ++n2;
        }
        if (innermost == topDeclarator) {
            return functionDeclarator;
        }
        IASTDeclarator parent = (IASTDeclarator)innermost.getParent();
        parent.setNestedDeclarator((IASTDeclarator)functionDeclarator);
        return topDeclarator;
    }

    public static IASTFunctionDefinition createSetterDefinition(IASTName fieldName, IASTSimpleDeclaration fieldDeclaration, ICPPASTQualifiedName name) {
        CPPASTFunctionDefinition setter = new CPPASTFunctionDefinition();
        setter.setDeclSpecifier((IASTDeclSpecifier)FunctionFactory.getVoidDeclSpec());
        setter.setDeclarator((IASTFunctionDeclarator)FunctionFactory.getSetterDeclarator(fieldName, fieldDeclaration, name));
        setter.setBody((IASTStatement)FunctionFactory.getSetterBody(fieldDeclaration));
        return setter;
    }

    private static CPPASTCompoundStatement getSetterBody(IASTSimpleDeclaration fieldDeclaration) {
        CPPASTIdExpression idExpr;
        CPPASTCompoundStatement compound = new CPPASTCompoundStatement();
        CPPASTExpressionStatement exprStmt = new CPPASTExpressionStatement();
        CPPASTBinaryExpression binExpr = new CPPASTBinaryExpression();
        IASTDeclarator innerDeclarator = fieldDeclaration.getDeclarators()[0];
        while (innerDeclarator.getNestedDeclarator() != null) {
            innerDeclarator = innerDeclarator.getNestedDeclarator();
        }
        IASTName fieldName = innerDeclarator.getName();
        CPPASTName parameterName = FunctionFactory.getSetterParameterName(fieldName);
        if (Arrays.equals(fieldName.getSimpleID(), parameterName.getSimpleID())) {
            CPPASTFieldReference fieldRef = new CPPASTFieldReference();
            CPPASTLiteralExpression litExpr = new CPPASTLiteralExpression();
            litExpr.setValue(Keywords.cTHIS);
            fieldRef.setFieldOwner((IASTExpression)litExpr);
            fieldRef.setIsPointerDereference(true);
            fieldRef.setFieldName(fieldName.copy(IASTNode.CopyStyle.withLocations));
            binExpr.setOperand1((IASTExpression)fieldRef);
        } else {
            idExpr = new CPPASTIdExpression(fieldName.copy(IASTNode.CopyStyle.withLocations));
            binExpr.setOperand1((IASTExpression)idExpr);
        }
        binExpr.setOperator(17);
        idExpr = new CPPASTIdExpression((IASTName)parameterName);
        binExpr.setOperand2((IASTExpression)idExpr);
        exprStmt.setExpression((IASTExpression)binExpr);
        compound.addStatement((IASTStatement)exprStmt);
        return compound;
    }

    private static CPPASTFunctionDeclarator getSetterDeclarator(IASTName fieldName, IASTSimpleDeclaration fieldDeclaration, ICPPASTQualifiedName name) {
        CPPASTName setterName = new CPPASTName();
        setterName.setName(GetterSetterNameGenerator.generateSetterName(fieldName).toCharArray());
        CPPASTFunctionDeclarator declarator = new CPPASTFunctionDeclarator();
        if (name != null) {
            name.addName((IASTName)setterName);
            declarator.setName((IASTName)name);
        } else {
            declarator.setName((IASTName)setterName);
        }
        CPPASTParameterDeclaration parameterDeclaration = new CPPASTParameterDeclaration();
        IASTDeclarator parameterDeclarator = fieldDeclaration.getDeclarators()[0].copy(IASTNode.CopyStyle.withLocations);
        parameterDeclarator.setName((IASTName)FunctionFactory.getSetterParameterName(fieldName));
        parameterDeclaration.setDeclarator(parameterDeclarator);
        parameterDeclaration.setDeclSpecifier(fieldDeclaration.getDeclSpecifier().copy(IASTNode.CopyStyle.withLocations));
        declarator.addParameterDeclaration((IASTParameterDeclaration)parameterDeclaration.copy(IASTNode.CopyStyle.withLocations));
        return declarator;
    }

    private static CPPASTName getSetterParameterName(IASTName fieldName) {
        String parameterName = GetterSetterNameGenerator.generateSetterParameterName(fieldName);
        return new CPPASTName(parameterName.toCharArray());
    }

    private static CPPASTSimpleDeclSpecifier getVoidDeclSpec() {
        CPPASTSimpleDeclSpecifier declSpecifier = new CPPASTSimpleDeclSpecifier();
        declSpecifier.setType(1);
        return declSpecifier;
    }

    public static IASTSimpleDeclaration createGetterDeclaration(IASTName fieldName, IASTSimpleDeclaration fieldDeclaration) {
        CPPASTSimpleDeclaration getter = new CPPASTSimpleDeclaration();
        getter.setDeclSpecifier(fieldDeclaration.getDeclSpecifier().copy(IASTNode.CopyStyle.withLocations));
        getter.addDeclarator(FunctionFactory.getGetterDeclarator(fieldName, fieldDeclaration, null));
        return getter;
    }

    public static IASTSimpleDeclaration createSetterDeclaration(IASTName fieldName, IASTSimpleDeclaration fieldDeclaration) {
        CPPASTSimpleDeclaration setter = new CPPASTSimpleDeclaration();
        setter.setDeclSpecifier((IASTDeclSpecifier)FunctionFactory.getVoidDeclSpec());
        setter.addDeclarator((IASTDeclarator)FunctionFactory.getSetterDeclarator(fieldName, fieldDeclaration, null));
        return setter;
    }
}

