/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.cdt.ui.disassembly;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.DisassemblyUtils;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.ErrorPosition;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.IDisassemblyBackend;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.IDisassemblyPartCallback;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.internal.tcf.cdt.ui.Activator;
import org.eclipse.tm.internal.tcf.debug.model.TCFContextState;
import org.eclipse.tm.internal.tcf.debug.model.TCFSourceRef;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.IDisassembly;
import org.eclipse.tm.tcf.services.IExpressions;
import org.eclipse.tm.tcf.services.ILineNumbers;
import org.eclipse.tm.tcf.services.IMemory;
import org.eclipse.tm.tcf.services.IRunControl;
import org.eclipse.tm.tcf.services.ISymbols;
import org.eclipse.tm.tcf.util.TCFDataCache;
import org.eclipse.tm.tcf.util.TCFTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFDisassemblyBackend
implements IDisassemblyBackend {
    private IDisassemblyPartCallback fCallback;
    private volatile TCFNodeExecContext fExecContext;
    private volatile TCFNodeStackFrame fActiveFrame;
    private volatile BigInteger fSuspendAddress;
    private volatile int fSuspendCount;
    private final IRunControl.RunControlListener fRunControlListener = new TCFRunControlListener();
    private final IChannel.IChannelListener fChannelListener = new TCFChannelListener();
    private final ILaunchesListener fLaunchesListener = new TCFLaunchListener();

    public void init(IDisassemblyPartCallback callback) {
        this.fCallback = callback;
    }

    public boolean supportsDebugContext(IAdaptable context) {
        return (context instanceof TCFNodeExecContext || context instanceof TCFNodeStackFrame) && this.hasDisassemblyService((TCFNode)context);
    }

    private boolean hasDisassemblyService(final TCFNode context) {
        Boolean hasService = (Boolean)new TCFTask<Boolean>(){

            public void run() {
                IDisassembly disass = null;
                IChannel channel = context.getChannel();
                if (channel != null && channel.getState() != 2) {
                    disass = (IDisassembly)channel.getRemoteService(IDisassembly.class);
                }
                this.done(disass != null);
            }
        }.getE();
        return hasService != null && hasService != false;
    }

    public boolean hasDebugContext() {
        return this.fExecContext != null;
    }

    public IDisassemblyBackend.SetDebugContextResult setDebugContext(IAdaptable context) {
        TCFNodeExecContext oldContext;
        TCFNodeExecContext newContext = null;
        TCFNodeStackFrame frame = null;
        IDisassemblyBackend.SetDebugContextResult result = new IDisassemblyBackend.SetDebugContextResult();
        if (context instanceof TCFNodeExecContext) {
            newContext = (TCFNodeExecContext)context;
            final TCFNodeExecContext _execContext = newContext;
            frame = (TCFNodeStackFrame)new TCFTask<TCFNodeStackFrame>(_execContext.getChannel()){

                public void run() {
                    TCFChildrenStackTrace stack = _execContext.getStackTrace();
                    if (!stack.validate((Runnable)((Object)this))) {
                        return;
                    }
                    this.done(stack.getTopFrame());
                }
            }.getE();
            if (frame == null) {
                newContext = null;
            }
        } else if (context instanceof TCFNodeStackFrame) {
            final TCFNodeStackFrame _frame = frame = (TCFNodeStackFrame)context;
            newContext = (TCFNodeExecContext)new TCFTask<TCFNodeExecContext>(_frame.getChannel()){

                public void run() {
                    TCFNode parent = _frame.getParent();
                    if (parent instanceof TCFNodeExecContext) {
                        this.done((TCFNodeExecContext)parent);
                    } else {
                        this.done(null);
                    }
                }
            }.getE();
        }
        if ((oldContext = this.fExecContext) == null || newContext == null || oldContext.compareTo((TCFNode)newContext) != 0) {
            result.contextChanged = true;
            ++this.fSuspendCount;
            if (oldContext != null) {
                this.removeListeners(oldContext);
            }
        }
        this.fExecContext = newContext;
        if (newContext != null && result.contextChanged) {
            this.addListeners(newContext);
        }
        this.fActiveFrame = frame;
        String string = result.sessionId = newContext != null ? newContext.getID() : null;
        if (!result.contextChanged && this.fActiveFrame != null) {
            this.fCallback.asyncExec(new Runnable(){

                public void run() {
                    TCFDisassemblyBackend.this.fCallback.gotoFrameIfActive(TCFDisassemblyBackend.this.getFrameLevel());
                }
            });
        }
        return result;
    }

    private void addListeners(final TCFNodeExecContext context) {
        assert (context != null);
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                IChannel channel = context.getChannel();
                IRunControl rctl = (IRunControl)channel.getRemoteService(IRunControl.class);
                if (rctl != null) {
                    rctl.addListener(TCFDisassemblyBackend.this.fRunControlListener);
                }
                channel.addChannelListener(TCFDisassemblyBackend.this.fChannelListener);
            }
        });
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(this.fLaunchesListener);
    }

    private void removeListeners(final TCFNodeExecContext context) {
        assert (context != null);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener(this.fLaunchesListener);
        Protocol.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                IChannel channel = context.getChannel();
                IRunControl rctl = (IRunControl)channel.getRemoteService(IRunControl.class);
                if (rctl != null) {
                    rctl.removeListener(TCFDisassemblyBackend.this.fRunControlListener);
                }
                channel.removeChannelListener(TCFDisassemblyBackend.this.fChannelListener);
            }
        });
    }

    private void handleContextSuspended(BigInteger pc) {
        ++this.fSuspendCount;
        this.fSuspendAddress = pc;
        this.fCallback.handleTargetSuspended();
    }

    private void handleSessionEnded() {
        this.clearDebugContext();
        this.fCallback.handleTargetEnded();
    }

    public void clearDebugContext() {
        if (this.fExecContext != null) {
            this.removeListeners(this.fExecContext);
        }
        this.fExecContext = null;
        this.fActiveFrame = null;
    }

    public void retrieveFrameAddress(final int targetFrame) {
        BigInteger address;
        final TCFNodeExecContext execContext = this.fExecContext;
        if (execContext == null) {
            this.fCallback.setUpdatePending(false);
            return;
        }
        if (targetFrame == 0 && this.fSuspendAddress != null) {
            address = this.fSuspendAddress;
            this.fSuspendAddress = null;
        } else {
            final int suspendCount = this.fSuspendCount;
            final TCFChildrenStackTrace stack = execContext.getStackTrace();
            address = (BigInteger)new TCFTask<BigInteger>(execContext.getChannel()){

                public void run() {
                    if (suspendCount != TCFDisassemblyBackend.this.fSuspendCount || execContext != TCFDisassemblyBackend.this.fExecContext) {
                        this.done(null);
                        return;
                    }
                    if (!stack.validate((Runnable)((Object)this))) {
                        return;
                    }
                    TCFNodeStackFrame frame = null;
                    if (targetFrame == 0) {
                        frame = stack.getTopFrame();
                    } else {
                        Map frameData = (Map)stack.getData();
                        for (TCFNode node : frameData.values()) {
                            TCFNodeStackFrame cand;
                            if (!(node instanceof TCFNodeStackFrame) || (cand = (TCFNodeStackFrame)node).getFrameNo() != targetFrame) continue;
                            frame = cand;
                            break;
                        }
                    }
                    if (frame != null) {
                        TCFDataCache addressCache = frame.getAddress();
                        if (!addressCache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        this.done((BigInteger)addressCache.getData());
                        return;
                    }
                    this.done(null);
                }
            }.getE();
        }
        if (execContext == this.fExecContext) {
            this.fCallback.setUpdatePending(false);
            if (address != null) {
                if (targetFrame == 0) {
                    this.fCallback.updatePC(address);
                } else {
                    this.fCallback.gotoFrame(targetFrame, address);
                }
            }
        }
    }

    public int getFrameLevel() {
        if (this.fActiveFrame == null) {
            return -1;
        }
        Integer level = (Integer)new TCFTask<Integer>(){

            public void run() {
                this.done(TCFDisassemblyBackend.this.fActiveFrame != null ? TCFDisassemblyBackend.this.fActiveFrame.getFrameNo() : -1);
            }
        }.getE();
        return level != null ? level : -1;
    }

    public boolean isSuspended() {
        if (this.fExecContext == null) {
            return false;
        }
        Boolean suspended = (Boolean)new TCFTask<Boolean>(this.fExecContext.getChannel()){

            public void run() {
                if (TCFDisassemblyBackend.this.fExecContext == null) {
                    this.done(null);
                    return;
                }
                TCFDataCache stateCache = TCFDisassemblyBackend.this.fExecContext.getState();
                if (!stateCache.validate((Runnable)((Object)this))) {
                    return;
                }
                TCFContextState state = (TCFContextState)stateCache.getData();
                if (state != null) {
                    this.done(state.is_suspended);
                    return;
                }
                this.done(null);
            }
        }.getE();
        return suspended != null ? suspended : false;
    }

    public boolean hasFrameContext() {
        return this.fActiveFrame != null;
    }

    public String getFrameFile() {
        final TCFNodeStackFrame frame = this.fActiveFrame;
        if (frame == null) {
            return null;
        }
        String file = (String)new TCFTask<String>(frame.getChannel()){

            public void run() {
                if (frame != TCFDisassemblyBackend.this.fActiveFrame) {
                    this.done(null);
                    return;
                }
                TCFDataCache sourceRefCache = frame.getLineInfo();
                if (!sourceRefCache.validate((Runnable)((Object)this))) {
                    return;
                }
                TCFSourceRef sourceRef = (TCFSourceRef)sourceRefCache.getData();
                String file = sourceRef.area.file;
                if (file != null) {
                    String dir;
                    Path filePath = new Path(file);
                    if (!filePath.isAbsolute() && (dir = sourceRef.area.directory) != null) {
                        filePath = new Path(dir).append((IPath)filePath);
                    }
                    this.done(filePath.toString());
                }
                this.done(null);
            }
        }.getE();
        return file;
    }

    public int getFrameLine() {
        final TCFNodeStackFrame frame = this.fActiveFrame;
        if (frame == null) {
            return -1;
        }
        Integer line = (Integer)new TCFTask<Integer>(frame.getChannel()){

            public void run() {
                if (frame != TCFDisassemblyBackend.this.fActiveFrame) {
                    this.done(null);
                    return;
                }
                TCFDataCache sourceRefCache = frame.getLineInfo();
                if (!sourceRefCache.validate((Runnable)((Object)this))) {
                    return;
                }
                TCFSourceRef sourceRef = (TCFSourceRef)sourceRefCache.getData();
                this.done(sourceRef.area.start_line);
            }
        }.getE();
        return line != null ? line : -1;
    }

    public void retrieveDisassembly(final BigInteger startAddress, BigInteger endAddress, String file, int lineNumber, int lines, final boolean mixed, final boolean showSymbols, boolean showDisassembly, final int linesHint) {
        final TCFNodeExecContext execContext = this.fExecContext;
        if (execContext == null || execContext.isDisposed()) {
            this.fCallback.setUpdatePending(false);
            return;
        }
        final int suspendCount = this.fSuspendCount;
        final long modCount = this.getModCount();
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                if (execContext != TCFDisassemblyBackend.this.fExecContext) {
                    return;
                }
                if (suspendCount != TCFDisassemblyBackend.this.fSuspendCount) {
                    TCFDisassemblyBackend.this.fCallback.setUpdatePending(false);
                    return;
                }
                final IChannel channel = execContext.getChannel();
                IDisassembly disass = (IDisassembly)channel.getRemoteService(IDisassembly.class);
                if (disass == null) {
                    TCFDisassemblyBackend.this.fCallback.setUpdatePending(false);
                    return;
                }
                TCFDataCache mem_node_cache = execContext.getModel().searchMemoryContext((TCFNode)execContext);
                if (!mem_node_cache.validate((Runnable)this)) {
                    return;
                }
                TCFNodeExecContext memContext = (TCFNodeExecContext)mem_node_cache.getData();
                if (memContext == null) {
                    TCFDisassemblyBackend.this.fCallback.setUpdatePending(false);
                    return;
                }
                TCFDataCache cache = memContext.getMemoryContext();
                if (!cache.validate((Runnable)this)) {
                    return;
                }
                IMemory.MemoryContext mem = (IMemory.MemoryContext)cache.getData();
                if (mem == null) {
                    TCFDisassemblyBackend.this.fCallback.setUpdatePending(false);
                    return;
                }
                final String contextId = mem.getID();
                HashMap params = new HashMap();
                disass.disassemble(contextId, (Number)startAddress, linesHint * 4, params, new IDisassembly.DoneDisassemble(){

                    public void doneDisassemble(IToken token, final Throwable error, IDisassembly.IDisassemblyLine[] disassembly) {
                        if (execContext != TCFDisassemblyBackend.this.fExecContext) {
                            return;
                        }
                        if (error != null) {
                            TCFDisassemblyBackend.this.fCallback.asyncExec(new Runnable(){

                                public void run() {
                                    if (execContext != TCFDisassemblyBackend.this.fExecContext) {
                                        return;
                                    }
                                    if (modCount == TCFDisassemblyBackend.this.getModCount()) {
                                        TCFDisassemblyBackend.this.fCallback.insertError(startAddress, TCFModel.getErrorMessage((Throwable)error, (boolean)false));
                                        TCFDisassemblyBackend.this.fCallback.setUpdatePending(false);
                                    }
                                }
                            });
                            return;
                        }
                        this.doneGetDisassembly(disassembly);
                    }

                    private void doneGetDisassembly(final IDisassembly.IDisassemblyLine[] disassembly) {
                        if (!showSymbols) {
                            this.doneGetSymbols(disassembly, null);
                            return;
                        }
                        final ISymbols symbols = (ISymbols)channel.getRemoteService(ISymbols.class);
                        if (symbols == null) {
                            this.doneGetSymbols(disassembly, null);
                            return;
                        }
                        final ArrayList symbolList = new ArrayList();
                        final int[] idx = new int[1];
                        IDisassembly.IDisassemblyLine line = disassembly[idx[0]];
                        Number address = line.getAddress();
                        symbols.findByAddr(contextId, address, new ISymbols.DoneFind(){
                            ISymbols.DoneFind doneFind = this;

                            public void doneFind(IToken token, Exception error, String symbol_id) {
                                if (error == null && symbol_id != null) {
                                    symbols.getContext(symbol_id, new ISymbols.DoneGetContext(){

                                        public void doneGetContext(IToken token, Exception error, ISymbols.Symbol context) {
                                            BigInteger nextAddress = null;
                                            if (error == null && context != null && context.getTypeClass().equals((Object)ISymbols.TypeClass.function)) {
                                                symbolList.add(context);
                                                nextAddress = TCFDisassemblyBackend.toBigInteger(context.getAddress()).add(BigInteger.valueOf(context.getSize()));
                                            }
                                            this.findNextSymbol(nextAddress);
                                        }
                                    });
                                    return;
                                }
                                this.findNextSymbol(null);
                            }

                            private void findNextSymbol(BigInteger nextAddress) {
                                while ((idx[0] = idx[0] + 1) < disassembly.length) {
                                    BigInteger instrAddress = TCFDisassemblyBackend.toBigInteger(disassembly[idx[0]].getAddress());
                                    if (nextAddress == null) {
                                        nextAddress = instrAddress;
                                    } else if (instrAddress.compareTo(nextAddress) < 0) continue;
                                    symbols.findByAddr(contextId, (Number)instrAddress, this.doneFind);
                                    return;
                                }
                                ISymbols.Symbol[] functionSymbols = symbolList.toArray(new ISymbols.Symbol[symbolList.size()]);
                                this.doneGetSymbols(disassembly, functionSymbols);
                            }
                        });
                    }

                    private void doneGetSymbols(final IDisassembly.IDisassemblyLine[] disassembly, final ISymbols.Symbol[] symbols) {
                        ILineNumbers lineNumbers = null;
                        if (mixed) {
                            lineNumbers = (ILineNumbers)channel.getRemoteService(ILineNumbers.class);
                        }
                        if (lineNumbers == null) {
                            this.doneGetLineNumbers(disassembly, symbols, null);
                        } else {
                            AddressRange range = this.getAddressRange(disassembly);
                            lineNumbers.mapToSource(contextId, (Number)range.start, (Number)range.end, new ILineNumbers.DoneMapToSource(){

                                public void doneMapToSource(IToken token, Exception error, ILineNumbers.CodeArea[] areas) {
                                    if (error != null) {
                                        Activator.log(error);
                                        this.doneGetLineNumbers(disassembly, symbols, null);
                                    } else {
                                        this.doneGetLineNumbers(disassembly, symbols, areas);
                                    }
                                }
                            });
                        }
                    }

                    private void doneGetLineNumbers(final IDisassembly.IDisassemblyLine[] disassembly, final ISymbols.Symbol[] symbols, final ILineNumbers.CodeArea[] areas) {
                        TCFDisassemblyBackend.this.fCallback.asyncExec(new Runnable(){

                            public void run() {
                                TCFDisassemblyBackend.this.insertDisassembly(modCount, startAddress, disassembly, symbols, areas);
                            }
                        });
                    }

                    private AddressRange getAddressRange(IDisassembly.IDisassemblyLine[] lines) {
                        AddressRange range = new AddressRange();
                        range.start = TCFDisassemblyBackend.toBigInteger(lines[0].getAddress());
                        IDisassembly.IDisassemblyLine lastLine = lines[lines.length - 1];
                        range.end = TCFDisassemblyBackend.toBigInteger(lastLine.getAddress()).add(BigInteger.valueOf(lastLine.getSize()));
                        return range;
                    }
                });
            }
        });
    }

    private long getModCount() {
        return ((IDocumentExtension4)this.fCallback.getDocument()).getModificationStamp();
    }

    /*
     * Unable to fully structure code
     */
    protected final void insertDisassembly(long modCount, BigInteger startAddress, IDisassembly.IDisassemblyLine[] instructions, ISymbols.Symbol[] symbols, ILineNumbers.CodeArea[] codeAreas) {
        if (!this.fCallback.hasViewer() || this.fExecContext == null) {
            return;
        }
        if (modCount != this.getModCount()) {
            return;
        }
        if (DisassemblyUtils.DEBUG) {
            System.out.println("insertDisassembly " + DisassemblyUtils.getAddressText((BigInteger)startAddress));
        }
        updatePending = this.fCallback.getUpdatePending();
        if (!TCFDisassemblyBackend.$assertionsDisabled && !updatePending) {
            throw new AssertionError();
        }
        if (!updatePending) {
            return;
        }
        insertedAnyAddress = false;
        try {
            this.fCallback.lockScroller();
            p = null;
            var13_10 = instructions;
            var12_11 = instructions.length;
            var11_12 = 0;
            while (var11_12 < var12_11) {
                block29: {
                    instruction = var13_10[var11_12];
                    address = instruction.getAddress() instanceof BigInteger != false ? (BigInteger)instruction.getAddress() : BigInteger.valueOf(instruction.getAddress().longValue());
                    if (startAddress == null) {
                        startAddress = address;
                        this.fCallback.setGotoAddressPending(address);
                    }
                    if (p == null || !p.containsAddress(address)) {
                        p = this.fCallback.getPositionOfAddress(address);
                    }
                    if (!(p instanceof ErrorPosition) || !p.fValid) break block29;
                    p.fValid = false;
                    this.fCallback.getDocument().addInvalidAddressRange(p);
                    ** GOTO lbl-1000
                }
                if (p == null) {
                    if (DisassemblyUtils.DEBUG) {
                        System.out.println("Excess disassembly lines at " + DisassemblyUtils.getAddressText((BigInteger)address));
                    }
                    return;
                }
                try {
                    if (p.fValid) {
                        if (DisassemblyUtils.DEBUG) {
                            System.out.println("Excess disassembly lines at " + DisassemblyUtils.getAddressText((BigInteger)address));
                        }
                    } else lbl-1000:
                    // 2 sources

                    {
                        sourceFile = null;
                        firstLine = -1;
                        lastLine = -1;
                        area = this.findCodeArea(address, codeAreas);
                        if (area != null && area.file != null) {
                            filePath = new Path(area.file);
                            if (!filePath.isAbsolute() && area.directory != null) {
                                filePath = new Path(area.directory).append((IPath)filePath);
                            }
                            sourceFile = filePath.toString();
                            firstLine = area.start_line - 1;
                            lastLine = area.end_line - 2;
                        }
                        if (sourceFile != null && firstLine >= 0) {
                            try {
                                p = this.fCallback.insertSource(p, address, sourceFile, firstLine, lastLine);
                            }
                            catch (NoSuchMethodError v0) {
                                p = this.fCallback.insertSource(p, address, sourceFile, firstLine);
                            }
                        }
                        functionOffset = this.getFunctionOffset(address, symbols);
                        if (functionOffset.name != null && functionOffset.isZeroOffset()) {
                            p = this.fCallback.getDocument().insertLabel(p, address, functionOffset.name, true);
                        }
                        instrLength = instruction.getSize();
                        instrAttrs = instruction.getInstruction();
                        instr = this.formatInstruction(instrAttrs);
                        p = this.fCallback.getDocument().insertDisassemblyLine(p, address, instrLength, functionOffset.toString(), instr, sourceFile, firstLine);
                        if (p == null) {
                            break;
                        }
                        insertedAnyAddress = true;
                    }
                    ++var11_12;
                    continue;
                }
                catch (BadLocationException e) {
                    DisassemblyUtils.internalError((Throwable)e);
                }
                break;
            }
        }
        finally {
            this.fCallback.setUpdatePending(false);
            if (insertedAnyAddress) {
                this.fCallback.updateInvalidSource();
                this.fCallback.unlockScroller();
                this.fCallback.doPending();
                this.fCallback.updateVisibleArea();
            } else {
                this.fCallback.unlockScroller();
            }
        }
    }

    private FunctionOffset getFunctionOffset(BigInteger address, ISymbols.Symbol[] symbols) {
        if (symbols != null) {
            ISymbols.Symbol[] symbolArray = symbols;
            int n = symbols.length;
            int n2 = 0;
            while (n2 < n) {
                ISymbols.Symbol symbol = symbolArray[n2];
                BigInteger symbolAddress = TCFDisassemblyBackend.toBigInteger(symbol.getAddress());
                BigInteger offset = address.subtract(symbolAddress);
                switch (offset.compareTo(BigInteger.ZERO)) {
                    case 0: {
                        return new FunctionOffset(symbol.getName(), BigInteger.ZERO);
                    }
                    case 1: {
                        if (offset.compareTo(BigInteger.valueOf(symbol.getSize())) >= 0) break;
                        return new FunctionOffset(symbol.getName(), offset);
                    }
                }
                ++n2;
            }
        }
        return FunctionOffset.NONE;
    }

    private ILineNumbers.CodeArea findCodeArea(BigInteger address, ILineNumbers.CodeArea[] codeAreas) {
        if (codeAreas != null) {
            ILineNumbers.CodeArea[] codeAreaArray = codeAreas;
            int n = codeAreas.length;
            int n2 = 0;
            while (n2 < n) {
                ILineNumbers.CodeArea codeArea = codeAreaArray[n2];
                if (address.equals(TCFDisassemblyBackend.toBigInteger(codeArea.start_address))) {
                    return codeArea;
                }
                ++n2;
            }
        }
        return null;
    }

    private String formatInstruction(Map<String, Object>[] instrAttrs) {
        StringBuilder buf = new StringBuilder(20);
        Map<String, Object>[] mapArray = instrAttrs;
        int n = instrAttrs.length;
        int n2 = 0;
        while (n2 < n) {
            Map<String, Object> attrs = mapArray[n2];
            Object type = attrs.get("Type");
            if ("String".equals(type) || "Register".equals(type)) {
                Object text = attrs.get("Text");
                buf.append(text);
            } else {
                Object value = attrs.get("Value");
                BigInteger bigValue = new BigInteger(value.toString());
                buf.append("0x").append(bigValue.toString(16)).append(' ');
            }
            ++n2;
        }
        return buf.toString();
    }

    public void gotoSymbol(final String symbol) {
        final TCFNodeStackFrame activeFrame = this.fActiveFrame;
        if (activeFrame == null) {
            return;
        }
        Protocol.invokeLater((Runnable)new Runnable(){

            public void run() {
                if (activeFrame != TCFDisassemblyBackend.this.fActiveFrame) {
                    return;
                }
                IChannel channel = activeFrame.getChannel();
                final IExpressions exprSvc = (IExpressions)channel.getRemoteService(IExpressions.class);
                if (exprSvc != null) {
                    TCFNodeStackFrame evalContext = activeFrame.isEmulated() ? activeFrame.getParent() : activeFrame;
                    exprSvc.create(evalContext.getID(), null, symbol, new IExpressions.DoneCreate(){

                        public void doneCreate(IToken token, Exception error, final IExpressions.Expression context) {
                            if (error == null) {
                                exprSvc.evaluate(context.getID(), new IExpressions.DoneEvaluate(){

                                    public void doneEvaluate(IToken token, Exception error, IExpressions.Value value) {
                                        if (error == null) {
                                            final BigInteger address = TCFDisassemblyBackend.toBigInteger(value.getValue(), value.isBigEndian(), false);
                                            TCFDisassemblyBackend.this.fCallback.asyncExec(new Runnable(){

                                                public void run() {
                                                    TCFDisassemblyBackend.this.fCallback.gotoAddress(address);
                                                }
                                            });
                                        } else {
                                            this.handleError(error);
                                        }
                                        exprSvc.dispose(context.getID(), new IExpressions.DoneDispose(){

                                            public void doneDispose(IToken token, Exception error) {
                                            }
                                        });
                                    }
                                });
                            } else {
                                this.handleError(error);
                            }
                        }
                    });
                }
            }

            protected void handleError(final Exception error) {
                TCFDisassemblyBackend.this.fCallback.asyncExec(new Runnable(){

                    public void run() {
                        Status status = new Status(4, "org.eclipse.tm.tcf.cdt.ui", error.getLocalizedMessage(), (Throwable)error);
                        ErrorDialog.openError((Shell)TCFDisassemblyBackend.this.fCallback.getSite().getShell(), (String)"Error", null, (IStatus)status);
                    }
                });
            }
        });
    }

    public void retrieveDisassembly(String file, int lines, BigInteger endAddress, boolean mixed, boolean showSymbols, boolean showDisassembly) {
        this.fCallback.setUpdatePending(false);
    }

    public String evaluateExpression(final String expression) {
        final TCFNodeStackFrame activeFrame = this.fActiveFrame;
        if (activeFrame == null) {
            return null;
        }
        String value = (String)new TCFTask<String>(activeFrame.getChannel()){

            public void run() {
                if (activeFrame != TCFDisassemblyBackend.this.fActiveFrame) {
                    this.done(null);
                    return;
                }
                IChannel channel = activeFrame.getChannel();
                final IExpressions exprSvc = (IExpressions)channel.getRemoteService(IExpressions.class);
                if (exprSvc != null) {
                    TCFNodeStackFrame evalContext = activeFrame.isEmulated() ? activeFrame.getParent() : activeFrame;
                    exprSvc.create(evalContext.getID(), null, expression, new IExpressions.DoneCreate(){

                        public void doneCreate(IToken token, Exception error, final IExpressions.Expression context) {
                            if (error == null) {
                                exprSvc.evaluate(context.getID(), new IExpressions.DoneEvaluate(){

                                    public void doneEvaluate(IToken token, Exception error, IExpressions.Value value) {
                                        if (error == null) {
                                            BigInteger address = TCFDisassemblyBackend.toBigInteger(value.getValue(), value.isBigEndian(), false);
                                            this.done("0x" + address.toString(16));
                                        } else {
                                            this.done(null);
                                        }
                                        exprSvc.dispose(context.getID(), new IExpressions.DoneDispose(){

                                            public void doneDispose(IToken token, Exception error) {
                                            }
                                        });
                                    }
                                });
                            } else {
                                this.done(null);
                            }
                        }
                    });
                } else {
                    this.done(null);
                }
            }
        }.getE();
        return value;
    }

    public void dispose() {
    }

    public Object insertSource(Position pos, BigInteger address, String file, int lineNumber) {
        ISourceLocator locator;
        TCFNodeExecContext execContext = this.fExecContext;
        if (execContext != null && (locator = this.fExecContext.getModel().getLaunch().getSourceLocator()) instanceof ISourceLookupDirector) {
            return ((ISourceLookupDirector)locator).getSourceElement((Object)file);
        }
        return null;
    }

    private static BigInteger toBigInteger(byte[] data, boolean big_endian, boolean sign_extension) {
        byte[] temp = null;
        if (sign_extension) {
            temp = new byte[data.length];
        } else {
            temp = new byte[data.length + 1];
            temp[0] = 0;
        }
        if (big_endian) {
            System.arraycopy(data, 0, temp, sign_extension ? 0 : 1, data.length);
        } else {
            int i = 0;
            while (i < data.length) {
                temp[temp.length - i - 1] = data[i];
                ++i;
            }
        }
        return new BigInteger(temp);
    }

    private static BigInteger toBigInteger(Number address) {
        if (address instanceof BigInteger) {
            return (BigInteger)address;
        }
        return new BigInteger(address.toString());
    }

    private static class AddressRange {
        BigInteger start;
        BigInteger end;

        private AddressRange() {
        }
    }

    private static class FunctionOffset {
        static final FunctionOffset NONE = new FunctionOffset(null, null);
        String name;
        BigInteger offset;

        FunctionOffset(String name, BigInteger offset) {
            this.name = name;
            this.offset = offset;
        }

        public String toString() {
            if (this.name == null || this.name.length() == 0) {
                return "";
            }
            if (this.isZeroOffset()) {
                return this.name;
            }
            return String.valueOf(this.name) + '+' + this.offset.toString();
        }

        boolean isZeroOffset() {
            return this.offset == null || this.offset.compareTo(BigInteger.ZERO) == 0;
        }
    }

    private class TCFChannelListener
    implements IChannel.IChannelListener {
        private TCFChannelListener() {
        }

        public void onChannelOpened() {
        }

        public void onChannelClosed(Throwable error) {
            TCFDisassemblyBackend.this.handleSessionEnded();
        }

        public void congestionLevel(int level) {
        }
    }

    private class TCFLaunchListener
    implements ILaunchesListener {
        private TCFLaunchListener() {
        }

        public void launchesRemoved(ILaunch[] launches) {
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
            if (TCFDisassemblyBackend.this.fExecContext == null) {
                return;
            }
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                if (launch == TCFDisassemblyBackend.this.fExecContext.getModel().getLaunch()) {
                    if (!launch.isTerminated()) break;
                    TCFDisassemblyBackend.this.handleSessionEnded();
                    break;
                }
                ++n2;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TCFRunControlListener
    implements IRunControl.RunControlListener {
        private TCFRunControlListener() {
        }

        public void contextAdded(IRunControl.RunControlContext[] contexts) {
        }

        public void contextChanged(IRunControl.RunControlContext[] contexts) {
        }

        public void contextRemoved(String[] context_ids) {
            String id = TCFDisassemblyBackend.this.fExecContext.getID();
            String[] stringArray = context_ids;
            int n = context_ids.length;
            int n2 = 0;
            while (n2 < n) {
                String contextId = stringArray[n2];
                if (id.equals(contextId)) {
                    TCFDisassemblyBackend.this.fCallback.handleTargetEnded();
                    return;
                }
                ++n2;
            }
        }

        public void contextSuspended(String context, String pc, String reason, Map<String, Object> params) {
            if (TCFDisassemblyBackend.this.fExecContext.getID().equals(context)) {
                TCFDisassemblyBackend.this.handleContextSuspended(pc != null ? new BigInteger(pc) : null);
            }
        }

        public void contextResumed(String context) {
            if (TCFDisassemblyBackend.this.fExecContext.getID().equals(context)) {
                TCFDisassemblyBackend.this.fCallback.handleTargetResumed();
            }
        }

        public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
            String id = TCFDisassemblyBackend.this.fExecContext.getID();
            if (id.equals(context)) {
                TCFDisassemblyBackend.this.handleContextSuspended(pc != null ? new BigInteger(pc) : null);
                return;
            }
            String[] stringArray = suspended_ids;
            int n = suspended_ids.length;
            int n2 = 0;
            while (n2 < n) {
                String contextId = stringArray[n2];
                if (id.equals(contextId)) {
                    TCFDisassemblyBackend.this.handleContextSuspended(null);
                    return;
                }
                ++n2;
            }
        }

        public void containerResumed(String[] context_ids) {
            String id = TCFDisassemblyBackend.this.fExecContext.getID();
            String[] stringArray = context_ids;
            int n = context_ids.length;
            int n2 = 0;
            while (n2 < n) {
                String contextId = stringArray[n2];
                if (id.equals(contextId)) {
                    TCFDisassemblyBackend.this.fCallback.handleTargetResumed();
                    return;
                }
                ++n2;
            }
        }

        public void contextException(String context, String msg) {
        }
    }
}

