/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.commands;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.tm.internal.tcf.debug.actions.TCFAction;
import org.eclipse.tm.internal.tcf.debug.ui.commands.StepCommand;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.tcf.protocol.IErrorReport;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IRunControl;

public class BackResumeCommand
extends StepCommand {
    public BackResumeCommand(TCFModel model) {
        super(model);
    }

    protected boolean canExecute(IRunControl.RunControlContext ctx) {
        if (ctx == null) {
            return false;
        }
        return ctx.canResume(6);
    }

    protected void execute(final IDebugCommandRequest monitor, final IRunControl.RunControlContext ctx, boolean src_step, final Runnable done) {
        new TCFAction(this.model.getLaunch(), ctx.getID()){

            public void run() {
                ctx.resume(6, 1, new IRunControl.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (error != null && (this).BackResumeCommand.this.model.getChannel().getState() == 1) {
                            IErrorReport r;
                            if (error instanceof IErrorReport && (r = (IErrorReport)error).getErrorCode() == 12) {
                                this.done();
                                return;
                            }
                            launch.removeContextActions(this.getContextID());
                            monitor.setStatus((IStatus)new Status(4, "org.eclipse.tm.tcf.debug.ui", 0, "Cannot resume: " + error.getLocalizedMessage(), (Throwable)error));
                        }
                        this.done();
                    }
                });
            }

            public void done() {
                super.done();
                done.run();
            }
        };
    }
}

