/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.commands;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm.internal.tcf.debug.model.TCFMemoryRegion;
import org.eclipse.tm.internal.tcf.debug.ui.Activator;
import org.eclipse.tm.internal.tcf.debug.ui.ImageCache;
import org.eclipse.tm.internal.tcf.debug.ui.commands.MemoryMapItemDialog;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.JSON;
import org.eclipse.tm.tcf.services.IMemory;
import org.eclipse.tm.tcf.services.IMemoryMap;
import org.eclipse.tm.tcf.util.TCFDataCache;
import org.eclipse.tm.tcf.util.TCFTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MemoryMapDialog
extends Dialog {
    private static final int SIZING_TABLE_WIDTH = 800;
    private static final int SIZING_TABLE_HEIGHT = 300;
    private static final String[] column_names = new String[]{"Address", "Size", "Flags", "File offset/section", "File name"};
    private final TCFModel model;
    private final IChannel channel;
    private final TCFNode selection;
    private Text ctx_text;
    private Table map_table;
    private TableViewer table_viewer;
    private Button ok_button;
    private Runnable update_map_buttons;
    private IMemoryMap.MemoryRegion[] org_map;
    private IMemoryMap.MemoryRegion[] cur_map;
    private TCFNodeExecContext node;
    private IMemory.MemoryContext mem_ctx;
    private ILaunchConfiguration cfg;
    private final HashSet<String> loaded_files = new HashSet();
    private String mem_map_id;
    private final IStructuredContentProvider content_provider = new IStructuredContentProvider(){

        public Object[] getElements(Object input) {
            return MemoryMapDialog.this.cur_map;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };

    MemoryMapDialog(Shell parent, TCFNode node) {
        super(parent);
        this.model = node.getModel();
        this.channel = node.getChannel();
        this.selection = node;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Symbol Files");
        shell.setImage(ImageCache.getImage("icons/memory-map.gif"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.ok_button = this.createButton(parent, 0, "&OK", true);
        this.ok_button.setEnabled(this.mem_map_id != null);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.loadData();
        this.createContextText(composite);
        this.createMemoryMapTable(composite);
        composite.setSize(composite.computeSize(-1, -1));
        return composite;
    }

    private void createContextText(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label props_label = new Label(composite, 64);
        props_label.setLayoutData((Object)new GridData(256));
        props_label.setFont(font);
        props_label.setText("&Debug context:");
        this.ctx_text = new Text(composite, 2060);
        this.ctx_text.setLayoutData((Object)new GridData(768));
        this.ctx_text.setFont(font);
        if (this.mem_map_id != null) {
            this.ctx_text.setText(this.mem_map_id);
        }
    }

    private void createMemoryMapTable(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.map_table = new Table(composite, 68356);
        this.map_table.setFont(font);
        GridData data = new GridData(1808);
        data.widthHint = 800;
        data.heightHint = 300;
        this.map_table.setLayoutData((Object)data);
        int w = 800 / (column_names.length + 8);
        int i = 0;
        while (i < column_names.length) {
            TableColumn column = new TableColumn(this.map_table, 16384, i);
            column.setMoveable(false);
            column.setText(column_names[i]);
            switch (i) {
                case 0: 
                case 1: 
                case 3: {
                    column.setWidth(w * 2);
                    break;
                }
                case 4: {
                    column.setWidth(w * 6);
                    break;
                }
                default: {
                    column.setWidth(w);
                }
            }
            ++i;
        }
        this.map_table.setHeaderVisible(true);
        this.map_table.setLinesVisible(true);
        this.map_table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                IMemoryMap.MemoryRegion r = (IMemoryMap.MemoryRegion)((IStructuredSelection)MemoryMapDialog.this.table_viewer.getSelection()).getFirstElement();
                if (r == null) {
                    return;
                }
                MemoryMapDialog.this.editRegion(r);
            }

            public void widgetSelected(SelectionEvent e) {
                MemoryMapDialog.this.update_map_buttons.run();
            }
        });
        this.table_viewer = new TableViewer(this.map_table);
        this.table_viewer.setUseHashlookup(true);
        this.table_viewer.setColumnProperties(column_names);
        this.table_viewer.setContentProvider((IContentProvider)this.content_provider);
        this.table_viewer.setLabelProvider((IBaseLabelProvider)new MapLabelProvider());
        this.table_viewer.setInput((Object)this);
        this.createMapButtons(composite);
    }

    private void createMapButtons(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        Menu menu = new Menu((Control)this.map_table);
        SelectionAdapter sel_adapter = null;
        final Button button_add = new Button(composite, 8);
        button_add.setText("&Add...");
        button_add.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashMap<String, Object> props = new HashMap<String, Object>();
                Image image = ImageCache.getImage("icons/memory-map.gif");
                if (new MemoryMapItemDialog(MemoryMapDialog.this.getShell(), image, props, true).open() == 0) {
                    if (MemoryMapDialog.this.mem_map_id != null) {
                        props.put("ID", MemoryMapDialog.this.mem_map_id);
                    }
                    Object[] arr = new IMemoryMap.MemoryRegion[MemoryMapDialog.this.cur_map.length + 1];
                    System.arraycopy(MemoryMapDialog.this.cur_map, 0, arr, 0, MemoryMapDialog.this.cur_map.length);
                    TCFMemoryRegion r = new TCFMemoryRegion(props);
                    arr[((MemoryMapDialog)MemoryMapDialog.this).cur_map.length] = r;
                    MemoryMapDialog.this.cur_map = (IMemoryMap.MemoryRegion[])arr;
                    Arrays.sort(arr);
                    MemoryMapDialog.this.table_viewer.refresh();
                }
            }
        };
        button_add.addSelectionListener((SelectionListener)sel_adapter);
        final MenuItem item_add = new MenuItem(menu, 8);
        item_add.setText("&Add...");
        item_add.addSelectionListener((SelectionListener)sel_adapter);
        final Button button_edit = new Button(composite, 8);
        button_edit.setText("E&dit...");
        button_edit.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IMemoryMap.MemoryRegion r = (IMemoryMap.MemoryRegion)((IStructuredSelection)MemoryMapDialog.this.table_viewer.getSelection()).getFirstElement();
                if (r == null) {
                    return;
                }
                MemoryMapDialog.this.editRegion(r);
            }
        };
        button_edit.addSelectionListener((SelectionListener)sel_adapter);
        final MenuItem item_edit = new MenuItem(menu, 8);
        item_edit.setText("E&dit...");
        item_edit.addSelectionListener((SelectionListener)sel_adapter);
        final Button button_remove = new Button(composite, 8);
        button_remove.setText("&Remove");
        button_remove.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IMemoryMap.MemoryRegion r = (IMemoryMap.MemoryRegion)((IStructuredSelection)MemoryMapDialog.this.table_viewer.getSelection()).getFirstElement();
                if (r == null) {
                    return;
                }
                int n = 0;
                while (n < MemoryMapDialog.this.cur_map.length) {
                    if (MemoryMapDialog.this.cur_map[n] == r) {
                        IMemoryMap.MemoryRegion[] arr = new IMemoryMap.MemoryRegion[MemoryMapDialog.this.cur_map.length - 1];
                        System.arraycopy(MemoryMapDialog.this.cur_map, 0, arr, 0, n);
                        System.arraycopy(MemoryMapDialog.this.cur_map, n + 1, arr, n, arr.length - n);
                        MemoryMapDialog.this.cur_map = arr;
                        MemoryMapDialog.this.table_viewer.refresh();
                        return;
                    }
                    ++n;
                }
            }
        };
        button_remove.addSelectionListener((SelectionListener)sel_adapter);
        final MenuItem item_remove = new MenuItem(menu, 8);
        item_remove.setText("&Remove");
        item_remove.addSelectionListener((SelectionListener)sel_adapter);
        this.map_table.setMenu(menu);
        this.update_map_buttons = new Runnable(){

            public void run() {
                IMemoryMap.MemoryRegion r = (IMemoryMap.MemoryRegion)((IStructuredSelection)MemoryMapDialog.this.table_viewer.getSelection()).getFirstElement();
                boolean manual = r != null && r.getProperties().get("ID") != null;
                button_add.setEnabled(MemoryMapDialog.this.mem_map_id != null);
                button_edit.setEnabled(r != null);
                button_remove.setEnabled(manual);
                item_add.setEnabled(MemoryMapDialog.this.mem_map_id != null);
                item_edit.setEnabled(r != null);
                item_remove.setEnabled(manual);
            }
        };
        this.update_map_buttons.run();
    }

    private void editRegion(IMemoryMap.MemoryRegion r) {
        boolean enable_editing;
        HashMap<String, Object> props = r.getProperties();
        boolean bl = enable_editing = props.get("ID") != null;
        if (enable_editing) {
            props = new HashMap<String, Object>(props);
        }
        Image image = ImageCache.getImage("icons/memory-map.gif");
        if (new MemoryMapItemDialog(this.getShell(), image, props, enable_editing).open() == 0 && enable_editing) {
            int i = 0;
            while (this.cur_map[i] != r) {
                ++i;
            }
            this.cur_map[i] = new TCFMemoryRegion(props);
            Arrays.sort(this.cur_map);
            this.table_viewer.refresh();
        }
    }

    private void readMemoryMapAttribute(ArrayList<IMemoryMap.MemoryRegion> lst, boolean own) throws Exception {
        final String map = this.cfg.getAttribute("org.eclipse.tm.tcf.debug.MemoryMap", "");
        if (map.length() == 0) {
            return;
        }
        Collection c = (Collection)new TCFTask<Collection<Object>>(){

            public void run() {
                try {
                    this.done((Collection)JSON.parseOne((byte[])map.getBytes("UTF-8")));
                }
                catch (IOException e) {
                    this.error(e);
                }
            }
        }.getIO();
        if (c == null) {
            return;
        }
        for (Object x : c) {
            Map props = (Map)x;
            if (this.mem_map_id.equals(props.get("ID")) != own) continue;
            lst.add((IMemoryMap.MemoryRegion)new TCFMemoryRegion(props));
        }
    }

    private void writeMemoryMapAttribute(final ArrayList<IMemoryMap.MemoryRegion> lst) throws Exception {
        String s = null;
        if (lst.size() > 0) {
            s = (String)new TCFTask<String>(){

                public void run() {
                    try {
                        this.done(JSON.toJSON((Object)lst));
                    }
                    catch (IOException e) {
                        this.error(e);
                    }
                }
            }.getIO();
        }
        ILaunchConfigurationWorkingCopy copy = this.cfg.getWorkingCopy();
        copy.setAttribute("org.eclipse.tm.tcf.debug.MemoryMap", s);
        copy.doSave();
    }

    private void loadData() {
        final ArrayList<IMemoryMap.MemoryRegion> lst = new ArrayList<IMemoryMap.MemoryRegion>();
        this.mem_map_id = (String)new TCFTask<String>(this.channel){

            public void run() {
                TCFDataCache<TCFNodeExecContext> mem_cache = MemoryMapDialog.this.model.searchMemoryContext(MemoryMapDialog.this.selection);
                if (mem_cache == null) {
                    this.error(new Exception("Context does not provide memory access"));
                    return;
                }
                if (!mem_cache.validate((Runnable)((Object)this))) {
                    return;
                }
                if (mem_cache.getError() != null) {
                    this.error(mem_cache.getError());
                    return;
                }
                MemoryMapDialog.this.node = (TCFNodeExecContext)mem_cache.getData();
                if (MemoryMapDialog.this.node != null) {
                    TCFDataCache<TCFNodeExecContext.MemoryRegion[]> dc = MemoryMapDialog.this.node.getMemoryMap();
                    if (!dc.validate((Runnable)((Object)this))) {
                        return;
                    }
                    if (dc.getError() != null) {
                        this.error(dc.getError());
                        return;
                    }
                    if (dc.getData() != null) {
                        TCFNodeExecContext.MemoryRegion[] memoryRegionArray = (TCFNodeExecContext.MemoryRegion[])dc.getData();
                        int n = memoryRegionArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TCFNodeExecContext.MemoryRegion m = memoryRegionArray[n2];
                            Map props = m.region.getProperties();
                            if (props.get("ID") != null) {
                                String fnm = m.region.getFileName();
                                if (fnm != null) {
                                    MemoryMapDialog.this.loaded_files.add(fnm);
                                }
                            } else {
                                lst.add(new TCFMemoryRegion(props));
                            }
                            ++n2;
                        }
                    }
                }
                String id = null;
                if (MemoryMapDialog.this.node != null) {
                    MemoryMapDialog.this.mem_ctx = (IMemory.MemoryContext)MemoryMapDialog.this.node.getMemoryContext().getData();
                    if (MemoryMapDialog.this.mem_ctx != null && (id = MemoryMapDialog.this.mem_ctx.getName()) == null) {
                        id = MemoryMapDialog.this.mem_ctx.getID();
                    }
                }
                this.done(id);
            }
        }.getE();
        this.cfg = this.model.getLaunch().getLaunchConfiguration();
        if (this.mem_map_id != null) {
            try {
                this.readMemoryMapAttribute(lst, true);
            }
            catch (Throwable x) {
                Activator.log("Invalid launch cofiguration attribute", x);
            }
        }
        this.cur_map = lst.toArray(new IMemoryMap.MemoryRegion[lst.size()]);
        Arrays.sort(this.cur_map);
        this.org_map = new IMemoryMap.MemoryRegion[this.cur_map.length];
        System.arraycopy(this.cur_map, 0, this.org_map, 0, this.cur_map.length);
    }

    protected void okPressed() {
        if (this.mem_map_id == null) {
            return;
        }
        boolean loaded_files_ok = true;
        IMemoryMap.MemoryRegion[] memoryRegionArray = this.cur_map;
        int n = this.cur_map.length;
        int n2 = 0;
        while (n2 < n) {
            String fnm;
            IMemoryMap.MemoryRegion r = memoryRegionArray[n2];
            if (r.getProperties().get("ID") != null && (fnm = r.getFileName()) != null && !this.loaded_files.contains(fnm)) {
                loaded_files_ok = false;
            }
            ++n2;
        }
        if (!loaded_files_ok || !Arrays.equals(this.org_map, this.cur_map)) {
            try {
                ArrayList<IMemoryMap.MemoryRegion> lst = new ArrayList<IMemoryMap.MemoryRegion>();
                IMemoryMap.MemoryRegion[] memoryRegionArray2 = this.cur_map;
                int n3 = this.cur_map.length;
                n = 0;
                while (n < n3) {
                    IMemoryMap.MemoryRegion r = memoryRegionArray2[n];
                    if (r.getProperties().get("ID") != null) {
                        lst.add(r);
                    }
                    ++n;
                }
                this.readMemoryMapAttribute(lst, false);
                this.writeMemoryMapAttribute(lst);
            }
            catch (Throwable x) {
                MessageBox mb = new MessageBox(this.getShell(), 33);
                mb.setText("Cannot update memory map");
                mb.setMessage(TCFModel.getErrorMessage(x, true));
                mb.open();
                return;
            }
        }
        super.okPressed();
    }

    private class MapLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private MapLabelProvider() {
        }

        public Image getColumnImage(Object element, int column) {
            return null;
        }

        public String getColumnText(Object element, int column) {
            TCFMemoryRegion r = (TCFMemoryRegion)element;
            switch (column) {
                case 0: 
                case 1: {
                    BigInteger x;
                    BigInteger bigInteger = x = column == 0 ? r.addr : r.size;
                    if (x == null) {
                        return "";
                    }
                    String s = x.toString(16);
                    int sz = MemoryMapDialog.this.mem_ctx.getAddressSize() * 2;
                    int l = sz - s.length();
                    if (l < 0) {
                        l = 0;
                    }
                    if (l > 16) {
                        l = 16;
                    }
                    return String.valueOf("0x0000000000000000".substring(0, 2 + l)) + s;
                }
                case 2: {
                    int n = r.getFlags();
                    StringBuffer bf = new StringBuffer();
                    if ((n & 1) != 0) {
                        bf.append('r');
                    }
                    if ((n & 2) != 0) {
                        bf.append('w');
                    }
                    if ((n & 4) != 0) {
                        bf.append('x');
                    }
                    return bf.toString();
                }
                case 3: {
                    Number n = r.getOffset();
                    if (n != null) {
                        BigInteger x = n instanceof BigInteger ? (BigInteger)n : new BigInteger(n.toString());
                        String s = x.toString(16);
                        int l = 16 - s.length();
                        if (l < 0) {
                            l = 0;
                        }
                        if (l > 16) {
                            l = 16;
                        }
                        return String.valueOf("0x0000000000000000".substring(0, 2 + l)) + s;
                    }
                    String s = r.getSectionName();
                    if (s != null) {
                        return s;
                    }
                    return "";
                }
                case 4: {
                    return r.getFileName();
                }
            }
            return "";
        }

        public Color getBackground(Object element, int columnIndex) {
            return MemoryMapDialog.this.map_table.getBackground();
        }

        public Color getForeground(Object element, int columnIndex) {
            TCFMemoryRegion r = (TCFMemoryRegion)element;
            if (r.getProperties().get("ID") != null) {
                return MemoryMapDialog.this.map_table.getDisplay().getSystemColor(9);
            }
            return MemoryMapDialog.this.map_table.getForeground();
        }

        public String getText(Object element) {
            return element.toString();
        }
    }
}

