/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.commands;

import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.internal.tcf.debug.ui.commands.AbstractActionDelegate;
import org.eclipse.tm.internal.tcf.debug.ui.commands.SignalsDialog;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeLaunch;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeModule;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeStackFrame;

public class SignalsCommand
extends AbstractActionDelegate {
    private static boolean isValidNode(TCFNode n) {
        if (n instanceof TCFNodeLaunch) {
            return true;
        }
        if (n instanceof TCFNodeExecContext) {
            return true;
        }
        if (n instanceof TCFNodeStackFrame) {
            return true;
        }
        return n instanceof TCFNodeModule;
    }

    protected void selectionChanged() {
        TCFNode n = this.getSelectedNode();
        this.getAction().setEnabled(SignalsCommand.isValidNode(n));
    }

    protected void run() {
        TCFNode n = this.getSelectedNode();
        if (SignalsCommand.isValidNode(n)) {
            Shell shell = this.getWindow().getShell();
            try {
                new SignalsDialog(shell, n).open();
            }
            catch (Throwable x) {
                MessageBox mb = new MessageBox(shell, 33);
                mb.setText("Cannot open Signals dialog");
                mb.setMessage(TCFModel.getErrorMessage(x, true));
                mb.open();
            }
        }
    }
}

