/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.commands;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IStepReturnHandler;
import org.eclipse.tm.internal.tcf.debug.actions.TCFActionStepOut;
import org.eclipse.tm.internal.tcf.debug.model.TCFContextState;
import org.eclipse.tm.internal.tcf.debug.ui.commands.StepCommand;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tm.tcf.services.IBreakpoints;
import org.eclipse.tm.tcf.services.IRunControl;
import org.eclipse.tm.tcf.services.IStackTrace;
import org.eclipse.tm.tcf.util.TCFDataCache;

public class StepReturnCommand
extends StepCommand
implements IStepReturnHandler {
    public StepReturnCommand(TCFModel model) {
        super(model);
    }

    protected boolean canExecute(IRunControl.RunControlContext ctx) {
        if (ctx == null) {
            return false;
        }
        if (ctx.canResume(5)) {
            return true;
        }
        if (!ctx.hasState()) {
            return false;
        }
        return ctx.canResume(0) && this.model.getLaunch().getService(IBreakpoints.class) != null;
    }

    protected void execute(IDebugCommandRequest monitor, IRunControl.RunControlContext ctx, boolean src_step, Runnable done) {
        new StepStateMachine(this.model, monitor, ctx, done);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StepStateMachine
    extends TCFActionStepOut {
        private final IDebugCommandRequest monitor;
        private final Runnable done;
        private final TCFNodeExecContext node;
        private TCFNodeStackFrame frame;

        StepStateMachine(TCFModel model, IDebugCommandRequest monitor, IRunControl.RunControlContext ctx, Runnable done) {
            super(model.getLaunch(), ctx, false);
            this.monitor = monitor;
            this.done = done;
            this.node = (TCFNodeExecContext)model.getNode(ctx.getID());
        }

        protected TCFDataCache<TCFContextState> getContextState() {
            if (this.node == null) {
                return null;
            }
            return this.node.getState();
        }

        protected TCFDataCache<IStackTrace.StackTraceContext> getStackFrame() {
            if (this.frame == null) {
                this.frame = this.node.getStackTrace().getTopFrame();
            }
            if (this.frame == null) {
                return null;
            }
            return this.frame.getStackTraceContext();
        }

        protected int getStackFrameIndex() {
            if (this.frame == null) {
                this.frame = this.node.getStackTrace().getTopFrame();
            }
            if (this.frame == null) {
                return 0;
            }
            return this.frame.getFrameNo();
        }

        protected TCFDataCache<?> getStackTrace() {
            return this.node.getStackTrace();
        }

        protected void exit(Throwable error) {
            if (this.exited) {
                return;
            }
            super.exit(error);
            if (error != null && this.node.getChannel().getState() == 1) {
                this.monitor.setStatus((IStatus)new Status(4, "org.eclipse.tm.tcf.debug.ui", 0, "Cannot step: " + error.getLocalizedMessage(), error));
            }
            this.done.run();
        }
    }
}

