/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.launch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tm.internal.tcf.debug.launch.TCFLaunchDelegate;
import org.eclipse.tm.internal.tcf.debug.ui.Activator;
import org.eclipse.tm.internal.tcf.debug.ui.ImageCache;
import org.eclipse.tm.tcf.services.IPathMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFPathMapTab
extends AbstractLaunchConfigurationTab {
    private TableViewer viewer;
    private Button button_remove;
    private Button button_new;
    private static final String[] column_ids = new String[]{"Source", "Host", "Protocol", "Destination"};
    private static final String TAB_ID = "org.eclipse.tm.tcf.launch.pathMapTab";
    private ArrayList<TCFLaunchDelegate.PathMapRule> map;
    private Exception init_error;

    public String getName() {
        return "Path Map";
    }

    public Image getImage() {
        return ImageCache.getImage("icons/path.gif");
    }

    public String getId() {
        return TAB_ID;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createTable(composite);
        this.setControl((Control)composite);
    }

    private void createTable(Composite parent) {
        Font font = parent.getFont();
        Label map_label = new Label(parent, 64);
        map_label.setLayoutData((Object)new GridData(768));
        map_label.setFont(font);
        map_label.setText("File path &map rules:");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.viewer = new TableViewer(composite, 68354);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(font);
        this.viewer.setContentProvider((IContentProvider)new FileMapContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FileMapLabelProvider());
        this.viewer.setColumnProperties(column_ids);
        CellEditor[] editors = new CellEditor[column_ids.length];
        int i = 0;
        while (i < column_ids.length) {
            TableColumn c = new TableColumn(table, 0, i);
            c.setText(column_ids[i]);
            c.setWidth(600 / column_ids.length);
            editors[i] = new TextCellEditor((Composite)table);
            ++i;
        }
        this.viewer.setCellEditors(editors);
        this.viewer.setCellModifier((ICellModifier)new FileMapCellModifier());
        this.createTableButtons(composite);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TCFPathMapTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createTableButtons(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        this.button_new = new Button(composite, 8);
        this.button_new.setText("&Add");
        this.button_new.setLayoutData((Object)new GridData(256));
        this.button_new.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TCFLaunchDelegate.PathMapRule a = new TCFLaunchDelegate.PathMapRule(new HashMap());
                a.getProperties().put("ID", "PR" + System.currentTimeMillis());
                TCFPathMapTab.this.map.add(a);
                TCFPathMapTab.this.viewer.add((Object)a);
                TCFPathMapTab.this.viewer.setSelection((ISelection)new StructuredSelection((Object)a), true);
                TCFPathMapTab.this.viewer.getTable().setFocus();
                TCFPathMapTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.button_remove = new Button(composite, 8);
        this.button_remove.setText("&Remove");
        this.button_remove.setLayoutData((Object)new GridData(256));
        this.button_remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (TCFLaunchDelegate.PathMapRule a : (IStructuredSelection)TCFPathMapTab.this.viewer.getSelection()) {
                    TCFPathMapTab.this.map.remove(a);
                    TCFPathMapTab.this.viewer.remove((Object)a);
                }
                TCFPathMapTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    List<IPathMap.PathMapRule> getPathMap() {
        ArrayList<TCFLaunchDelegate.PathMapRule> l = new ArrayList<TCFLaunchDelegate.PathMapRule>();
        for (TCFLaunchDelegate.PathMapRule r : this.map) {
            l.add(r);
        }
        return Collections.unmodifiableList(l);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        try {
            String s = config.getAttribute("org.eclipse.tm.tcf.debug.PathMap", "");
            this.map = TCFLaunchDelegate.parsePathMapAttribute((String)s);
            this.viewer.setInput((Object)config);
            this.button_remove.setEnabled(!this.viewer.getSelection().isEmpty());
        }
        catch (Exception e) {
            this.init_error = e;
            this.setErrorMessage("Cannot read launch configuration: " + e);
            Activator.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        StringBuffer bf = new StringBuffer();
        for (TCFLaunchDelegate.PathMapRule m : this.map) {
            bf.append(m.toString());
        }
        if (bf.length() == 0) {
            config.removeAttribute("org.eclipse.tm.tcf.debug.PathMap");
        } else {
            config.setAttribute("org.eclipse.tm.tcf.debug.PathMap", bf.toString());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.removeAttribute("org.eclipse.tm.tcf.debug.PathMap");
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
        this.button_remove.setEnabled(!this.viewer.getSelection().isEmpty());
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setMessage(null);
        if (this.init_error != null) {
            this.setErrorMessage("Cannot read launch configuration: " + this.init_error);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private class FileMapCellModifier
    implements ICellModifier {
        private FileMapCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            TCFLaunchDelegate.PathMapRule a;
            Object o;
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            if ((o = (a = (TCFLaunchDelegate.PathMapRule)element).getProperties().get(property)) == null) {
                return "";
            }
            return o.toString();
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            TCFLaunchDelegate.PathMapRule a = (TCFLaunchDelegate.PathMapRule)element;
            if ("".equals(value)) {
                a.getProperties().remove(property);
            } else {
                a.getProperties().put(property, value);
            }
            TCFPathMapTab.this.viewer.update(element, new String[]{property});
            TCFPathMapTab.this.updateLaunchConfigurationDialog();
        }
    }

    private class FileMapContentProvider
    implements IStructuredContentProvider {
        private FileMapContentProvider() {
        }

        public Object[] getElements(Object input) {
            return TCFPathMapTab.this.map.toArray(new TCFLaunchDelegate.PathMapRule[TCFPathMapTab.this.map.size()]);
        }

        public void inputChanged(Viewer viewer, Object old_input, Object new_input) {
        }

        public void dispose() {
        }
    }

    private class FileMapLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private FileMapLabelProvider() {
        }

        public Image getColumnImage(Object element, int column) {
            if (column == 0) {
                return ImageCache.getImage("icons/attribute.gif");
            }
            return null;
        }

        public String getColumnText(Object element, int column) {
            TCFLaunchDelegate.PathMapRule e = (TCFLaunchDelegate.PathMapRule)element;
            Object o = e.getProperties().get(column_ids[column]);
            if (o == null) {
                return "";
            }
            return o.toString();
        }
    }
}

