/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.launch.setup;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.eclipse.tm.internal.tcf.debug.ui.launch.setup.AbstractRemoteShell;
import org.eclipse.tm.internal.tcf.debug.ui.launch.setup.TelnetInputStream;
import org.eclipse.tm.internal.tcf.debug.ui.launch.setup.TimeOutInputStream;

class TelnetClient
extends AbstractRemoteShell {
    private Socket socket;
    private boolean logged;

    TelnetClient(InetAddress address, int port, String user, String password) throws Exception {
        this.socket = new Socket(address, port);
        this.socket.setTcpNoDelay(true);
        FilterInputStream ist = new BufferedInputStream(this.socket.getInputStream());
        BufferedOutputStream ost = new BufferedOutputStream(this.socket.getOutputStream());
        ist = new TelnetInputStream(ist, ost, true, "***SHELL***>");
        ist = new TimeOutInputStream(ist, 512, 30000L);
        this.out = new PrintWriter(ost, true);
        this.inp = new BufferedReader(new InputStreamReader((InputStream)ist, "UTF-8"));
        this.expect("ogin: ");
        this.write(String.valueOf(user) + "\n");
        this.expect("assword: ");
        this.write(String.valueOf(password) + "\n");
        int i = this.expect(new String[]{"incorrect", "***SHELL***>", "$ ", "# ", "> "});
        if (i == 0) {
            this.close();
            throw new Exception("Login incorrect");
        }
        this.logged = true;
        this.write("export PS1=\"***SHELL***>\"\n");
        this.expect("***SHELL***>\"\n");
        this.waitPrompt();
    }

    public synchronized void close() throws IOException {
        block5: {
            if (this.socket == null) {
                return;
            }
            if (this.logged) {
                this.write("exit\n");
                this.logged = false;
            }
            this.out.close();
            try {
                char[] buf = new char[256];
                while (this.inp.read(buf) >= 0) {
                }
            }
            catch (SocketException x) {
                if (x.getMessage().startsWith("Socket closed")) break block5;
                throw x;
            }
        }
        this.inp.close();
        this.socket.close();
        this.socket = null;
        this.inp = null;
        this.out = null;
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

