/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFChildren;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeArrayPartition;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNodeExpression;
import org.eclipse.tm.tcf.services.IExpressions;
import org.eclipse.tm.tcf.services.ISymbols;
import org.eclipse.tm.tcf.util.TCFDataCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFChildrenSubExpressions
extends TCFChildren {
    private final int par_level;
    private final int par_offs;
    private final int par_size;

    TCFChildrenSubExpressions(TCFNode node, int par_level, int par_offs, int par_size) {
        super(node, 128);
        this.par_level = par_level;
        this.par_offs = par_offs;
        this.par_size = par_size;
    }

    void onSuspended() {
        this.reset();
        for (TCFNode n : this.getNodes()) {
            if (n instanceof TCFNodeExpression) {
                ((TCFNodeExpression)n).onSuspended();
            }
            if (!(n instanceof TCFNodeArrayPartition)) continue;
            ((TCFNodeArrayPartition)n).onSuspended();
        }
    }

    void onValueChanged() {
        this.reset();
        for (TCFNode n : this.getNodes()) {
            if (n instanceof TCFNodeExpression) {
                ((TCFNodeExpression)n).onValueChanged();
            }
            if (!(n instanceof TCFNodeArrayPartition)) continue;
            ((TCFNodeArrayPartition)n).onValueChanged();
        }
    }

    void onRegisterValueChanged() {
        this.reset();
        for (TCFNode n : this.getNodes()) {
            if (n instanceof TCFNodeExpression) {
                ((TCFNodeExpression)n).onRegisterValueChanged();
            }
            if (!(n instanceof TCFNodeArrayPartition)) continue;
            ((TCFNodeArrayPartition)n).onRegisterValueChanged();
        }
    }

    void onCastToTypeChanged() {
        this.cancel();
        TCFNode[] a = this.getNodes().toArray(new TCFNode[this.getNodes().size()]);
        int i = 0;
        while (i < a.length) {
            a[i].dispose();
            ++i;
        }
    }

    private TCFNodeExpression findField(String field_id, boolean deref) {
        assert (field_id != null);
        for (TCFNode n : this.getNodes()) {
            TCFNodeExpression e = (TCFNodeExpression)n;
            if (!field_id.equals(e.getFieldID()) || e.isDeref() != deref) continue;
            return e;
        }
        return null;
    }

    private boolean findFields(ISymbols.Symbol type, Map<String, TCFNode> map, boolean deref) {
        TCFDataCache<String[]> children_cache = this.node.model.getSymbolChildrenCache(type.getID());
        if (children_cache == null) {
            return true;
        }
        if (!children_cache.validate((Runnable)((Object)this))) {
            return false;
        }
        String[] children = (String[])children_cache.getData();
        if (children == null) {
            return true;
        }
        TCFDataCache<ISymbols.Symbol> pending = null;
        String[] stringArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            TCFDataCache<ISymbols.Symbol> sym_cache = this.node.model.getSymbolInfoCache(id);
            if (!sym_cache.validate()) {
                pending = sym_cache;
            } else {
                ISymbols.Symbol sym_data = (ISymbols.Symbol)sym_cache.getData();
                if (sym_data != null && sym_data.getSymbolClass() == ISymbols.SymbolClass.reference) {
                    if (sym_data.getName() == null) {
                        if (!this.findFields(sym_data, map, deref)) {
                            return false;
                        }
                    } else {
                        TCFNodeExpression n3 = this.findField(id, deref);
                        if (n3 == null) {
                            n3 = new TCFNodeExpression(this.node, null, id, null, -1, deref);
                            this.add(n3);
                        }
                        n3.setSortPosition(map.size());
                        map.put(n3.id, n3);
                    }
                }
            }
            ++n2;
        }
        if (pending == null) {
            return true;
        }
        pending.wait((Runnable)((Object)this));
        return false;
    }

    private TCFNodeExpression findIndex(int index, boolean deref) {
        assert (index >= 0);
        for (TCFNode n : this.getNodes()) {
            TCFNodeExpression e = (TCFNodeExpression)n;
            if (e.getIndex() != index || e.isDeref() != deref) continue;
            return e;
        }
        return null;
    }

    private TCFNodeArrayPartition findPartition(int offs, int size) {
        assert (offs >= 0);
        for (TCFNode n : this.getNodes()) {
            TCFNodeArrayPartition e = (TCFNodeArrayPartition)n;
            if (e.getOffset() != offs || e.getSize() != size) continue;
            return e;
        }
        return null;
    }

    protected boolean startDataRetrieval() {
        assert (!this.isDisposed());
        TCFNode exp = this.node;
        while (exp != null) {
            if (exp instanceof TCFNodeExpression) break;
            exp = exp.parent;
        }
        TCFDataCache<ISymbols.Symbol> type_cache = ((TCFNodeExpression)exp).getType();
        if (!type_cache.validate((Runnable)((Object)this))) {
            return false;
        }
        ISymbols.Symbol type_data = (ISymbols.Symbol)type_cache.getData();
        if (type_data == null) {
            this.set(null, null, new HashMap<String, TCFNode>());
            return true;
        }
        ISymbols.TypeClass type_class = type_data.getTypeClass();
        HashMap<String, TCFNode> data = new HashMap<String, TCFNode>();
        if (this.par_level <= 0 || type_class == ISymbols.TypeClass.array) {
            if (type_class == ISymbols.TypeClass.composite) {
                if (!this.findFields(type_data, data, false)) {
                    return false;
                }
            } else if (type_class == ISymbols.TypeClass.array) {
                int size;
                int offs = this.par_level > 0 ? this.par_offs : 0;
                int n = size = this.par_level > 0 ? this.par_size : type_data.getLength();
                if (size <= 100) {
                    int i = offs;
                    while (i < offs + size) {
                        TCFNodeExpression n2 = this.findIndex(i, false);
                        if (n2 == null) {
                            n2 = new TCFNodeExpression(this.node, null, null, null, i, false);
                        }
                        n2.setSortPosition(i);
                        data.put(n2.id, n2);
                        ++i;
                    }
                } else {
                    int next_size = 100;
                    while (size / next_size > 100) {
                        next_size *= 100;
                    }
                    int i = offs;
                    while (i < offs + size) {
                        TCFNodeArrayPartition n3;
                        int sz = next_size;
                        if (i + sz > offs + size) {
                            sz = offs + size - i;
                        }
                        if ((n3 = this.findPartition(i, sz)) == null) {
                            n3 = new TCFNodeArrayPartition(this.node, this.par_level + 1, i, sz);
                        }
                        data.put(n3.id, n3);
                        i += next_size;
                    }
                }
            } else if (type_class == ISymbols.TypeClass.pointer) {
                TCFDataCache<ISymbols.Symbol> base_type_cache;
                TCFDataCache<IExpressions.Value> value = ((TCFNodeExpression)exp).getValue();
                if (!value.validate((Runnable)((Object)this))) {
                    return false;
                }
                IExpressions.Value v = (IExpressions.Value)value.getData();
                if (v != null && !this.isNull(v.getValue()) && (base_type_cache = this.node.model.getSymbolInfoCache(type_data.getBaseTypeID())) != null) {
                    if (!base_type_cache.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    ISymbols.Symbol base_type_data = (ISymbols.Symbol)base_type_cache.getData();
                    if (base_type_data != null && base_type_data.getTypeClass() != ISymbols.TypeClass.function && base_type_data.getSize() > 0) {
                        if (base_type_data.getTypeClass() == ISymbols.TypeClass.composite) {
                            if (!this.findFields(base_type_data, data, true)) {
                                return false;
                            }
                        } else {
                            TCFNodeExpression n = this.findIndex(0, true);
                            if (n == null) {
                                n = new TCFNodeExpression(this.node, null, null, null, 0, true);
                            }
                            n.setSortPosition(0);
                            data.put(n.id, n);
                        }
                    }
                }
            }
        }
        this.set(null, null, data);
        return true;
    }

    private boolean isNull(byte[] data) {
        if (data == null) {
            return true;
        }
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

