/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.debug.ui.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.tm.internal.tcf.debug.model.TCFLaunch;
import org.eclipse.tm.internal.tcf.debug.ui.Activator;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFModel;
import org.eclipse.tm.internal.tcf.debug.ui.model.TCFNode;
import org.eclipse.tm.tcf.protocol.Protocol;

public class TCFModelManager {
    private final Map<TCFLaunch, TCFModel> models = new HashMap<TCFLaunch, TCFModel>();
    private final List<ModelManagerListener> listeners = new ArrayList<ModelManagerListener>();
    private final TCFLaunch.LaunchListener tcf_launch_listener = new TCFLaunch.LaunchListener(){

        public void onCreated(TCFLaunch launch) {
            if (!$assertionsDisabled && !Protocol.isDispatchThread()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && TCFModelManager.this.models.get(launch) != null) {
                throw new AssertionError();
            }
            TCFModel model = new TCFModel(launch);
            TCFModelManager.this.models.put(launch, model);
        }

        public void onConnected(TCFLaunch launch) {
            if (!$assertionsDisabled && !Protocol.isDispatchThread()) {
                throw new AssertionError();
            }
            TCFModel model = (TCFModel)TCFModelManager.this.models.get(launch);
            if (model != null) {
                model.onConnected();
            }
            for (ModelManagerListener l : TCFModelManager.this.listeners) {
                try {
                    l.onConnected(launch, model);
                }
                catch (Throwable x) {
                    Activator.log(x);
                }
            }
        }

        public void onDisconnected(TCFLaunch launch) {
            if (!$assertionsDisabled && !Protocol.isDispatchThread()) {
                throw new AssertionError();
            }
            TCFModel model = (TCFModel)TCFModelManager.this.models.get(launch);
            if (model != null) {
                model.onDisconnected();
            }
            for (ModelManagerListener l : TCFModelManager.this.listeners) {
                try {
                    l.onDisconnected(launch, model);
                }
                catch (Throwable x) {
                    Activator.log(x);
                }
            }
        }

        public void onProcessOutput(TCFLaunch launch, String process_id, int stream_id, byte[] data) {
            if (!$assertionsDisabled && !Protocol.isDispatchThread()) {
                throw new AssertionError();
            }
            TCFModel model = (TCFModel)TCFModelManager.this.models.get(launch);
            if (model != null) {
                model.onProcessOutput(process_id, stream_id, data);
            }
        }

        public void onProcessStreamError(TCFLaunch launch, String process_id, int stream_id, Exception error, int lost_size) {
            if (!$assertionsDisabled && !Protocol.isDispatchThread()) {
                throw new AssertionError();
            }
            TCFModel model = (TCFModel)TCFModelManager.this.models.get(launch);
            if (model != null) {
                model.onProcessStreamError(process_id, stream_id, error, lost_size);
            }
        }
    };
    private final ILaunchesListener debug_launch_listener = new ILaunchesListener(){

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(final ILaunch[] launches) {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                public void run() {
                    ILaunch[] iLaunchArray = launches;
                    int n = launches.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunch launch = iLaunchArray[n2];
                        TCFModel model = (TCFModel)TCFModelManager.this.models.get(launch);
                        if (model != null) {
                            model.launchChanged();
                        }
                        ++n2;
                    }
                }
            });
        }

        public void launchesRemoved(final ILaunch[] launches) {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                public void run() {
                    ILaunch[] iLaunchArray = launches;
                    int n = launches.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunch launch = iLaunchArray[n2];
                        TCFModel model = (TCFModel)TCFModelManager.this.models.remove(launch);
                        if (model != null) {
                            model.dispose();
                        }
                        ++n2;
                    }
                }
            });
        }
    };

    public TCFModelManager() {
        assert (Protocol.isDispatchThread());
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(this.debug_launch_listener);
        TCFLaunch.addListener((TCFLaunch.LaunchListener)this.tcf_launch_listener);
    }

    public void dispose() {
        assert (Protocol.isDispatchThread());
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener(this.debug_launch_listener);
        TCFLaunch.removeListener((TCFLaunch.LaunchListener)this.tcf_launch_listener);
        Iterator<TCFModel> i = this.models.values().iterator();
        while (i.hasNext()) {
            TCFModel model = i.next();
            model.dispose();
            i.remove();
        }
        assert (this.models.isEmpty());
    }

    public void addListener(ModelManagerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ModelManagerListener l) {
        this.listeners.remove(l);
    }

    public TCFModel getModel(TCFLaunch launch) {
        assert (Protocol.isDispatchThread());
        return this.models.get(launch);
    }

    public TCFNode getRootNode(TCFLaunch launch) {
        TCFModel model = this.getModel(launch);
        if (model == null) {
            return null;
        }
        return model.getRootNode();
    }

    public static TCFModelManager getModelManager() {
        return Activator.getModelManager();
    }

    public static interface ModelManagerListener {
        public void onConnected(TCFLaunch var1, TCFModel var2);

        public void onDisconnected(TCFLaunch var1, TCFModel var2);
    }
}

