/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.rse.shells;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IStreams;
import org.eclipse.tm.tcf.util.TCFTask;

public class TCFTerminalOutputStream
extends OutputStream {
    private final IStreams streams;
    private boolean connected = true;
    private boolean write_eof;
    String os_id;

    public TCFTerminalOutputStream(IStreams streams, String os_id) throws IOException {
        if (streams == null) {
            throw new IOException("istream is null");
        }
        this.streams = streams;
        this.os_id = os_id;
        this.write_eof = false;
    }

    public synchronized void write(final byte[] b, final int off, final int len) throws IOException {
        if (!this.connected || this.write_eof) {
            throw new IOException("stream is not connected or write_eof already!");
        }
        try {
            new TCFTask<Object>(){

                public void run() {
                    TCFTerminalOutputStream.this.streams.write(TCFTerminalOutputStream.this.os_id, b, off, len, new IStreams.DoneWrite(){

                        public void doneWrite(IToken token, Exception error) {
                            if (error != null) {
                                this.error(error);
                            }
                            this.done(this);
                        }
                    });
                }
            }.getIO();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public synchronized void write(int b) throws IOException {
        try {
            byte[] buf = new byte[]{(byte)b};
            this.write(buf, 0, 1);
        }
        catch (IOException ioe) {
            throw new IOException(ioe.getMessage());
        }
    }

    public void close() throws IOException {
        if (!this.connected) {
            return;
        }
        try {
            new TCFTask<Object>(){

                public void run() {
                    TCFTerminalOutputStream.this.streams.eos(TCFTerminalOutputStream.this.os_id, new IStreams.DoneEOS(){

                        public void doneEOS(IToken token, Exception error) {
                            TCFTerminalOutputStream.this.write_eof = true;
                            this.done(this);
                        }
                    });
                }
            }.getIO();
            new TCFTask<Object>(){

                public void run() {
                    TCFTerminalOutputStream.this.streams.disconnect(TCFTerminalOutputStream.this.os_id, new IStreams.DoneDisconnect(){

                        public void doneDisconnect(IToken token, Exception error) {
                            TCFTerminalOutputStream.this.connected = false;
                            this.done(this);
                        }
                    });
                }
            }.getIO();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

