/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSpecialization;
import org.eclipse.core.runtime.Assert;

public class CPPTypedefSpecialization
extends CPPSpecialization
implements ITypedef,
ITypeContainer {
    public static final int MAX_RESOLUTION_DEPTH = 5;
    private IType type;
    private int fResolutionDepth;

    public CPPTypedefSpecialization(IBinding specialized, ICPPClassType owner, ICPPTemplateParameterMap tpmap) {
        super(specialized, owner, tpmap);
    }

    private ITypedef getTypedef() {
        return (ITypedef)this.getSpecializedBinding();
    }

    public IType getType() throws DOMException {
        if (this.type == null) {
            try {
                if (++this.fResolutionDepth > 5) {
                    this.type = new RecursionResolvingBinding(this.getDefinition(), this.getNameCharArray());
                } else {
                    IBinding owner;
                    ITypedef td;
                    this.type = this.specializeType(this.getTypedef().getType());
                    if (this.type instanceof ITypedef && this.type instanceof ICPPSpecialization && CharArrayUtils.equals((td = (ITypedef)this.type).getNameCharArray(), this.getNameCharArray()) && (owner = ((ICPPSpecialization)((Object)this.type)).getOwner()) instanceof IType && ((IType)((Object)owner)).isSameType((ICPPClassType)this.getOwner())) {
                        this.type = new RecursionResolvingBinding(this.getDefinition(), this.getNameCharArray());
                    }
                }
            }
            finally {
                --this.fResolutionDepth;
            }
        }
        return this.type;
    }

    public int incResolutionDepth(int increment) {
        this.fResolutionDepth += increment;
        return this.fResolutionDepth;
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public boolean isSameType(IType o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ITypedef) {
            try {
                IType t = this.getType();
                if (t != null) {
                    return t.isSameType(((ITypedef)o).getType());
                }
                return false;
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        try {
            IType t = this.getType();
            if (t != null) {
                return t.isSameType(o);
            }
        }
        catch (DOMException dOMException) {
            return false;
        }
        return false;
    }

    public void setType(IType type) {
        this.type = type;
    }

    static final class RecursionResolvingBinding
    extends ProblemBinding {
        public RecursionResolvingBinding(IASTNode node, char[] arg) {
            super(node, 14, arg);
            Assert.isTrue((boolean)CPPASTName.sAllowRecursionBindings, (String)this.getMessage());
        }
    }
}

